<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined ( '_JEXEC' ) or die ();

class MarketingrocketControllerEmail extends JControllerForm {
    
    public function preview(){
        
        
        if($this->input->getInt('id', 0) != 0 && !$this->input->get(JComponentHelper::getParams('com_marketingrocket')->get('salt'), '', 'alnum'))
            return JError::raiseError(404, JText::_('COM_MARKETINGROCKET_ERROR_NOT_FOUND'));
        
        
        $id = $this->input->getInt('id', 0);
        $refCode = $this->input->get('ref', '');
        
        JModelLegacy::addIncludePath(JPATH_COMPONENT_SITE.DS.'models');
        $cronModel = JModelLegacy::getInstance('Cron', 'MarketingrocketModel');

        $db = JFactory::getDbo();

        $query = $cronModel->getQuerySelect();
        $query->clear('where');

        if(empty($refCode))
            $query->where($db->qn('a.id').' = '.$id);
        else 
            $query->where($db->qn('a.ref').' = '.$db->q($refCode));
        
        
        $query->where($db->qn('b.published').' = 1');

        $db->setQuery($query);
        $row = $db->loadObject();
        
        if(empty($row)){
            return JError::raiseError(404, JText::_('COM_MARKETINGROCKET_ERROR_NOT_FOUND'));
        }
        
        require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'tables'.DS.'lead.php';

        $leadTable = JTable::getInstance('Lead', 'MarketingrocketTable');

        $leadTable->bind(array('id' => $row->lead_id));

        $form_data = $leadTable->getFormData();
        
        $body = $row->body;
        if(!$row->sent_body)
            $body = $row->sent_body;
        
        require_once JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'helpers'.DS.'mr_route.php';
        $url = MRRoute::createFrontRoute('');
        if(strpos($body, '<head>') === false){
        echo '<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	  <meta http-equiv="content-type" content="text/html; charset=utf-8" /></head><body>';
        }
        if(!empty($row->sent_body))
            echo $row->sent_body;
        else 
            echo $cronModel->prepareBody($row , $form_data, $url, '');
        if(strpos($body, '<head>') === false){
            echo '</body></html>';
        }
        die;
    }
}
