<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */
// no direct access
defined('_JEXEC') or die;
defined('DS') or define('DS', DIRECTORY_SEPARATOR);

abstract class ModMRMenuHelper {


	public static function getVMComponent($authCheck = true) {

		$lang	= JFactory::getLanguage();
		$user		= JFactory::getUser();

		$db = JFactory::getDBO();
		/*$q = 'SELECT m.id, m.title, m.alias, m.link, m.parent_id, m.img, e.element FROM `#__menu` as m
				LEFT JOIN #__extensions AS e ON m.component_id = e.extension_id
		         WHERE e.enabled = 1 AND e.element = \'com_virtuemart\' AND m.client_id=1
		         ORDER BY m.lft';*/
		$q = 'SELECT m.id, m.title, m.alias, m.link, m.parent_id, m.img, e.element FROM `#__menu` as m
				LEFT JOIN #__extensions AS e ON m.component_id = e.extension_id
		         WHERE m.client_id = 1 AND e.enabled = 1 AND m.id > 1 AND e.element = \'com_marketingrocket\'
		         AND (m.parent_id=1 OR m.parent_id =
			                        (SELECT m.id FROM `#__menu` as m
									LEFT JOIN #__extensions AS e ON m.component_id = e.extension_id
			                        WHERE m.parent_id=1 AND m.client_id = 1 AND e.enabled = 1 AND m.id > 1 AND e.element = \'com_marketingrocket\'))
		         ORDER BY m.lft';
		$db->setQuery($q);

		$ComponentItems = $db->loadObjectList();
		$result = new stdClass();
		if ($ComponentItems) {

			// Parse the list of extensions.
			foreach ($ComponentItems as &$ComponentItem) {
				$ComponentItem->link = trim($ComponentItem->link);
				if ($ComponentItem->parent_id == 1) {
					if ($authCheck == false || ($authCheck && $user->authorise('core.manage', $ComponentItem->element))) {
						$result = $ComponentItem;
						if (!isset($result->submenu)) {
							$result->submenu = array();
						}

						if (empty($ComponentItem->link)) {
							$ComponentItem->link = 'index.php?option=' . $ComponentItem->element;
						}

						$ComponentItem->text = $lang->hasKey($ComponentItem->title) ? JText::_($ComponentItem->title) : $ComponentItem->alias;
					}
				} else {
					// Sub-menu level.
					if (isset($result)) {
						// Add the submenu link if it is defined.
						if (isset($result->submenu) && !empty($ComponentItem->link)) {
							$ComponentItem->text = $lang->hasKey($ComponentItem->title) ? JText::_($ComponentItem->title) : $ComponentItem->alias;

							$class = preg_replace('#\.[^.]*$#', '', basename($ComponentItem->img));
							$class = preg_replace('#\.\.[^A-Za-z0-9\.\_\- ]#', '', $class);
							$ComponentItem->class='';
							$result->submenu[] = & $ComponentItem;
						}
					}
				}
			}

			return $result;
		} else {
			return NULL;
		}


	}

}
