<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_marketingrocket/models', 'MarketingrocketModel');

abstract class ModMaketingRocketHelper
{
	/**
	 * Get a list of the most popular articles
	 *
	 * @param   JObject  &$params  The module parameters.
	 *
	 * @return  array
	 */
	public static function getList(&$params)
	{
		$reportModel = JModelLegacy::getInstance('Reports', 'MarketingrocketModel', array('ignore_request' => true));
		
		$returnObj = new stdClass();
		
		$returnObj->list = $reportModel->getItems();
		$returnObj->stats = $reportModel->getDailyStat();
                
                $returnObj->prevMonthStat = $reportModel->getPrevMonthStat();
                
		$returnObj->convertedCount = $reportModel->getConvertedCount();
		
		$returnObj->prevMonthConverted = $reportModel->getConvertedCount(strtotime("first day of last month"), strtotime("last day of last month"));
		
		$totalView = 0;
		$totalSubmission = 0;
		foreach ($returnObj->stats as $row){
			$totalView += $row->visits;
			$totalSubmission += $row->submissions;
		}
		$returnObj->totalView = $totalView;
		$returnObj->totalSubmission = $totalSubmission;
		
		$returnObj->endTime = time();
		$startDate = date('Y-m');
		$startDate = $startDate.'-1';
		$returnObj->time = strtotime($startDate);
	  
		$document =  JFactory::getDocument ();
		$document->addScript ( JURI::base() . '/components/com_marketingrocket/assets/js/highcharts-custom.js', "text/javascript" , true );
		return $returnObj; 
	}

}
