<?php
/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2016 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

// no direct access
defined('_JEXEC') or die();

class OSMembershipModelCoupon extends MPFModelAdmin
{
	/**
	 * Get list of subscription records which use the current coupon code
	 *
	 * @return array
	 */
	public function getSubscriptions()
	{
		if ($this->state->id)
		{
			$db    = $this->getDbo();
			$query = $db->getQuery(true);
			$query->select('id, first_name, last_name, email, created_date, amount')
				->from('#__osmembership_subscribers')
				->where('coupon_id = ' . $this->state->id)
				->order('id');
			$db->setQuery($query);

			return $db->loadObjectList();
		}

		return array();
	}

	/**
	 * @param $file
	 *
	 * @return int
	 * @throws Exception
	 */
	public function import($file)
	{
		$coupons = OSMembershipHelperData::getDataFromFile($file);

		// Get list of plans
		$db    = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('id, title')
			->from('#__osmembership_plans');
		$db->setQuery($query);
		$rows = $db->loadObjectList();

		$plans = array();

		foreach ($rows as $row)
		{
			$plans[JString::strtolower($row->title)] = $row->id;
		}

		$imported = 0;

		if (count($coupons))
		{
			foreach ($coupons as $coupon)
			{
				if (empty($coupon['code']) || empty($coupon['discount']))
				{
					continue;
				}

				$row = $this->getTable();

				if (!empty($coupon['id']))
				{
					$row->load($coupon['id']);
				}

				// Get plan Id
				$planTitle         = JString::strtolower($coupon['plan']);
				$planId            = isset($plans[$planTitle]) ? $plans[$planTitle] : 0;
				$coupon['plan_id'] = $planId;

				if ($coupon['valid_from'])
				{
					$coupon ['valid_from'] = JHtml::date($coupon['valid_from'], 'Y-m-d');
				}
				else
				{
					$coupon ['valid_from'] = '';
				}

				if ($coupon['valid_to'])
				{
					$coupon ['valid_to'] = JHtml::date($coupon['valid_to'], 'Y-m-d');
				}
				else
				{
					$coupon ['valid_to'] = '';
				}

				$row->bind($coupon, array('id'));
				$row->store();

				$imported++;
			}
		}

		return $imported;
	}

	/**
	 * Generate batch coupon
	 *
	 * @param MPFInput $input
	 */
	public function batch($input)
	{
		$numberCoupon        = $input->getInt('number_coupon', 50);
		$charactersSet       = $input->getString('characters_set');
		$prefix              = $input->getString('prefix');
		$length              = $input->getInt('length', 20);
		$data                = array();
		$data['discount']    = $input->getFloat('discount', 0);
		$data['coupon_type'] = $input->getInt('coupon_type', 0);
		$data['times']       = $input->getInt('times');

		$data['plan_id'] = $input->getInt('plan_id', 0);

		if ($input->getString('valid_from'))
		{
			$data ['valid_from'] = JHtml::date($input->getString('valid_from'), 'Y-m-d', null);
		}
		else
		{
			$data ['valid_from'] = '';
		}

		if ($input->getString('valid_to'))
		{
			$data ['valid_to'] = JHtml::date($input->getString('valid_to'), 'Y-m-d', null);
		}
		else
		{
			$data ['valid_to'] = '';
		}
		$data['used']       = 0;
		$data ['published'] = $input->getInt('published');

		for ($i = 0; $i < $numberCoupon; $i++)
		{
			$salt         = static::genRandomCoupon($length, $charactersSet);
			$couponCode   = $prefix . $salt;
			$row          = $this->getTable();
			$data['code'] = $couponCode;

			$row->bind($data);
			$row->store();
		}
	}

	/**
	 * Generate random Coupon
	 *
	 * @param int    $length
	 * @param string $charactersSet
	 *
	 * @return string
	 */
	private static function genRandomCoupon($length = 8, $charactersSet)
	{
		$salt = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

		if ($charactersSet)
		{
			$salt = $charactersSet;
		}

		$base     = strlen($salt);
		$makePass = '';

		/*
		 * Start with a cryptographic strength random string, then convert it to
		 * a string with the numeric base of the salt.
		 * Shift the base conversion on each character so the character
		 * distribution is even, and randomize the start shift so it's not
		 * predictable.
		 */
		$random = JCrypt::genRandomBytes($length + 1);
		$shift  = ord($random[0]);

		for ($i = 1; $i <= $length; ++$i)
		{
			$makePass .= $salt[($shift + ord($random[$i])) % $base];
			$shift += ord($random[$i]);
		}

		return $makePass;
	}
}
