<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class MarketingrocketViewWizard extends JViewLegacy
{
	
	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );
                
                $input = JFactory::getApplication()->input;
                
                $session = JFactory::getSession();
                $template = $session->get( 'wizard', null, 'com_marketingrocket');
                if(empty($template)){
                   $force = true; 
                   
                }
                if($input->getInt('step', 0) > 0 && empty($force)){
                    $step = $input->getInt('step');
                    $showStep = $input->getInt('showstep', 0);
                    $this->showStep = $showStep;
                    if($step == 1)
                        $tpl = 'step'.$step;
                    else {
                        $this->item = $template->items[$step-2];
                        if(!isset($template->items[$step-1])){
                            $this->canDone = true;
                        }
                        $tpl = $this->item->type;
                        
                        if($this->item->type == 'landing'){
                            $landingTemplateModel = JModelLegacy::getInstance('landingtemplate', 'MarketingrocketModel', array('ignore_request' => true));
                            
                            $this->items = $landingTemplateModel->getItems();
                            $this->types = $landingTemplateModel->getTypes();
                            $this->typeSelected = $template->items[$step-2]->options->type;
                            $this->canDelete = false;
                        }
                        else {
                            
//                            Zend_Debug::dump($this->item);
//                            die;
                            
                            $responderModel = JModelLegacy::getInstance('Responder', 'MarketingrocketModel', array('ignore_request' => true));
                            $this->templates = $responderModel->getTemplateList();
                            
                            $this->canDelete = false;
                        }
                      
                    }
                    
                    $this->step = $step;
                    
                    $this->template = $template;
                    $this->form = $this->get('Form');
                }
                else {
                    
                   
                    
                    $this->templates    = $this->get('Templates');
                    $selectedTemplate   = $input->get('template', $this->templates[0]->name);

                    $model = $this->getModel();
                    $this->template = $model->getTemplate($selectedTemplate.'.xml');
                    
                    
                    $cols = array();
                    $lastLeft = 0;
                    $lastTop = 0;
                    $landingWidth = $this->landingWidth = 100;
                    $landingHeight = $this->landingHeight = 100;

                    $responderWidth = 100;
                    $responderHeight = 100;

                    $actionWidth = $this->actionWidth = 50;
                    $actionHeight = $this->actionHeight = 50;

                    $horizontalSpace = 200;
                    $verticalSpace = 60;

                    $maxHeigth = 0;
                    $maxWidth = 0;
                    $i = 0;
                    
                    $elements = array();
                    $k = 0;
                    foreach ($this->template->items as $item){
                        if($item->type == 'landing'){
                           
                            $item->id = $k;
                            $item->title = $item->name;
                            $item->responder_sequence_id = array();
                            $item->to_landing_page = array();
                            $elements[] = $item;
                            if(isset($elements[$k-1])){
                                $elements[$k-1]->to_landing_page = array($k);
                            }
                            $k++;
                        }
                        else {
                           if(isset($elements[$k-1])){
                                $item->id = 0;
                                $item->title = $item->name;
                                $item->to_landing_page = array();
                                $elements[$k-1]->responder_sequence_id[] = $item;
                            } 
                        }
                    }
//                    Zend_Debug::dump($elements);
//                    die;
                    $lastCol = 0;
                    $parents = array($elements[$lastCol]);
                    
                    $names = array(
                                1 => JText::_('COM_MARKETINGROCKET_SQUEEZE_PAGE'),
                                2 => JText::_('COM_MARKETINGROCKET_CONTENT_PAGE'),
                                3 => JText::_('COM_MARKETINGROCKET_SALES_PAGE'),
                                4 => JText::_('COM_MARKETINGROCKET_CHECKOUT_PAGE'),
                                5 => JText::_('COM_MARKETINGROCKET_SPECIAL_OFFER_PAGE'),
                                6 => JText::_('COM_MARKETINGROCKET_THANKYOU_PAGE')
                        );
                    $visulizerModel = JModelLegacy::getInstance('Visualiser', 'MarketingrocketModel');
                    while (!empty($parents)){
                        $cols[$i] = array();
                        $k = 0;
                        $actionTop = $landingHeight/2;
                        $counter = 0;
                        while(isset($parents[$counter])){
                            $parent = $parents[$counter];
                            $counter++;
                            $parent->left = $lastLeft;
                            $parent->top = $lastTop;
                            $parent->type = 'landing';

                            $parentIsEmpty = true;

                            $lastTop += $landingHeight+$verticalSpace;

                            $parent->lines = array();
                            $parent->endPoints = array();
                            $parent->image = array_search(JText::_($parent->options->type), $names);

                            $cols[$i][$k] = $parent;
                            $parentKey = $k;
                            $k++;

                            $reponders = $parent->responder_sequence_id;
                            if(!empty($reponders)){
                                foreach ($reponders as $reponder){
                                    $reponder->top = $lastTop;
                                    $reponder->image = 'responder-sequence';
                                    $lastTop += $responderHeight+$verticalSpace;
                                    $reponder->left = $lastLeft;
                                    $reponder->type = 'responder';
                                    $reponder->endPoints = array(
                                        $i.'_'.($parentKey).'_'.$i.'_'.$k => true
                                    );

                                    if(!empty($reponder->options->days)){
                                        $alias = array();
                                        foreach ($reponder->options->days->day as $day){
                                            if(!empty($day->selected_template))
                                                $alias[] = $day->selected_template;
                                        }
                                        if(!empty($alias) && isset($elements[$lastCol+1])){
                                            $reponder->to_landing_page = $visulizerModel->findTargetsOfResponders($alias, $parent->id+1);
                                            
                                        }
                                    }
                                    
                                    
                                    
                                    $reponder->lines = array();
                                    $cols[$i][$k] = $reponder;

                                    $line = array(
                                            'start_left' => $parent->left+($responderWidth/2),
                                            'start_top' => $parent->top+($responderHeight/2)-5,
                                            'type' => 'to_responder',
                                            'color' => '#C5D816',
                                            'end_left' => $reponder->left+($responderWidth/2),
                                            'end_top' => $reponder->top+($responderHeight/2)
                                    );
                                    $parent->lines[$i.'_'.($parentKey).'_'.$i.'_'.$k] = $line;
                                    $cols[$i][$parentKey] = $parent;
                                    $k++;
                                }
                            }
                        }
                        $lastCol++;
                       
                        if($lastTop > $maxHeigth)
                            $maxHeigth = $lastTop;
                        $lastTop = 0;
                        $lastLeft += $horizontalSpace+$landingWidth; 

                        if($lastLeft > $maxWidth)
                            $maxWidth = $lastLeft;
                        $i++;
                        if(!isset($elements[$lastCol]))
                            break;
                        $parents = array($elements[$lastCol]);
                    }
                    
                    foreach ($cols as $key => $col){
                        $nextCol = $prevCol = array();
                        if(isset($cols[$key+1])){
                            $nextCol = $cols[$key+1];
                        }
                        if(isset($cols[$key-1])){
                            $prevCol = $cols[$key-1];
                        }

                        foreach ($col as $k => $el){
                             if($el->type == 'dropzone')
                                continue;

                            if(strlen($el->title) > 34){
                                $trimtitle = substr($el->title, 0, 34);
                                $trimtitle = $trimtitle . '...' ;
                                $el->title = $trimtitle;
                            }

                            foreach ($el->to_landing_page as $to){
                                foreach ($nextCol as $nextColKey => $nexColElement){
                                    if($nexColElement->type == 'dropzone')
                                        continue;
                                    if($nexColElement->id == $to && $nexColElement->type == 'landing'){

                                        $elWidth = $responderWidth;
                                        $elHeight = $responderHeight;
                                        if($el->type == 'action'){
                                            $elWidth = $actionWidth;
                                            $elHeight = $actionHeight;
                                        }
                                        $color = 'red';
                                        if($el->type != 'responder' && !empty($nexColElement->is_split)){
                                            $color = 'grey';
                                        }
                                        $line = array(
                                            'start_left' => $el->left+($elWidth/2)-5,
                                            'start_top' => $el->top+($elHeight/2),
                                            'type' => 'to_landing',
                                            'color' => $color,
                                            'end_left' => $nexColElement->left+($responderWidth/2),
                                            'end_top' => $nexColElement->top+($responderHeight/2),
                                            'object_id' => $el->id,
                                            'object_type' => $el->type,
                                            'object_title' => $el->title
                                        );
                                        $el->lines[$key.'_'.$k.'_'.($key+1).'_'.$nextColKey] = $line;
                                    }
                                }
                            }

                            if($el->type == 'landing')
                            {
                                if(!empty($prevCol)){

                                    foreach ($prevCol as $prevColKey => $prevColElement){
                                        $name = ($key-1).'_'.$prevColKey.'_'.$key.'_'.$k;
                                        if(isset($prevColElement->lines[$name])){
                                            $el->endPoints[$name] = true;
                                        }
                                    }
                                }
                            }
                        }


                    }
//                    Zend_Debug::dump($cols);
//                    die;
                    $this->cantClick = true;
                    $this->notConnected = array();
                    
                    $this->dontShowDelete = true;
                    
                    $this->cols = $cols;
                    $this->maxWidth = $maxWidth;
                    $this->maxHeigth = $maxHeigth;
                    
                    $document = JFactory::getDocument ();
                    $document->addScript (JURI::base() . '/components/com_marketingrocket/assets/js/fabric.min.js', "text/javascript" , true );
                    
                }
                
                if($input->getInt('force', 0) != 0){
                    $this->force = true;
                }
                
                if($input->getInt('step', 0) != 0){
                    $document = JFactory::getDocument ();
                    $document->addScript ( JURI::root(true) . '/components/com_marketingrocket/assets/js/jquery-ui-1.10.4.custom.min.js', "text/javascript" , true );
                    $document->addScript ( JURI::base() . '/components/com_marketingrocket/assets/js/landing-setting.js', "text/javascript" , true );
                    $document->addScript ( JURI::base() . '/components/com_marketingrocket/assets/js/landing.js', "text/javascript" , true );

                }
              
                $this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
		$this->videoHelp = MarketingrocketHelper::videoHelper('wizard');
		parent::display($tpl);
	}
	protected function addToolbar()
	{
		
		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_WIZARD'), '');
		$canDo	= MarketingrocketHelper::getActions();
                $input = JFactory::getApplication()->input;
		if ($canDo->get('core.admin') && $input->getInt('step', 0) == 0)
		{
			JToolbarHelper::preferences('com_marketingrocket');
                        
                        JToolBarHelper::custom('wizard.import', 'download', 'icon', 'COM_MARKETINGROCKET_IMPORT', false);
                        
		}
		
		
	}

	
}
