<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_ ( 'behavior.keepalive' );
?>
<div class="row-fluid" style="overflow: hidden">
    <div id="loading-holder" class="hide">
        <i class="fa fa-cog fa-5x fa-spin"></i>
    </div>
    <div id="j-sidebar-container" class="span2">
        <?php echo $this->sidebar; ?>
        <div class="wizard-template-holder">
            <h4><?php echo JText::_('COM_MARKETINGROCKET_WIZARD_SETTING') ?>:</h4>
            <div class="media <?php echo (!empty($this->force) || $this->step == 1) ? 'selected' : '' ?>">
                <a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=wizard&step=1&force=1') ?>" class="pull-left">
                    <i class="fa fa-cog fa-2x"></i>
                </a>
                <div class="media-body">
                    <a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=wizard&step=1&force=1') ?>" style="cursor: pointer">
                        <h4 class="media-heading">
                            <?php echo JText::_('COM_MARKETINGROCKET_EDIT_CAMPAIGN_DETAIL') ?>
                        </h4>
                    </a>
                </div>
            </div>
        </div>
        <div class="wizard-template-holder step-holder">
            <h4><?php echo JText::_('COM_MARKETINGROCKET_SELECT_PAGE_AND_TEMPLATES') ?>:</h4>
            <div>
            <?php foreach ($this->template->items as $key => $item): 
                $class = '';
                $canClick = '';
                if($this->template->lastStep > 1){
                    if(!empty($this->template->items[$key]->done))
                        $class = 'done';
                    
                    if(!isset($this->template->items[$key-1]) || !empty($this->template->items[$key-1]->done))
                        $canClick = 'canclick';
                }
                ?>
               
                <div class="media <?php echo $class.' '.$canClick ?>">
                     <div class="arrow-holders">
                        <i class="fa fa-chevron-up" data-id="<?php echo $key+2 ?>"></i>
                        <i class="fa fa-chevron-down" data-id="<?php echo $key+2 ?>"></i>
                    </div>
                    <a class="pull-left" 
                        data-id="<?php echo $key+2 ?>"
                        data-type="<?php echo $item->type ?>"
                    >
                       <?php
                        if($item->type == 'landing'){
                            echo '<i class="fa fa-file-text-o fa-2x"></i>';
                        }
                        else if($item->type == 'responder'){
                            echo '<i class="fa fa fa-envelope-o fa-2x"></i>';
                        }
                        else if($item->type == 'start'){
                            echo '<i class="fa fa-bullhorn fa-2x"></i>';
                        }
                       ?>
                    </a>
                    <div class="media-body">
                        <a 
                            data-id="<?php echo $key+2 ?>"
                        >
                            <h4 class="media-heading">
                                <?php if($item->type == 'landing'){
                                    echo JText::_($item->options->type);
                                }
                                else if($item->type == 'responder'){
                                    echo  JText::_('COM_MARKETINGROCKET_SEQUENCES');
                                }
                                else if($item->type == 'start'){
                                    echo $item->name;
                                }
                                ?>
                                <i class="fa"></i>
                            </h4>
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
            </div>
        </div>
        <div class="wizard-template-holder add-items">
            <h4><?php echo JText::_('COM_MARKETINGROCKET_ADD_MORE_PAGES_EMAILS') ?></h4>
            <div class="media add_page">
                <a style="cursor: pointer" class="pull-left">
                    <i class="fa fa-file-text-o fa-2x"></i>
                </a>
                <div class="media-body">
                    <a style="cursor: pointer">
                        <h4 class="media-heading">
                            <?php echo JText::_('COM_MARKETINGROCKET_ADD_A_PAGE') ?>
                            <i class="fa fa-plus-square"></i>
                        </h4>
                    </a>
                </div>
            </div>
            <div class="media add_responder">
                <a style="cursor: pointer" class="pull-left">
                    <i class="fa fa-envelope-o fa-2x"></i>
                </a>
                <div class="media-body">
                    <a style="cursor: pointer">
                        <h4 class="media-heading">
                            <?php echo JText::_('COM_MARKETINGROCKET_ADD_EMAIL_SEQUENCE') ?>
                            <i class="fa fa-plus-square"></i>
                        </h4>
                    </a>
                </div>
            </div>
            
        </div>
        
    </div>
    <div id="j-main-container" class="span10">
       
        <div class="box">
            <form
                action="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=wizard&step=1'); ?>"
                method="post" name="adminForm" id="adminForm"
                class="form-validate">
                    <div class="row-fluid">
                        <div class="span12 form-horizontal">
                            <?php foreach ($this->form->getFieldset('setting') as $field) : ?>
                                <div class="control-group">
                                    <div class="control-label">
                                            <?php echo $field->label; ?>
                                    </div>
                                    <div class="controls">
                                        <?php echo $field->input; ?>
                                         <?php if($field->__get('name') == 'jform[cat_id]'): ?>
                                            <a id="add_new_category" class="btn"><?php echo JText::_('COM_MARKETINGROCKET_ADD_NEW') ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                            <input type="hidden" name="task" value="wizard.nextstep" />
                            <input type="hidden" name="done" value="0" />
                            <?php echo JHtml::_('form.token'); ?>
                            <div class="pull-right">
                                <input type="submit" value="<?php echo JText::_('COM_MARKETINGROCKET_CONTINUE') ?>" class="btn btn-primary btn-large" />
                                <?php if($this->template->canDone): ?>
                                    <input type="button" value="<?php echo JText::_('COM_MARKETINGROCKET_SAVE_AND_FINISH') ?>" class="btn btn-primary btn-large finish-button" />
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
            </form>
        </div>
    </div>
</div>
 <div class="modal hide fade" id="MR-IFRAME-MODAL">
        <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h3></h3>
        </div>
        <div class="modal-body main sbox-content-iframe">
                <iframe width="800px" height="400px" frameborder="0" src="">

                </iframe>
        </div>

        <div class="modal-footer">
                <a href="#" class="btn" data-dismiss="modal">Close</a> 
        </div>
</div>
<script type="text/javascript">
    //var currentStep = <?php echo $this->template->lastStep ?>;
    var currentStep = 1;
    var selectedHref = false;
    var wizard = '';
    jQuery(document).ready(function($){
        
        // fix for move happend
        var b = $('.step-holder .selected');
        if(b.length > 0){
            $('.step-holder .media').each(function(){
                if(!$(this).hasClass('selected')){
                    $(this).addClass('canclick');
                }
                else 
                    return false;
            });
        }
        
        
        catchForm('#adminForm');
        $('.step-holder a').click(function(){
            if($(this).parents('.media:first').hasClass('canclick')){
                getStep($(this).data('id'));
            }
        });
        $('.add_page').click(function(){
            var p = 0;
            if($('.step-holder').find('.selected').length > 0)
                p =  parseInt($('.step-holder').find('.selected').find('[data-id]').data('id'))-1;
            location.href = '<?php echo JRoute::_('index.php?option=com_marketingrocket&task=wizard.addpage', false) ?>'+'&position='+p;
        });
        $('.add_responder').click(function(){
            var p = 1;
            
            var selectedEl = $('.step-holder').find('.selected');
            if(selectedEl.length > 0){
//                if(selectedEl.find('[data-type]').data('type') == 'responder')
//                {
//                    alert('<?php echo JText::_('COM_MARKETINGROCKET_YOU_CANT_ADD_MORE_REPONDER') ?>');
//                    return false;
//                }
//                if(selectedEl.next().find('[data-type]').data('type') == 'responder')
//                {
//                    alert('<?php echo JText::_('COM_MARKETINGROCKET_YOU_CANT_ADD_MORE_REPONDER') ?>');
//                    return false;
//                }
                
                p = parseInt(selectedEl.find('[data-id]').data('id'))-1;
            }
            else {
                alert('<?php echo JText::_('COM_MARKETINGROCKET_YOU_CANT_ADD_MORE_REPONDER') ?>');
                return false;
            }
              
            location.href = '<?php echo JRoute::_('index.php?option=com_marketingrocket&task=wizard.addresponder', false) ?>'+'&position='+p;
        });
        
        $('.step-holder i.fa-chevron-up').click(function(){
            var id = parseInt($(this).data('id'))-2;
            location.href = '<?php echo JRoute::_('index.php?option=com_marketingrocket&task=wizard.changeorder', false) ?>'+'&type=up&step='+id;
        })
        $('.step-holder i.fa-chevron-down').click(function(){
            var id = parseInt($(this).data('id'))-2;
            location.href = '<?php echo JRoute::_('index.php?option=com_marketingrocket&task=wizard.changeorder', false) ?>'+'&type=down&step='+id;
        })
        
        <?php if(empty($this->force)):
                if($this->showStep >  0){ ?>
                    getStep(<?php echo $this->showStep ?>)
               <?php }
                else {
            ?>
            if(jQuery('.canclick:last').length > 0)
                jQuery('.canclick:last').find('a:first').click();
                <?php } endif; ?>
                    
                    
            $('#add_new_category').click(function(){
                $('#MR-IFRAME-MODAL').find('h3:first').text('Add New Category');
                $('#MR-IFRAME-MODAL').modal('show');
                $('#MR-IFRAME-MODAL').find('iframe').attr('src', 'index.php?option=com_marketingrocket&view=category&layout=edit&tmpl=component');
                activeIframe = 'category';
            });
            
            $('#MR-IFRAME-MODAL').on('hide', function (){
                
                if(activeIframe == 'category'){
                    showLoading();
                    $.ajax({
                        url : 'index.php?option=com_marketingrocket&task=category.catlist'
                    }).done(function(res){
                        $('#jform_cat_id').chosen('destroy').replaceWith(res);
                        $('#jform_cat_id').chosen({"disable_search_threshold":10,"allow_single_deselect":true,"placeholder_text_multiple":"Select some options","placeholder_text_single":"Select an option","no_results_text":"No results match"});
                        hideLoading();
                    });
                }
                else if(activeIframe == 'tag'){
                     reloadSelectBox("index.php?option=com_marketingrocket&view=tags&task=tags.getlist", $('#jform_adding_tag,#jform_adding_tag_before,#jform_adding_tag_end,#jform_remove_tag_end,#jform_send_to_tags,#jform_dont_send_to_tags'), false);
                     
                }
                
            });
        
    });
    var catchForm = function(form){
        var $ = jQuery;
        $('.finish-button').click(function(){
            $('[name="done"]').val('1');
           jQuery('#adminForm').find('[type="submit"]').click();
        })
        $(form).submit(function(e){
//            if(!jQuery.browser.safari && parseInt(jQuery.browser.version) > 12){
//                if(!$(this).is(':valid')){
//                    return false;
//                }
//            }
            // submit , get next step from another request
            var data = {};
            $(this).find('input,select,textarea').each(function(){
                var name = $(this).attr('name');
                if(name == undefined)
                    return true;
                if(name.search('\\[]') > -1){
                    var parentName = name.replace('[]', '');
                    if(data[parentName] == undefined)
                        data[parentName] = [];
                    data[parentName].push($(this).val());
                }
                else 
                    data[name] = $(this).val();
            })
           
            submitForm($(this).attr('action'),data);
            e.preventDefault();
            return false;
        })
    }
    var submitForm = function(action , data){
        var $ = jQuery;
        if($('.responder-iframe[data-save="false"]').length > 0){
           
            var canSave = true;
            $('.responder-iframe').each(function(){
                var win = this.contentWindow || this;
                var doc = this.contentDocument || this.contentWindow.document;
                if(!doc.formvalidator.isValid(doc.id('responder-form'))){
                    canSave = false;
                    var top = $(this).offset().top;
                    $("html, body").animate({scrollTop:top+'px'});
                    resizePopUps();
                }

            })
            if(canSave){
                showLoading();
                saveHappend = 1;
                $('.responder-iframe[data-save="false"]').each(function(){
                    var el = $(this);
                    var win = this.contentWindow || this;
                    win.Joomla.submitbutton('wizard.applyresponder');
                    saveHappend++;
                    return false;
                })
            }
            
            return true;
        }
        showLoading();
       
        $.ajax({
            url : action,
            data : data,
            dataType : 'json',
            method : 'POST'
        }).done(function(res){
            if(res.success == false){
                hideLoading();
                $('#system-message-container').html('<div class="alert "> <button type="button" class="close" data-dismiss="alert">&times;</button><h4 class="alert-heading">Warning</h4></div>')
                var p = document.createElement('p');
                $(p).text(res.message);
                $('#system-message-container').find('.alert').append(p);
                $('[name="done"]').val('0');
                return false;
            }
            if(selectedHref != false){
                location.href = selectedHref;
                return res;
            }
            if(res.data.done){
                location.href = '<?php echo JRoute::_('index.php?option=com_marketingrocket&task=wizard.done', false) ?>&id='+res.data.campaing_id;
                return true;
            }
            getStep(res.data.next_step);
           
            
        })
    }
    var getStep = function(step){
        showLoading();
        var $ = jQuery;
        $('#system-message-container').html('');
        
        var time = new Date();
        
        $.ajax({
            url : '<?php echo JRoute::_('index.php?option=com_marketingrocket&view=wizard', false) ?>&step='+step+'&t='+time.getTime()
        }).done(function(res){
            $('.wizard-template-holder').find('.media.selected').removeClass('selected');
            if(step > currentStep){
                if(currentStep > 1){
                    $('.step-holder').find('.media').eq(currentStep-2).addClass('done');
                    currentStep = step;
                    $('.step-holder').find('.media').eq(currentStep-2).addClass('selected canclick');
                }
                else {
                    currentStep = step;
                    $('.step-holder').find('.media').eq(currentStep-2).addClass('selected canclick');
                }
            }
            else {
                 currentStep = step;
                $('.step-holder').find('.media').eq(currentStep-2).addClass('selected canclick');
            }
            $('[name="done"]').val('0');
            $('#j-main-container').effect({
                effect : 'droprtl',
                complete : function(){
                    $('#j-main-container').html(res).effect({effect : 'slidewithfade'});
                    $('select').chosen({"disable_search_threshold":10,"allow_single_deselect":true,"placeholder_text_multiple":"Select some options","placeholder_text_single":"Select an option","no_results_text":"No results match"});
                    catchForm('#adminForm');
                }
            })
            hideLoading();
            
            
           
        });
    }
    jQuery('.remove-step').live('click', function(){
        var b = confirm('Are your sure about remove this Step ?');
        if(b){
            location.href = '<?php echo JRoute::_('index.php?option=com_marketingrocket&task=wizard.deletestep', false) ?>&step='+jQuery(this).data('step')
        }
    })
    var showLoading = function(){
        jQuery('#loading-holder').show();
    }
    var hideLoading = function(){
        jQuery('#loading-holder').hide();
    }
    
    var resizePopUps = function(){
        var $ = jQuery;
        $('.responder-iframe').each(function(){
            try {
                var el = $(this);
                var win = this.contentWindow || this;
                var doc = this.contentDocument || this.contentWindow.document;
                var h = $('.form-container' ,doc).outerHeight();
                h += $('#system-message-container' ,doc).outerHeight();
                h += 40;
                el.height(h);
            }
            catch(e){
                console.log(el);
                console.log(e);
            }
            
        })
    }
    var catchIframe = function(el){
        var $ = jQuery;
        resizePopUps();
        if(!el.data('loaded')){
            el.parent().find('h4').removeClass('hide');
            el.attr('data-loaded', 'true').data('loaded', true);
        }
        else if(saveHappend){
            el.attr('data-save', true);
            if(saveHappend == 1)
                $('#adminForm').submit();
            saveHappend--;
        }
    }
    var removeEmail = function(id){
        var c = confirm('<?php echo JText::_('COM_MARKETINGROCKET_RELLY_DELETE_THIS_EMAIL', true) ?>');
        if(c){
            var $ = jQuery;
            var data = {email : id, step : currentStep};
            var token = $('#token_holder').find('input').attr('name');
            data[token] = 1;
            $.ajax({
               url : '<?php echo JRoute::_('index.php?option=com_marketingrocket&task=wizard.removemail', false) ?>',
               data : data,
               type : 'POST'
            });
            id = parseInt(id);
            $('#iframe-'+(id+1)).parent().remove();
            
            var i = 1;
            
            $('.iframe-holder').each(function(){
                $(this).find('h4').text('Email '+i);
                i++;
            });
            
            $('.responder-iframe').each(function(){
                var win = this.contentWindow || this;
                win.splitRemoveOption(id+1);
            });
            
        }
    }
    
    var ifSplitChanged = function(id, lastVal , currentVal){
        var $ = jQuery;
        var lastEl = $('#iframe-'+lastVal);
        if(lastEl.length > 0){
            var win = lastEl[0].contentWindow || lastEl[0];
            win.jQuery('#jform_split_id').val('0');
            win.lastSplitId = 0;
        }
        
        if(currentVal == 0)
            return;
        var newEl = $('#iframe-'+currentVal);
        
        var win = newEl[0].contentWindow || newEl[0];
        var thirsEl = $('#iframe-'+win.lastSplitId);
        if(thirsEl.length > 0){
            var thWin = thirsEl[0].contentWindow || thirsEl[0];
            thWin.jQuery('#jform_split_id').val(0);
        }
        
        win.jQuery('#jform_split_id').val(id);
        
        
        win.lastSplitId = id;
    }
    
    
</script>