<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
$this->addTemplatePath( JPATH_COMPONENT.'/views/landingtemplate/tmpl' );
$urlPatch = JUri::getInstance();
?>
<div class="box">
    
    <form
        action="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=wizard&step=1'); ?>"
        method="post" name="adminForm" id="adminForm"
        class="form-validate">
           <a class="pull-right btn btn-danger remove-step" data-step="<?php echo  $this->step ?>">
                <?php echo JText::_('COM_MARKETINGROCKET_REMOVE_THIS_STEP') ?>
           </a>
            <div class="row-fluid">
                <div class="span12 form-horizontal">
                    <?php foreach ($this->form->getFieldset('setting') as $field) : ?>
                        <div class="control-group">
                            <div class="control-label">
                                    <?php echo $field->label; ?>
                            </div>
                            <div class="controls">
                                    <?php echo $field->input; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                    <input type="hidden" name="task" value="wizard.nextstep" />
                    <input type="hidden" name="done" value="0" />
                    
                     <div class="control-group">
                        <div class="control-label">
                             <?php echo JText::_('COM_MARKETINGROCKET_SELECTED_TEMPLATE') ?>
                        </div>
                        <div class="controls" id="">
                            <div id="selected-template" class="pull-left" style="width: 300px">
                            </div>
                            <a href="" class="btn btn-primary pull-left btn-large" id="edit-landing" style="display: none; margin-left: 10px;">
                                <?php echo JText::_('COM_MARKETINGROCKET_EDIT') ?>
                            </a>
                        </div>
                     </div>
                    
                    
                    <?php echo JHtml::_('form.token'); ?>
                    <div class="pull-right">
                        <?php if(empty($this->canDone)): ?>
                            <input type="submit" value="<?php echo JText::_('COM_MARKETINGROCKET_SAVE_AND_CONTINUE') ?>" class="btn btn-primary btn-large" />
                        <?php 
                            else : ?>
                            <input type="submit" value="<?php echo JText::_('COM_MARKETINGROCKET_SAVE_AND_CONTINUE') ?>" class="btn btn-primary btn-large hidden" />
                        <?php endif; ?>
                        <?php if($this->template->canDone || !empty($this->canDone)): ?>
                            <input type="button" value="<?php echo JText::_('COM_MARKETINGROCKET_SAVE_AND_FINISH') ?>" class="btn btn-primary btn-large finish-button" />
                        <?php endif; ?>
                    </div>
                </div>
            </div>
    </form>
</div>
<div class="box" style="min-height: 400px">
    <h2><?php echo JText::_('COM_MARKETINGROCKET_SELECT_A_TEMPLATE_FOR_THIS_PAGE') ?></h2>
    <?php echo $this->loadTemplate('template'); ?>
</div>
<script>
    var locationOfJoomla = '<?php echo JURI::root(true) ?>';
    var joomlaHost = '<?php echo $urlPatch->getHost() ?>'
    var landingId = 0;
    var defaultTemplate = '<?php echo @$this->item->options->template ?>';
    jQuery('#j-main-container .thumbnails a').each(function(){
        jQuery(this).attr('data-href', jQuery(this).attr('href')).removeAttr('href').click(function(){
            setSelectedTemplate(jQuery(this).data('id'));
        });
    })
    var setSelectedTemplate = function(id){
        var el = jQuery('.thumbnails a[data-id="'+id+'"]').clone();
        if(el.length > 0){
            jQuery('#selected-template').html(el);
            jQuery('#edit-landing').attr('href', el.data('href')+'&wizard='+currentStep).show();
            jQuery('#jform_selected_template').val(id);
            showLoading();
            jQuery.ajax({
                url : '<?php echo JRoute::_('index.php?option=com_marketingrocket&task=wizard.template', false) ?>',
                data : {template : id},
                dataType : 'json'
            }).done(function(res){
                hideLoading();
                
                jQuery('#jform_css').val(res.data.css);
                jQuery('#jform_hidden_css').val(res.data.hidden_css);
                
                var app = new MR_landing(locationOfJoomla, intialize);
                app.joomlaUrl = 'http://'+joomlaHost;
                
                app.loadInlineCss();
                
                var div = jQuery('<div id="body-holder"></div>');
                
                div.hide().html(res.data.body).appendTo(jQuery('#j-main-container'));
        
                app.fixImageSrcOnRun(div);
                
                var modal = jQuery('<div id="modal-holder"></div>');
                
                modal.hide().html(res.data.modal).appendTo(jQuery('#j-main-container'));
                
                app.fixImageSrcOnRun(modal, false);
                
                jQuery(div).find('[aria-type="form"]').each(function(){
                    jQuery(this).find('[aria-type="button"]').attr('onclick', 'document.getElementById(\'front-landing-form\').submit()');
                })
                
                jQuery(modal).find('[aria-type="form"]').each(function(){
                    jQuery(this).find('[aria-type="button"]').attr('onclick', 'document.getElementById(\'front-landing-form\').submit()');
                })
                
                saveHtml(div , '#jform_body', div.find('#MarketingRocketMain'));
                
                saveHtml(modal,'#jform_modal', modal.find('#MR_Modal_View_Modal'));
            });
        }
        
    }
    if(jQuery('#jform_selected_template').val() != ''){
        setSelectedTemplate(jQuery('#jform_selected_template').val());
    }
    else if(defaultTemplate != ''){
        setSelectedTemplate(jQuery('[data-uname="'+defaultTemplate+'"]').data('id'));
        
    }
</script>

<?php
die;
?>