<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');
?>
<div class="row-fluid">
    <div id="j-sidebar-container" class="span2">
        <?php echo $this->sidebar; ?>
        <div class="wizard-template-holder">
            <h4><?php echo JText::_('COM_MARKETINGROCKET_SELECT_A_CAMPAIGN_TEMPLATE') ?>:</h4>
            <?php foreach ($this->templates as $template): 
                $class = '';
                if($template->name == $this->template->name)
                    $class = 'selected';
                ?>
                <div class="media <?php echo $class ?>">
                    <a class="pull-left" href="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=wizard&template='.$template->name) ?>">
                        <?php echo $template->icon ?>
                    </a>
                    <div class="media-body">
                        <a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=wizard&template='.$template->name) ?>">
                            <h4 class="media-heading">
                                <?php echo $template->title ?>
                            </h4>
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
            <div class="media">
                <a  class="pull-left" href="<?php echo JRoute::_('index.php?option=com_marketingrocket&task=wizard.custom') ?>">
                    <i class="fa fa-cogs fa-2x"></i>
                </a>
                <div class="media-body">
                    <a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&task=wizard.custom') ?>">
                        <h4 class="media-heading">
                            <?php echo JText::_('COM_MARKETINGROCKET_CREATE_YOUR_OWN') ?>
                        </h4>
                    </a>
                </div>
            </div>
        </div>
		<br />
		<p class="center bold"><a onclick="showmodal()" style="cursor: pointer;color:#fff;">
			<?php echo JText::_('COM_MARKETINGROCKET_WATCH_THE_VIDEO_GUIDE') ?>
			<img src="<?php echo $this->videoHelp['img'] ?>" alt="<?php echo $this->videoHelp['text'] ?>" />
		</a></p>
		<p class="center bold"><?php echo JText::_('COM_MARKETINGROCKET_CLICK_HERE_FOR_MORE_SUPPORT') ?></p>
    </div>
    <div id="j-main-container" class="span10">
        <div class="box">
            <div class="row-fluid">
                <div class="span8">
                    <h2><?php echo $this->template->title ?></h2>
                    <p><?php echo $this->template->desc ?></p>
                </div>
                <div class="span4 text-center">
                    <img src="<?php echo $this->template->image ?>" />
                    <br />
                     <br />
                    <a class="btn btn-primary btn-large" href="<?php echo JRoute::_('index.php?option=com_marketingrocket&task=wizard.start&template='.$this->template->name) ?>">
                        <?php echo JText::_('COM_MARKETINGROCKET_CREATE_CAMPAIGN') ?>
                        <i class="fa fa-plus"></i>
                    </a>
                </div>
            </div>
            
            
        </div>
        <div class="box">
            <h2><?php echo JText::_('COM_MARKETINGROCKET_FUNNEL_VISUALISER_LAYOUT') ?></h2>
            <div class="row-fluid visualiser vis-content-scroller">
                <div class="span12 vis-top-backing" style="background-color: #F7F7F7">
                    <?php 
                    $this->addTemplatePath( JPATH_COMPONENT.'/views/visualiser/tmpl' );
                    echo $this->loadTemplate('vis'); ?>
                </div>
            </div>
            
        </div>
    </div>
</div>

 <div class="modal hide fade" id="MR-MODAL">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h3>Import Wizard</h3>
        </div>
        <div class="modal-body main">
            <form
                enctype="multipart/form-data" 
                action="<?php echo JRoute::_('index.php?option=com_marketingrocket&task=wizard.import') ?>"
                method="post" name="adminForm" id="adminForm"
                class="form-validate form-horizontal">
                <div class="control-group">
                            <div class="control-label">
                                <label for=""><?php echo JText::_('COM_MARKETINGROCKET_FILE') ?>*</label>
                            </div>
                        <div class="controls">
                            <input required="required"  type="file" name="file" /> <i><small>.xml File</small></i>
                        </div>
                    </div>
                    <div class="control-group">
                            <div class="control-label">
                            </div>
                        <div class="controls">
                            <input type="submit" class="btn btn-primary" value="<?php echo JText::_('COM_MARKETINGROCKET_SUBMIT') ?>" />
                        </div>
                    </div>
                    <?php echo JHtml::_('form.token'); ?>
            </form>
        </div>

        <div class="modal-footer">
                <a href="#" class="btn" data-dismiss="modal">Close</a> 
        </div>
</div>

<script type="text/javascript">
    Joomla.submitbutton = function(task){
        if(task == 'wizard.import'){
            jQuery('#MR-MODAL').modal('show');
        }
    }
</script>

