<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.view');


class MarketingrocketViewWebinars extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		require_once JPATH_COMPONENT.'/helpers/marketingrocket.php';
		MarketingrocketHelper::addSubmenu('webinars');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
		$this->videoHelp = MarketingrocketHelper::videoHelper('webinars');
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		


		$canDo	= MarketingrocketHelper::getActions();
		// Get the toolbar object instance

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGE_WEBINARS'), '');
		JToolbarHelper::addNew('webinar.choose');
//		if ($canDo->get('core.edit'))
//		{
//			JToolbarHelper::editList('webinar.edit');
//		}

//                JToolbarHelper::custom('tags.delete', 'trash', 'trash', 'JTOOLBAR_DELETE', true);
                
//                JToolbarHelper::deleteList('COM_MARKETINGROCKET_ARE_YOUR_SURE_ABOUT_DELETE_THIS_ITEMS' , 'webinars.delete');


		if ($canDo->get('core.admin'))
		{
			JToolbarHelper::preferences('com_marketingrocket');
		}


		JHtmlSidebar::setAction('index.php?option=com_marketingrocket&view=webinars');





	}
        
        /**
	 * Returns an array of fields the table can be sorted by
	 *
	 * @return  array  Array containing the field name to sort by as the key and display text as value
	 *
	 * @since   3.0
	 */
	protected function getSortFields()
	{
		return array(
			'id' => JText::_('JGRID_HEADING_ID'),
			'title' => JText::_('COM_MARKETINGROCKET_TITLE'),
                        'created' => JText::_('COM_MARKETINGROCKET_CREATED_ORDER'),
                        'api' => JText::_('COM_MARKETINGROCKET_API'),
                        'start_time' => JText::_('COM_MARKETINGROCKET_START_TIME'),
                        'end_time' => JText::_('COM_MARKETINGROCKET_END_TIME')
		);
	}
}
