<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketViewWebinar extends JViewLegacy
{
	protected $state;

	protected $item;

	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->state	= $this->get('State');
		$this->item		= $this->get('Item');
		$this->form		= $this->get('Form');
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
                
                
                $apiModel = JModelLegacy::getInstance('Api', 'MarketingrocketModel', array('ignore_request' => true));
                 if(JFactory::getApplication()->input->getString('layout') == 'choose'){
                    $this->apiList = $apiModel->getItemsByType('google');
                    if(empty($this->apiList)){
                        $app = JFactory::getApplication();
                        $app->enqueueMessage(JText::_('COM_MARKETINGROCKET_FIRST_ADD_YOUR_GOOGLE_API'), 'warning');
                        JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_marketingrocket&view=api&layout=edit&id=0&type=google', false));
                    }
                }
                else {
                    $id = 0;
                    if(empty($this->item) || empty($this->item->id)){
                        $apiId = $this->apiId = JFactory::getApplication()->input->getInt('api');
                    }
                    else {
                        $apiId = $this->apiId = $this->item->api_id;
                        $id = $this->item->id;
                    }
                    $apiRow = $apiModel->getItem($apiId);
                    if(empty($apiRow))
                        throw new Exception('Api Not Found', 500);
                    
                    require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.
                            'com_marketingrocket'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'Google'.DIRECTORY_SEPARATOR.'autoload.php';
                    
                    

                    $session =  JFactory::getSession();
                    if(empty($apiRow->token)){
                        $force = true;
                    }
                    else if(time()+300 > $apiRow->expire){// token must be live for 5 minute
                         $force = true;
                    }
                    else 
                        $force = false;
                    $session->set('api_id', $apiId, 'com_marketingrocket');
                    $session->set('webinar_id', $id, 'com_marketingrocket');
                    if($force){
                       JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_marketingrocket&task=webinar.auth', false));
                    }
                    
                }

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{

		JFactory::getApplication()->input->set('hidemainmenu', true);

		$user		= JFactory::getUser();
		// Since we don't track these assets at the item level, use the category id.
		$canDo		= MarketingrocketHelper::getActions();
                if(JFactory::getApplication()->input->getString('layout') != 'choose'){
                    JFactory::getApplication()->input->set('hidemainmenu', true);
                    JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGE_WEBINAR'), '');

                    // If not checked out, can save the item.
                    if (($canDo->get('core.edit')))
                    {
                            JToolbarHelper::apply('webinar.apply');
                            JToolbarHelper::save('webinar.save');
                    }
                    if (empty($this->item->id))
                    {
                            JToolbarHelper::cancel('webinar.cancel');
                    }
                    else
                    {
                            JToolbarHelper::cancel('webinar.cancel', 'JTOOLBAR_CLOSE');
                    }
                }
                else {
                    JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_CHOOSE_API'), '');
                }
		

		JToolbarHelper::divider();
	}
}
