<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketViewVisualiser extends JViewLegacy
{
	protected $state;

	protected $item;

	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{

		$this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );
		
		$this->state	= $this->get('State');
		$this->form = $this->get('form');
                
                $parents = $this->get('Parents');
                
                $campaignModel = JModelLegacy::getInstance('Campaigns', 'MarketingrocketModel');
                
                $campaignList = $campaignModel->getCampaignList();
                if(empty($campaignList))
                {
                    $app = JFactory::getApplication();
                    $app->enqueueMessage('There is no campaign');
                    $app->redirect(JRoute::_('index.php?option=com_marketingrocket'));
                }
              
                $model = $this->getModel();
                $parentsIds = array();
                // do a pre check
                foreach ($parents as $i => $parent){
                    $parentsIds[] = $parent->id;
                    $reponders = json_decode($parent->responder_sequence_id);
                    if(!is_array($reponders))
                        continue;
                    foreach ($reponders as $reponder){
                        if($parent->responder_type == 'default'){
                            $model->findTargets($reponder, $parents);
                        }
                    }
                    
                    
                }
             
                sort($parents);
                foreach ($parents as $i => $parent){
                    $splits = $model->getSplits($parent);
                    
                    if(!empty($splits)){
                        foreach ($splits as $split){
                            if(!in_array($split->id, $parentsIds)){
                                unset($parents[$i]);
                            }
                            else {
                                $parents[$i]->is_split = true;
                            }
                        }
                    }
                    
                }
                sort($parents);
                
                foreach ($parents as $i => $parent){
                    if(empty($parent->to_landing_page) && empty($parent->is_split))
                        unset($parents[$i]);
                }
                sort($parents);
                $cols = array();
                $lastLeft = 0;
                $lastTop = 0;
                $landingWidth = $this->landingWidth = 100;
                $landingHeight = $this->landingHeight = 100;
                
                $responderWidth = 100;
                $responderHeight = 100;
                
                $actionWidth = $this->actionWidth = 50;
                $actionHeight = $this->actionHeight = 50;
                
                $horizontalSpace = 200;
                $verticalSpace = 60;
                
                $maxHeigth = 0;
                $maxWidth = 0;
                $i = 0;
                
                
                $model = $this->getModel();
                $allLandings = array();
                
                $lastTargets = array();
                while (!empty($parents)){
                    
                    $targets = array();
                    
                    $cols[$i] = array();
                    $k = 0;
                    $actionTop = $landingHeight/2;
                    $counter = 0;
                    while(isset($parents[$counter])){
                       
                        $parent = $parents[$counter];
                        $counter++;
                        $parent->left = $lastLeft;
                        $parent->top = $lastTop;
                        $parent->type = 'landing';
                        
                        $parentIsEmpty = true;
                        
                        if(!empty($parent->to_landing_page)){
                            $parentIsEmpty = false;
                            $parent->to_landing_page = array($parent->to_landing_page);
                        }
                        else {
                            $parent->to_landing_page = array();
                        }
                        $lastTop += $landingHeight+$verticalSpace;
                        
                        $parent->lines = array();
                        $parent->endPoints = array();
                        $parent->image = $parent->page_type;
                        
                        $cols[$i][$k] = $parent;
                        $parentKey = $k;
                        $k++;
                        
                        $diff = array_diff($parent->to_landing_page, $lastTargets);
                        
                        $targets = array_merge($diff, $targets);
                        
                        $reponders = json_decode($parent->responder_sequence_id);
                        if(is_array($reponders))
                        {
                             foreach ($reponders as $reponder){
                                if($parent->responder_type == 'default'){
                                    $reponder = $model->getResponder($reponder);
                                    $reponder->title = $reponder->name;
                                    

                                    $reponder->to_landing_page = $model->findTargets($reponder->id);
                                    
                                    if(!empty($reponder->to_landing_page))
                                        $parentIsEmpty = false;
                                   
                                    $diff = array_diff($reponder->to_landing_page, $lastTargets);
                                    
                                    $targets = array_merge($diff, $targets);
                                    
                                    
                                }
                                else {
                                    $rowResId = $reponder;
                                    $reponder = new stdClass();
                                    $reponder->id = $rowResId;
                                    $reponder->to_landing_page = array();
                                    // TODO get name from api table
                                    $reponder->title = 'mailchimp';
                                }
                                
                                $reponder->top = $lastTop;
                                $reponder->image = 'responder-sequence';
                                $lastTop += $responderHeight+$verticalSpace;
                                $reponder->left = $lastLeft;
                                $reponder->type = 'responder';
                                $reponder->endPoints = array(
                                    $i.'_'.($parentKey).'_'.$i.'_'.$k => true
                                );

                                $reponder->lines = array();
                                $cols[$i][$k] = $reponder;
                                
                                $line = array(
                                        'start_left' => $parent->left+($responderWidth/2),
                                        'start_top' => $parent->top+($responderHeight/2)-5,
                                        'type' => 'to_responder',
                                        'color' => '#C5D816',
                                        'end_left' => $reponder->left+($responderWidth/2),
                                        'end_top' => $reponder->top+($responderHeight/2)
                                );
                                $parent->lines[$i.'_'.($parentKey).'_'.$i.'_'.$k] = $line;
                                $cols[$i][$parentKey] = $parent;
                                $k++;
                                
                            }
                        }
                        
                        $actions = $model->getLandingActions($parent->id);
                        $action = false;
                        foreach ($actions as $actionKey => $actionRow){
                            $parentIsEmpty = false;
                            if($actionKey == 0){
                                $action = new stdClass();
                                $action->left = $lastLeft+$landingWidth+(($horizontalSpace/2)-($actionWidth/2));
                                $action->top = $actionTop;
                                $action->id = $parent->id;
                                $action->image = 'action-icon1';
                                $action->type = 'action';
                                $action->landingId = $parent->id;

                                $actionTop = $actionHeight+($landingHeight/2);
                                $line = array(
                                        'start_left' => $parent->left+($landingWidth/2),
                                        'start_top' => $parent->top+($landingHeight/2),
                                        'type' => 'to_action',
                                        'color' => 'blue',
                                        'end_left' => $action->left+($actionWidth/2),
                                        'end_top' => $action->top+($actionHeight/2)
                                );
                                $parent->lines[$i.'_'.($parentKey).'_'.$i.'_'.$k] = $line;
                                $cols[$i][$parentKey] = $parent;
                                $action->title = 'Action';
                                $action->endPoints = array(
                                    $i.'_'.($parentKey).'_'.$i.'_'.$k => true
                                );
                                $action->to_landing_page = array($actionRow->target);
                            }
                            else 
                                $action->to_landing_page[] = $actionRow->target;
                            
                            $diff = array_diff(array($actionRow->target), $lastTargets);
                            
                            $targets = array_merge($diff, $targets);
                        }
                        if(!empty($action)){
                            $cols[$i][$k] = $action;
                            $k++;
                        }
                        if(empty($parent->split_added) && $i > 0){
                            $getSplits = $model->getSplits($parent);
                            foreach ($getSplits as $split){
                                $split->split_added = true;
                                $split->is_split = true;
                                if(isset($cols[$i-1])){
                                    $prevCol = $cols[$i-1];
                                    foreach ($prevCol as $prevColKey => $prevColEl){
                                        if($prevColEl->type == 'landing' && in_array($parent->id, $prevColEl->to_landing_page)){
                                            $prevColEl->to_landing_page[] = $split->id;
                                        }
                                    }
                                }
                                $parent->is_split = true;
                                $parents = $this->_insert($parents, $counter, $split);
                            }
                        }
                        
                        if(empty($parent->to_landing_page) && $parentIsEmpty){
                            $obj = new stdClass();
                            $obj->landingId = $parent->id;
                            $obj->landingText = $parent->title;
                            $obj->type = 'dropzone';
                            $obj->left = $parent->left+$landingWidth+($horizontalSpace/4);
                            $obj->top = $parent->top;
                            $cols[$i][$k] = $obj;
                            $k++;
                        }
                       $allLandings[]  = $parent->id;
                        
                    }
                    
                    $parents = $model->getLandings($targets);
                    $lastTargets = $targets;
                    if($lastTop > $maxHeigth)
                        $maxHeigth = $lastTop;
                    $lastTop = 0;
                    $lastLeft += $horizontalSpace+$landingWidth; 
                    
                    if($lastLeft > $maxWidth)
                        $maxWidth = $lastLeft;
                    
                    
                    $i++;
                }
                
//                Zend_Debug::dump($cols);
//                die;
                
                foreach ($cols as $key => $col){
                    $nextCol = $prevCol = false;
                    if(isset($cols[$key+1])){
                        $nextCol = $cols[$key+1];
                    }
                    if(isset($cols[$key-1])){
                        $prevCol = $cols[$key-1];
                    }
                    
                    foreach ($col as $k => $el){
                         if($el->type == 'dropzone')
                            continue;
                        
//                        if(strlen($el->title) > 34){
//                            $trimtitle = substr($el->title, 0, 34);
//                            $trimtitle = $trimtitle . '...' ;
//                            $el->title = $trimtitle;
//                        }
                        
                        foreach ($el->to_landing_page as $to){
                            if(empty($nextCol))
                                continue;
                            foreach ($nextCol as $nextColKey => $nexColElement){
                                if($nexColElement->type == 'dropzone')
                                    continue;
                                if($nexColElement->id == $to && $nexColElement->type == 'landing'){
                                    
                                    $elWidth = $responderWidth;
                                    $elHeight = $responderHeight;
                                    if($el->type == 'action'){
                                        $elWidth = $actionWidth;
                                        $elHeight = $actionHeight;
                                    }
                                    $color = 'red';
                                    if($el->type != 'responder' && !empty($nexColElement->is_split)){
                                        $color = 'grey';
                                    }
                                    $line = array(
                                        'start_left' => $el->left+($elWidth/2)-5,
                                        'start_top' => $el->top+($elHeight/2),
                                        'type' => 'to_landing',
                                        'color' => $color,
                                        'end_left' => $nexColElement->left+($responderWidth/2),
                                        'end_top' => $nexColElement->top+($responderHeight/2),
                                        'object_id' => $el->id,
                                        'object_type' => $el->type,
                                        'object_title' => $el->title
                                    );
                                    $el->lines[$key.'_'.$k.'_'.($key+1).'_'.$nextColKey] = $line;
                                }
                            }
                        }
                         
                        if($el->type == 'landing')
                        {
                            if(!empty($prevCol)){
                                
                                foreach ($prevCol as $prevColKey => $prevColElement){
                                    $name = ($key-1).'_'.$prevColKey.'_'.$key.'_'.$k;
                                    if(isset($prevColElement->lines[$name])){
                                        $el->endPoints[$name] = true;
                                    }
                                }
                            }
                        }
                    }
                    
                    
                }
                $this->notConnected = $model->getNotConnected($allLandings);
                $mostRemoved = array();
//                if(!empty($cols)){
//                    foreach ($cols[0] as $key => $parent){
//                        if(empty($parent->lines) && $parent->type == 'landing'){
//                            unset($cols[0][$key]);
//                            $parent->itemType = $parent->type;
//                            $this->notConnected[] = $parent;
//                            $mostRemoved[] = $parent->id;
//                        }
//                        if($parent->type == 'dropzone' && in_array($parent->landingId, $mostRemoved))
//                            unset($cols[0][$key]);
//                    }
//                }
                
                
//                Zend_Debug::dump($cols);
//                die;
               
                $this->cols = $cols;
                $this->maxWidth = $maxWidth+$horizontalSpace;
                $this->maxHeigth = $maxHeigth+$verticalSpace+$landingHeight+$verticalSpace;
                
		$document = JFactory::getDocument ();
		$document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/style.css' );
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
                    JError::raiseError(500, implode("\n", $errors));
                    return false;
		}

		$this->addToolbar();
		MarketingrocketHelper::addSubmenu('visualiser');
		$this->sidebar = JHtmlSidebar::render();
		$this->videoHelp = MarketingrocketHelper::videoHelper('visualiser');
                
                $document->addScript ( JURI::root(true) . '/components/com_marketingrocket/assets/js/jquery-ui-1.10.4.custom.min.js', "text/javascript" , true );
                
                $document->addScript (JURI::base() . '/components/com_marketingrocket/assets/js/fabric.min.js', "text/javascript" , true );
                
                $document->addStyleSheet (JURI::root(true).'/components/com_marketingrocket/assets/css/jquery-ui-1.10.4.custom.min.css' );
                
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{

		

		$user		= JFactory::getUser();

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_CAMPAIGN_VISUALISER'), '');

	

		JToolbarHelper::divider();
	}
        private function _insert($array, $index, $val)
        {
            $temp = array();
            $size = count($array);
            if (!is_int($index) || $index < 0 || $index > $size)
            {
                return -1;
            }
            else
            {
                $temp   = array_slice($array, 0, $index);
                $temp[] = $val;
                return array_merge($temp, array_slice($array, $index, $size));
            }
        }
}
