<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined ( '_JEXEC' ) or die ();

JHtml::addIncludePath ( JPATH_COMPONENT . '/helpers/html' );
JHtml::_ ( 'behavior.tooltip' );
JHtml::_ ( 'formbehavior.chosen', 'select' );

					$names = array(
						1 => JText::_('COM_MARKETINGROCKET_SQUEEZE_PAGE'),
						2 => JText::_('COM_MARKETINGROCKET_CONTENT_PAGE'),
						3 => JText::_('COM_MARKETINGROCKET_SALES_PAGE'),
						4 => JText::_('COM_MARKETINGROCKET_CHECKOUT_PAGE'),
						5 => JText::_('COM_MARKETINGROCKET_SPECIAL_OFFER_PAGE'),
						6 => JText::_('COM_MARKETINGROCKET_THANKYOU_PAGE'),
						7 => JText::_('COM_MARKETINGROCKET_WEBINAR_PAGE')
					);
?>
                <div class="vis-legend">
                    <div class="vis-legend-box">
                        <div class="vis-legend-item vis-legend-title-flip">
                                <span class="vis-legend-title"><?php echo JText::_('COM_MARKETINGROCKET_VISUALISER_LEGEND') ?></span>
                        </div>
                        <?php
                            foreach($names as $imageid => $name){
                                    echo
                                    '
                                    <div class="vis-legend-item">
                                            <span>
                                                    <img src="components/com_marketingrocket/assets/images/visualiser/legend/'. $imageid .'.png" />
                                            </span>
                                            <span class="vis-item-title">
                                                    '.$name.'
                                            </span>
                                    </div>
                                    ';
                            }
                        ?>
                        <div class="vis-legend-item">
                            <span>
                                    <img src="components/com_marketingrocket/assets/images/visualiser/legend/responder.png" />
                            </span>
                            <span class="vis-item-title">
                                    <?php echo JText::_('COM_MARKETINGROCKET_SEQUENCE_SHORT') ?>
                            </span>
                        </div>
                        <div class="vis-legend-item">
                                <span>
                                        <img src="components/com_marketingrocket/assets/images/visualiser/legend/action.png" />
                                </span>
                                <span class="vis-item-title">
                                        <?php echo JText::_('COM_MARKETINGROCKET_FORM_ACTION_STEPS') ?>
                                </span>
                        </div>						
                    </div>
                </div>
                <div class="" style="clear: both;height: 2px;background-color: #CFCFCF"></div>
                <div style="padding: 20px">
                    <div class="row-fluid" style="width : 100%;overflow-x: scroll;">
                        <canvas id="c" width="<?php echo $this->maxWidth ?>" height="<?php echo $this->maxHeigth ?>"></canvas>
                    </div>
                </div>
            </div>
    <div class="modal hide fade" id="MR-IFRAME-MODAL" style="width: 800px;margin-left: 0px; left: 19%;">
            <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;</button>
                    <h3><?php echo JText::_('COM_MARKETINGROCKET_LOGICS_TITLE') ?></h3>
            </div>
            <div class="modal-body main sbox-content-iframe">
                    <iframe width="800px" height="400px" frameborder="0" src="">

                    </iframe>
            </div>

            <div class="modal-footer">
                    <a href="#" class="btn" data-dismiss="modal">Close</a> 
            </div>
    </div>
    <div class="modal hide fade" id="modal">
        <div class="modal-body ">
            <div id="connect">
                <h2 class="text-center"><?php echo JText::_('COM_MARKETINGROCKET_HOW_CONNECT_THEM') ?></h2>
                <div style="padding : 15px">
                   <?php 
                   $data = array();
                   $obj = new stdClass();
                   $obj->id = 0;
                   $obj->text = '';
                   $data[] = $obj;

                   $obj = new stdClass();
                   $obj->id = 1;
                   $obj->text =  JText::_('COM_MARKETINGROCKET_CONNECTED_SOMEWHERE');
                   $data[] = $obj;

                   echo JHtml::_('select.radiolist', $data, 'action', null, 'id'); ?>
               </div>
            </div>
            <div id="disconnect">
                <h2 class="text-center"><?php echo JText::_('COM_MARKETINGROCKET_DISCONNECT_THIS_LANDING_FROM') ?></h2>
                <div style="padding : 15px">
                    <div class="controls"></div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <a href="#" class="btn" data-dismiss="modal">Cancel</a>
            <a href="#" class="btn btn-primary"><?php echo JText::_('JTOOLBAR_SAVE') ?></a>
        </div>
    </div>
	<script type="text/javascript">
         if(jQuery('#c').parent().width() > jQuery('#c').attr('width')){
             jQuery('#c').attr('width', jQuery('#c').parent().width());
         }
         
         var browserSupportDownload = false;
        var a = document.createElement('a');
        if (typeof window.btoa != "undefined" && typeof a.download != "undefined") {
          browserSupportDownload = true;
        }
        var browserSupportBlob = window.Blob && window.navigator.msSaveOrOpenBlob;
         
            var activeObj = false;
            var notConnected = false;
            var dropZones = [];
            var canClick = <?php echo (isset($this->cantClick)) ? 'false' : 'true' ?>;
        jQuery(document).ready(function(){
            canvas = new fabric.Canvas('c', { selection: false, backgroundColor:  '#F7F7F7'});
            
            <?php
            foreach ($this->cols as $col){
                foreach($col as $item){
                    $rand = uniqid();
                    if($item->type == 'dropzone'): ?>
                        fabric.Image.fromURL('components/com_marketingrocket/assets/images/visualiser/drop-zone.png', function(img) {
                            var oImg = img.set({ left: <?php echo $item->left ?>, top: <?php echo $item->top ?>, hasRotatingPoint : false,hasBorders: false,hasControls: false, selectable: false});
                            oImg.elType = 'dropzone';
                            oImg.landingText = "<?php echo $item->landingText ?>";
                            oImg.landingId = <?php echo $item->landingId ?>;
                            canvas.add(oImg).renderAll();
                            canvas.renderAll();
                            oImg.moveTo(9999);
                       
                            dropZones.push(oImg);
                            
                        });
                        
                    <?php 
                    continue; 
                    endif; 
                    
                    foreach ($item->lines as $keyLine => $line){ ?>
                        
                          
                          triangle<?php echo $keyLine ?> = new fabric.Triangle({
                                width: 10,
                                height: 15, 
                                angle : 90,
                                fill: '<?php echo $line['color'] ?>',
                                left: <?php echo $line['end_left']-($this->landingWidth/2) ?>+4, 
                                top: <?php echo $line['end_top'] ?>-4
                          });
                          
                        canvas.add(triangle<?php echo $keyLine ?>);
                        
                        line<?php echo $keyLine ?> = new fabric.Line(<?php echo '['.$line['start_left'].','.$line['start_top'].','.$line['end_left'].','.$line['end_top'].']' ?>, {
                            fill: '<?php echo $line['color'] ?>',
                            stroke: '<?php echo $line['color'] ?>',
                            hasBorders : true,
                            strokeWidth: 2,
                            selectable: false,
                            triangle : triangle<?php echo $keyLine ?>,
                            elType : '<?php echo $line['type'] ?>',
                            objId : '<?php echo (!empty($line['object_id'])) ? $line['object_id'] : '' ?>',
                            objType : '<?php echo (!empty($line['object_type'])) ? $line['object_type'] : ''  ?>',
                            objTitle : '<?php echo (!empty($line['object_title'])) ? JText::_($line['object_title'], true) : ''  ?>'
                        });
                        canvas.add(line<?php echo $keyLine ?>);
                        
                        var ang = GetAngle(line<?php echo $keyLine ?>.x1,line<?php echo $keyLine ?>.y1,line<?php echo $keyLine ?>.x2,line<?php echo $keyLine ?>.y2);
                        triangle<?php echo $keyLine ?>.setAngle(ang);
                        
                         
                        var pos = getNewLocation(line<?php echo $keyLine ?>.x1,line<?php echo $keyLine ?>.y1,line<?php echo $keyLine ?>.x2,line<?php echo $keyLine ?>.y2, ang);

                       var data = fixPosition(ang, pos)

                       triangle<?php echo $keyLine ?>.setLeft(data[0]).setTop(data[1]);
                        
                        line<?php echo $keyLine ?>.setOpacity(0.3);
                    <?php }
                    
                    $elHeight = $this->landingHeight;
                    if($item->type == 'action'){
                        $elHeight  = $this->actionHeight;
                    }
                    $text = JText::_($item->title, true);
                    if(mb_strlen($text, 'UTF-8') > 15){
                        $all = findLastSpace($text,60);
                        $firstLine = findLastSpace($all,15, false);
                        $rowCountString = 1;
                        $remain = str_replace($firstLine, '', $all, $rowCountString);
                        $text = $firstLine.'\r\n'.$remain;
                    }
                    ?>
                        text<?php echo $rand ?>  = new fabric.Text('<?php echo $text ?>', { 
                            left: <?php echo $item->left ?>,
                            top: <?php echo $item->top+$elHeight+5 ?>,
                            selectable: false,
                            textBackgroundColor : '#F7F7F7',
                            fontSize : 12,
                            textAlign : 'center'
                        });
                        canvas.add(text<?php echo $rand ?>); 
                       
                       fabric.Image.fromURL('components/com_marketingrocket/assets/images/visualiser/<?php echo $item->image ?>.png', function(img) {
                            var oImg = img.set({ left: <?php echo $item->left ?>, top: <?php echo $item->top ?>, hasRotatingPoint : false,hasBorders: false,hasControls: false});
                            oImg.itemType = '<?php echo $item->type ?>';
                            oImg.itemId = '<?php echo $item->id ?>';
                            oImg.text = text<?php echo $rand ?>;
                            <?php 
                            $i = 0;
                            foreach ($item->lines as $keyLine => $line){ ?>
                                oImg.line<?php echo $i ?> = line<?php echo $keyLine ?>;
                            <?php 
                                $i++;
                            } 
                            $i = 0;
                            foreach ($item->endPoints as $keyLine => $line){ ?>
                                oImg.endLine<?php echo $i ?> = line<?php echo $keyLine ?>;
                            <?php 
                                $i++;
                            } ?>
                            canvas.add(oImg).renderAll();
                            
                            if(oImg.text.width < oImg.width){
                                var center = (oImg.width/2)+oImg.left;
                                oImg.text.setLeft(center-(oImg.text.width/2));
                                canvas.renderAll();
                            }
                            
                        });
                        
                        
                        
                    <?php
                }
            }
            if(count($this->notConnected)){
                ?>
                var unConnectedText  = new fabric.Text('<?php echo JText::_('COM_MARKETINGROCKET_NOT_CONNECTED_TO_FUNNEL') ?>', { 
                    left: 30,
                    top: <?php echo $this->maxHeigth-200 ?>,
                    selectable: false,
                    textBackgroundColor : '#F7F7F7',
                    fontSize : 14,
                    textAlign : 'center'
                });
                canvas.add(unConnectedText); 

                <?php 
            }
            $left = 30;
            foreach ($this->notConnected as $notConnected){ 
                    $rand = uniqid();
                    
                    $text = JText::_($notConnected->title, true);
                    if(mb_strlen($text, 'UTF-8') > 15){
                        $all = findLastSpace($text,60);
                        $firstLine = findLastSpace($all,15, false);
                        $rowCountString = 1;
                        $remain = str_replace($firstLine, '', $all, $rowCountString);
                        $text = $firstLine.'\r\n'.$remain;
                    }
                    
                ?>
                text<?php echo $rand ?>  = new fabric.Text('<?php echo $text ?>', { 
                   left: <?php echo $left ?>,
                   top: <?php echo $this->maxHeigth-50 ?>,
                   selectable: false,
                   textBackgroundColor : '#F7F7F7',
                   fontSize : 12,
                   textAlign : 'center'
               });
               canvas.add(text<?php echo $rand ?>); 
               fabric.Image.fromURL('components/com_marketingrocket/assets/images/visualiser/<?php echo $notConnected->page_type ?>.png', function(img) {
                    var oImg = img.set({ left: <?php echo $left ?>, top: <?php echo $this->maxHeigth-$this->landingHeight-60 ?>, hasRotatingPoint : false , hasBorders: false,hasControls: false});
                    oImg.itemType = 'notconnected';
                    oImg.itemId = <?php echo $notConnected->id ?>;
                    oImg.text = text<?php echo $rand ?>;

                    canvas.add(oImg).renderAll();
                    if(oImg.text.width < oImg.width){
                        var center = (oImg.width/2)+oImg.left;
                        oImg.text.setLeft(center-(oImg.text.width/2));
                        canvas.renderAll();
                    }

                });
            <?php 
                $left += $this->landingWidth+30;
                    } ?>
            jQuery.each(dropZones, function(){
                this.moveTo(100);
            });
            canvas.on('object:moving', function(e) {
                var p = e.target;
                
                if(p.left < 0){
                    p.left = 0;
                    p.setLeft(0);
                }
                if(p.left+p.width > jQuery('#c').width()){
                    p.left = jQuery('#c').width()-p.width;
                    p.setLeft(p.left);
                } 
                if(p.top < 0){
                    p.top = 0;
                    p.setTop(0);
                }
                if(p.top+p.height > jQuery('#c').height()){
                    p.top = jQuery('#c').height()-p.height;
                    p.setTop(p.top);
                }
                
                
                p.text.set({'left' : p.left, 'top' : p.top+p.height+5});
                if(p.text.width < p.width){
                    var center = (p.width/2)+p.left;
                    p.text.setLeft(center-(p.text.width/2));
                    canvas.renderAll();
                }
                var i = 0;
                while(p['line'+i] != undefined){
                    if(p['line'+i].elType == 'to_responder')
                        p['line'+i].set({'x1' : p.left+(p.width/2), 'y1' : p.top+(p.height/2)});
                    else 
                        p['line'+i].set({'x1' : p.left+(p.width/2), 'y1' : p.top+(p.height/2)});
                    
                    var ang = GetAngle(p['line'+i].x1,p['line'+i].y1,p['line'+i].x2,p['line'+i].y2);
                    p['line'+i].triangle.rotate(ang);
                    
                    var pos = getNewLocation(p['line'+i].x1,p['line'+i].y1,p['line'+i].x2,p['line'+i].y2, ang);
                    
                   var data = fixPosition(ang, pos);
                    
                    p['line'+i].triangle.setLeft(data[0]).setTop(data[1]);
                    
                    i++;
                }
                var i = 0;
                while(p['endLine'+i] != undefined){
                    if(p['endLine'+i].elType == 'to_responder')
                        p['endLine'+i].set({'x2' : p.left+(p.width/2), 'y2' : p.top+(p.height/2)});
                    else 
                        p['endLine'+i].set({'x2' : p.left+(p.width/2), 'y2' : p.top+(p.height/2)});
                    
                    var ang = GetAngle(p['endLine'+i].x1,p['endLine'+i].y1,p['endLine'+i].x2,p['endLine'+i].y2);
                    p['endLine'+i].triangle.rotate(ang);
                    
                    var pos = getNewLocation(p['endLine'+i].x1,p['endLine'+i].y1,p['endLine'+i].x2,p['endLine'+i].y2, ang);
                    
                   var data = fixPosition(ang, pos)
                    
                    p['endLine'+i].triangle.setLeft(data[0]).setTop(data[1]);
                    i++;
                    
                }
                canvas.renderAll();
            });
            
            canvas.on('mouse:down', function(options) {
                console.log(options.target);
                
                if (options.target && options.target.itemType) {
                    activeObj = true;
                }
                if(options.target && options.target.itemType == 'notconnected'){
                    notConnected = options.target;
                }
                else {
                    notConnected = false;
                }
            });
            canvas.on('mouse:move', function(options) {
                setTimeout(function(){
                    activeObj = false;
                },100)
                
            });
            canvas.on('mouse:up', function(options) {
                if (activeObj && options.target && options.target.itemType && canClick) {
                    switch(options.target.itemType){
                        case 'responder' :
                            if(parseInt(options.target.itemId) != options.target.itemId){
                                return false;
                            }
                            window.open("index.php?option=com_marketingrocket&task=sequence.edit&id="+options.target.itemId, "_blank");
                            break;
                        case 'landing' :
                            window.open("index.php?option=com_marketingrocket&task=landing.edit&id="+options.target.itemId, "_blank");
                            break;
                        case 'action' :
                            showActionPopUp(options.target.itemId);
                            break;
                    }
                }
                if(notConnected != false){
                    var t = options.target;
                    t.right = t.left+t.width;
                    t.bottom = t.top+t.height;
                    jQuery.each(dropZones, function(){
                        if(
                            (t.left >= this.left && t.left <= this.left+this.width && t.top >= this.top && t.top <= this.top+this.height)
                            ||
                            (t.right >= this.left && t.right <= this.left+this.width && t.bottom >= this.top && t.bottom <= this.top+this.height)
                            ||
                            (t.right >= this.left && t.right <= this.left+this.width && t.top >= this.top && t.top <= this.top+this.height)
                            ||
                            (t.left >= this.left && t.left <= this.left+this.width && t.bottom >= this.top && t.bottom <= this.top+this.height)
                        ){
                            sourceId = this.landingId;
                            droppedId = t.itemId;
                            dropFunction(this.landingText);
                        }
                    });
                }
                notConnected = false;
                activeObj = false;
            });
            
            defJson = JSON.stringify(canvas);
            
              
            
            
        })
        var doRefresh = false;
        var droppedId = sourceId = 0;
        var optionText = '<?php echo htmlspecialchars(JText::_('COM_MARKETINGROCKET_SET_THIS_AS_TARGET'), ENT_QUOTES) ?>';
	jQuery('#jform_id').change(function(){
		var href =  jQuery('#campaign-form').attr('action');
		var val =  jQuery(this).val();
		location.href = href+"&id="+val;
	});
        
        var dropFunction = function(text){
            var $ = jQuery;
            $('#connect').show();
            $('#disconnect').hide();
            $('#modal').modal({
                    backdrop: 'static',
                    keyboard: false
                }).modal('show');

            var input = $('#modal').find('label:first').find('input').clone(true);
            $('#modal').find('label:first').html(
                optionText.replace(
                    '%s',
                    $.trim(text)
                )
            ).prepend(input);
        }
        
        jQuery(document).ready(function(){
            var $ = jQuery;
            $('#modal').find('a:last').click(function(){
                var token = $('#token_holder').find('input').attr('name');
                
                if($('#connect').is(':visible')){
                    var data = {droppedId : droppedId,sourceId : sourceId, type : $('input[name="action"]:checked').val()};
                    data[token] = 1;
                    $.ajax({
                            url: 'index.php?option=com_marketingrocket&task=visualiser.connect',
                            data : data,
                            type: "POST",
                            dataType : 'json'
                    }).done(function(res){
                         if(res.success)
                            location.href = location.href.replace('#', '')
                        else {
                            alert(res.message);
                        };
                    })
                }
                else {
                    var data = {id : $('#modal').find('[name="id"]:checked').val()};
                    data[token] = 1;
                    $.ajax({
                            url: 'index.php?option=com_marketingrocket&task=visualiser.disconnect',
                            data : data,
                            type: "POST",
                            dataType : 'json'
                    }).done(function(res){
                        location.href = location.href.replace('#', '')
                    })
                }
                
               
            })
            $('#modal').find('a:first').click(function(){
                $('.dropped').css('left', '').css('top', '');
            })
            
            $('.vis-page-arrow-right').click(function(){
                var b = confirm('<?php echo JText::_('COM_MARKETINGROCKET_ARE_YOU_SURE_FOR_DISCONECT', true) ?>');
                if(b){
                    
                }
            })
            
            $('#MR-IFRAME-MODAL').on('hide', function (){
                if(doRefresh){
                    location.href = location.href;
                }
            })
            <?php if(empty($this->dontShowDelete)): ?>
                $('#c').next().bind('contextmenu', function (env) {
                    var x = env.offsetX;
                    var y = env.offsetY;
                    $.each (canvas._objects, function(i, e) {
                        if(this.itemType != 'landing')
                            return true;
                       if(x >= this.left && x <= this.width+this.left && y >= this.top && y <= this.top+this.height){
                           var counter = 0;
                           $('#disconnect').find('div:last').html('');
                           while(this['endLine'+counter] != undefined){
                               var l = this['endLine'+counter];
                               counter++;
                               if(l.objType != 'landing')
                                   continue;
                               var label = $('<label></label>');
                               label.attr('for','dis-landing-'+l.objId).addClass('radio');
                               var input = $('<input></input>');
                               input.attr('type', 'radio').attr('name', 'id').attr('id', 'dis-landing-'+l.objId).attr('value',l.objId).appendTo(label);
                               var span = $('<span></span>');
                               span.text('Disconnect From "'+l.objTitle+'"').appendTo(label);
                               label.appendTo($('#disconnect').find('div:last'));
                           }
                           if(counter>0){
                               $('#modal').find('[name="id"]:first').prop('checked', true)
                               $('#connect').hide();
                                $('#disconnect').show();
                                $('#modal').modal({
                                        backdrop: 'static',
                                        keyboard: false
                                }).modal('show');
                           }

                           return false; //in case the icons are stacked only take action on one.
                        }
                    });
                     return false;
                });
            <?php endif; ?>
           
            $('#save_as').click(function(){
                canvas.clone(function(clone){
                    $(clone.getObjects()).each(function(){
                        if(this.type == 'image' && this.src.search('drop-zone.png') > -1){
                            this.remove();
                        }
                    });
                    
                    if (browserSupportDownload){
                        var a = document.createElement('a');
                        a.href = clone.toDataURL('image/png')
                        a.download = 'funnel.png';
                        document.body.appendChild(a);
                        a.click();
                        a.remove();
                    }
                    else if (browserSupportBlob && canvas.msToBlob) {
                        var blobObject = clone.msToBlob();
                        window.navigator.msSaveOrOpenBlob(blobObject, 'funnel.png');
                        
                    }
                    else {
                        var image = clone.toDataURL("image/png").replace("image/png", "image/octet-stream");  // here is the most important part because if you dont replace you will get a DOM 18 exception.
                        jQuery('#download-iframe').attr('src', image)
                    }
                    
                    
//                     
                })
                
               
            })
        });
        
        var showActionPopUp = function(landingId){
            $ = jQuery;
            $('#MR-IFRAME-MODAL').find('h3:first').text('<?php echo JText::_('COM_MARKETINGROCKET_LOGICS_TITLE') ?>');
            $('#MR-IFRAME-MODAL').modal('show');
            
            var campaginId = $('#jform_id').val();
            
            $('#MR-IFRAME-MODAL').find('iframe').attr('src', 'index.php?option=com_marketingrocket&view=action&layout=edit&tmpl=component&landing_id='+landingId+'&campaing_id='+campaginId)
        }
        
        function GetAngle(X1, Y1, X2, Y2) {
            var angleDeg = Math.atan2(Y2 - Y1, X2 - X1) * 180 / Math.PI;
            return angleDeg+90;
        }
        
        var lineLength = function(x, y, x0, y0){
            return Math.sqrt((x -= x0) * x + (y -= y0) * y);
        };
        
        function getNewLocation(x1,y1,x2,y2,Ang ){
            
            var xlen = x2 - x1;
            var ylen = y2 - y1;
            
            var hlen = lineLength(x1,y1,x2,y2);
            var smallerLen = hlen-70;
            
            var ratio = smallerLen / hlen;

            var smallerXLen = xlen * ratio;
            var smallerYLen = ylen * ratio;
            
            var smallerX = x1 + smallerXLen;

            var smallerY = y1 + smallerYLen;
            
            return [smallerX, smallerY];
            
        }
        
        var fixPosition = function(ang, pos){
             if(ang >= 90 && ang <= 180){
                var r = ang-90;
                r = r/90;
                var f = 4-(r*4);
                var t = pos[1]-f;

                var r = ang-180;
                r = r*-1;
                r = r/90;
                var l = pos[0];
                var f = 6-(r*6);
                var l = l+f;
            }
            else if(ang > 180 && ang <= 270){

                var r = ang-270;
                r = r*-1;
                r = r/90;
                var f = 6-(r*6);
                var t = pos[1]+f;

                var r = ang-180;
                r = r/90;
                var l = pos[0];
                var f = 6-(r*6);
                var l = l+f;
            }
            else if(ang > -90 && ang <= 0){
                var r = ang+90;
                r = r/90;
                var f = 6-(r*6);
                var t = pos[1]+f;

                var r = ang;
                r = r*-1;
                r = r/90;
                var l = pos[0];
                var f = 4-(r*4);
                var l = l-f;
            }
            else {
                var r = ang-90;
                r = -1*r;
                r = r/90;
                var f = 4-(r*4);
                var t = pos[1]-f;

                var r = ang-180;
                r = r*-1;
                r = r/90;
                var l = pos[0];
                var f = 6-(r*6);
                var l = l+f;
            }
            
            return [l, t];
        }
        
	</script>
        <iframe width="0" height="0" style="border : 0px solid" id="download-iframe"></iframe>
<?php echo $this->loadTemplate('video_modal'); ?>
<?php
function findLastSpace($string , $maxLength, $addPoints = true){
    if(mb_strlen($string, 'UTF-8') <= $maxLength)
        return $string;
    if(mb_substr($string, $maxLength, $maxLength+1, "UTF-8") == ' ')
            return mb_substr($string, $maxLength, null, "UTF-8");
    $string = mb_substr($string, 0, $maxLength, "UTF-8");
    $length = strlen($string);
    while(substr($string, -1) != ' '){
        $length--;
        if($length < 1)
            break;
        $string = substr($string, 0, $length);
    }
    if($addPoints)
        $string = $string.'...';
    return $string;
}

?>