<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined ( '_JEXEC' ) or die ();

JHtml::addIncludePath ( JPATH_COMPONENT . '/helpers/html' );
JHtml::_ ( 'behavior.tooltip' );
JHtml::_ ( 'formbehavior.chosen', 'select' );

					$names = array(
						1 => JText::_('COM_MARKETINGROCKET_SQUEEZE_PAGE'),
						2 => JText::_('COM_MARKETINGROCKET_CONTENT_PAGE'),
						3 => JText::_('COM_MARKETINGROCKET_SALES_PAGE'),
						4 => JText::_('COM_MARKETINGROCKET_CHECKOUT_PAGE'),
						5 => JText::_('COM_MARKETINGROCKET_SPECIAL_OFFER_PAGE'),
						6 => JText::_('COM_MARKETINGROCKET_THANKYOU_PAGE'),
						7 => JText::_('COM_MARKETINGROCKET_WEBINAR_PAGE')
					);
?>
<div class="row-fluid">
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
		<br />
		<a onclick="showmodal()" style="cursor: pointer;">
			<img src="<?php echo $this->videoHelp['img'] ?>" alt="<?php echo $this->videoHelp['text'] ?>" />
			<p><?php echo JText::_('COM_MARKETINGROCKET_CLICK_HERE_FOR_MORE_SUPPORT') ?></p>
		</a>
	</div>
	<div id="j-main-container" class="span10">
		<div class="row-fluid visualiser form-horizontal">
			<div class="span12 vis-top-backing">
				<form action="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=visualiser') ?>" id="campaign-form">
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('id'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('id'); ?></div>
					</div>
				</form>
				<div class="vis-legend">
					<div class="vis-legend-box">
						<div class="vis-legend-item vis-legend-title-flip">
							<span class="vis-legend-title"><?php echo JText::_('COM_MARKETINGROCKET_VISUALISER_LEGEND') ?></span>
						</div>
						<?php
							foreach($names as $imageid => $name){
								echo
								'
								<div class="vis-legend-item">
									<span>
										<img src="components/com_marketingrocket/assets/images/visualiser/legend/'. $imageid .'.png" />
									</span>
									<span class="vis-item-title">
										'.$name.'
									</span>
								</div>
								';
							}
						?>
						<div class="vis-legend-item">
							<span>
								<img src="components/com_marketingrocket/assets/images/visualiser/legend/responder.png" />
							</span>
							<span class="vis-item-title">
								<?php echo JText::_('COM_MARKETINGROCKET_SEQUENCE_SHORT') ?>
							</span>
						</div>
						<div class="vis-legend-item">
							<span>
								<img src="components/com_marketingrocket/assets/images/visualiser/legend/action.png" />
							</span>
							<span class="vis-item-title">
								<?php echo JText::_('COM_MARKETINGROCKET_FORM_ACTION_STEPS') ?>
							</span>
						</div>						
					</div>
				</div>
			</div>
		</div>	
		
				<?php
                                    $notConnecteds = "";
                                    $lastType = '';
                                    $nestedArray = array();
                                    $allTargets = array();
                                    $allParents = array();
                                    $normalizendItems = array();
                                    $notConnecteds = array();
                                    $nestedArrayIds = array();
                                            foreach ($this->items as $item){
                                                if(!empty($item->to_landing_page) && $item->form_or_cta != 'none'){
                                                    $allTargets[] = $item->to_landing_page;
                                                    $allParents[] = $item->id;
                                                }
                                                else 
                                                    $notConnecteds[] = $item;
                                                $normalItmes[$item->id] = $item;
                                            }

                                            foreach ($allParents as $key => $parent){
                                                if(in_array($parent, $allTargets)){ // so its first landing
                                                    unset($allParents[$key]);
                                                } 
                                            }

                                            foreach ($allParents as $parent){

                                                $indicator = $parent;
                                                $nestedArray[$parent] = array($normalItmes[$indicator]);
                                                $nestedArrayIds[$parent] = array($indicator);
                                                // found all connected with this parent
                                                do {
                                                     $indicator = $normalItmes[$indicator]->to_landing_page;
                                                     $nestedArray[$parent][] = @$normalItmes[$indicator];
                                                     $nestedArrayIds[$parent][] = $indicator;
                                                }
                                                while(!empty($normalItmes[$indicator]->to_landing_page) && $normalItmes[$indicator]->form_or_cta != 'none');

                                            }
                                            foreach ($nestedArray as $parentId => $items){
                                                $lastType = '';
                                                echo '<div class="row-fluid visualiser vis-content-scroller">';
                                                $width = 100/(count($items)+1);
                                                $width =  $width-3;
                                                foreach ($items as $item){
                                                    if(!is_object($item))
                                                        continue;;
                                                    if(!empty($lastType)){
                                                        echo '</div>';
                                                    }
                                                                                                            // removed SPAN2 from below, as horizontal will no longer be responsive, it will be scrollable.
                                                    echo '<div class="text-center vis-col-width" style="width:'.$width.'%">';
                                                    //echo '<span>'.$names[$item->type].'</span>';
                                                    $lastType = $item->type;
                                                                                                            $trimtitle = $item->title;

                                                                                                            if(strlen($item->title) > 34){
                                                                                                            $trimtitle = substr($item->title, 0, 34);
                                                                                                            $trimtitle = $trimtitle . '...' ;
                                                                                                            }
                                                                                                            // the below ARROW RIGHT item will need to be modified to show ACTIONS when we have implemented them.. it will change into an action icon
                                                                                                            // when required, and on click, it will popup a modal allowing to edit the actions.
                                                    echo 
                                                        '<a href="index.php?option=com_marketingrocket&view=landing&layout=edit&id='.$item->id.'" alt="'.$item->title.'" title="'.$item->title.'" data-id="'.$item->id.'" class="vis-page-arrow">
                                                            <span>
                                                                <img src="components/com_marketingrocket/assets/images/visualiser/'. $item->type .'.png" />
                                                            </span>
                                                            <span class="vis-item-title">
                                                                                                                                    '.$trimtitle.'
                                                                                                                            </span>
                                                        </a>
                                                                                                                    <div class="vis-page-arrow-right"> </div>
                                                                                                                    ';
                                                     if($item->responder_type != '0'): 
                                                            if(is_array(json_decode($item->responder_sequence_id,true)) == true){
                                                                $ids = json_decode($item->responder_sequence_id);
                                                            }
                                                            else 
                                                                $ids = array($item->responder_sequence_id);
                                                            if($item->responder_type == 'default'){
                                                                $namnes = array();

                                                                $inCounter = 0;

                                                                foreach ($ids as $id){
                                                                    $seqTable = JTable::getInstance('Sequence', 'MarketingrocketTable');
                                                                    $seqTable->load($id);
                                                                    if(empty($seqTable->id))
                                                                        continue;
                                                                    if($inCounter == 0){
                                                                         echo '<div class="auto-responder">';
                                                                    }
                                                                    $inCounter++;

                                                                    $trimseqtitle = $seqTable->name;
                                                                    if(strlen($seqTable->name) > 34){
                                                                            $trimseqtitle = substr($seqTable->name, 0, 34);
                                                                            $trimseqtitle = $trimseqtitle . '...' ;
                                                                    }

                                                                    ?>
                                                                    <a href="index.php?option=com_marketingrocket&view=sequence&layout=edit&id=<?php echo $seqTable->id ?>" alt="<?php echo $seqTable->name ?>" title="<?php echo $seqTable->name ?>">
                                                                        <span><img src="components/com_marketingrocket/assets/images/visualiser/responder-sequence.png" /></span>
                                                                        <span class="vis-item-title">
                                                                        <?php echo $trimseqtitle ?>
                                                                        </span>
                                                                    </a>
                                                                    <?php
                                                                }
                                                                if($inCounter > 0){
                                                                    echo '</div>';
                                                               }
                                                            }
                                                            else {
                                                                if(count($ids) > 0)
                                                                    echo '<div class="auto-responder">';
                                                                foreach ($ids as $id){
                                                                    ?>
                                                                    <a>
                                                                        <span><img src="components/com_marketingrocket/assets/images/visualiser/responder-sequence.png" /></span>
                                                                        <?php echo JText::_('COM_MARKETINGROCKET_'.strtoupper($item->responder_type)) ?>
                                                                    </a>
                                                                    <?php
                                                                }
                                                                if(count($ids) > 0)
                                                                    echo '</div>';
                                                            }
                                                         ?>

                                                    <?php endif;
                                                }
                                                echo '</div><div class="dropzone text-center droppable" data-id="'.@$item->id.'"></div></div>';
                                            }
                                            ?>
                    <div class="row-fluid not-connected">
			<?php 
                        $newNotConnected = array();
                        foreach ($notConnecteds as $item){
                            if(!in_array($item->id, $allTargets))
                                    $newNotConnected[] = $item;
                        }
                        if(!empty($newNotConnected)): ?>
                            <h2 style="margin-left : 10px"><?php echo JText::_('COM_MARKETINGROCKET_NOT_CONNECTED_TO_FUNNEL') ?></h2>
			<?php endif; ?>
			<?php 
                        $i = 0;
                        foreach ($newNotConnected as $item): 
                            if($i % 6 === 0){
                                if($i > 0)
                                    echo '</div>';
                                echo '<div class="row-fluid">';
                            }
                            $trimtitle = $item->title;
                            if(strlen($item->title) > 34){
                                    $trimtitle = substr($item->title, 0, 34);
                                    $trimtitle = $trimtitle . '...' ;
                            }
                            echo 
                                '<div class="span2 text-center draggable" data-id="'.$item->id.'">
                                    <a href="index.php?option=com_marketingrocket&view=landing&layout=edit&id='.$item->id.'" alt="'.$item->title.'" title="'.$item->title.'">
                                        <span>
                                            <img src="components/com_marketingrocket/assets/images/visualiser/'. $item->type .'.png" />
                                        </span>
                                        <span class="vis-item-title">
                                            '.$trimtitle.'
                                        </span>
                                    </a>
                                </div>';
                            $i++;
                         endforeach; ?>
                    </div>
		</div>
	</div>
        <div id="token_holder">
            <?php echo JHtml::_('form.token'); ?>
        </div>
        <div class="modal hide fade" id="modal">
            <div class="modal-body ">
                
                    <h2 class="text-center"><?php echo JText::_('COM_MARKETINGROCKET_HOW_CONNECT_THEM') ?></h2>
                 <div style="padding : 15px">
                    <?php 
                    $data = array();
                    $obj = new stdClass();
                    $obj->id = 0;
                    $obj->text = '';
                    $data[] = $obj;
                    
                    $obj = new stdClass();
                    $obj->id = 1;
                    $obj->text =  JText::_('COM_MARKETINGROCKET_CONNECTED_SOMEWHERE');
                    $data[] = $obj;
                    
                    echo JHtml::_('select.radiolist', $data, 'action', null, 'id'); ?>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn" data-dismiss="modal">Cancel</a>
                <a href="#" class="btn btn-primary"><?php echo JText::_('JTOOLBAR_SAVE') ?></a>
            </div>
        </div>
	<script type="text/javascript">
        var droppedId = sourceId = 0;
        var optionText = '<?php echo htmlspecialchars(JText::_('COM_MARKETINGROCKET_SET_THIS_AS_TARGET'), ENT_QUOTES) ?>';
	jQuery('#jform_id').change(function(){
		var href =  jQuery('#campaign-form').attr('action');
		var val =  jQuery(this).val();
		location.href = href+"&id="+val;
	});
        jQuery(document).ready(function(){
            var $ = jQuery;
            $('.droppable').droppable({
                drop: function( event, ui ) {
                    var $ = jQuery;
                    droppedId = ui.draggable.data('id');
                    sourceId = $(event.target).data('id');
                    $('#modal').modal({
                            backdrop: 'static',
                            keyboard: false
                        }).modal('show');
                        
                    var input = $('#modal').find('label:first').find('input').clone(true);
                    $('#modal').find('label:first').html(
                        optionText.replace(
                            '%s',
                            $.trim($(event.target).prev().find('a').text())
                        )
                    ).prepend(input);
                    ui.draggable.addClass('dropped');
                }   
            });
            $('.draggable').draggable({ revert: "invalid" });
            $('#modal').find('a:last').click(function(){
                var token = $('#token_holder').find('input').attr('name');
                var data = {droppedId : droppedId,sourceId : sourceId, type : $('input[name="action"]:checked').val()};
                data[token] = 1;
                $.ajax({
                        url: 'index.php?option=com_marketingrocket&task=visualiser.connect',
                        data : data,
                        type: "POST",
                        dataType : 'json'
                }).done(function(res){
                     if(res.success)
                        location.href = location.href.replace('#', '')
                    else {
                        alert(res.message);
                    }
                })
            })
            $('#modal').find('a:first').click(function(){
                $('.dropped').css('left', '').css('top', '');
            })
            
            $('.vis-page-arrow-right').click(function(){
                var b = confirm('<?php echo JText::_('COM_MARKETINGROCKET_ARE_YOU_SURE_FOR_DISCONECT', true) ?>');
                if(b){
                    var token = $('#token_holder').find('input').attr('name');
                    var data = {id : $(this).prev().data('id')};
                    data[token] = 1;
                    $.ajax({
                            url: 'index.php?option=com_marketingrocket&task=visualiser.disconnect',
                            data : data,
                            type: "POST",
                            dataType : 'json'
                    }).done(function(res){
                        location.href = location.href.replace('#', '')
                    })
                }
            })
            
        });
        
	</script>
</div>
<?php echo $this->loadTemplate('video_modal'); ?>