<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketViewStatus extends JViewLegacy
{
	protected $state;

	protected $item;

	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{

		$this->state	= $this->get('State');
		$this->item		= $this->get('Item');
		$this->form		= $this->get('Form');
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{

		JFactory::getApplication()->input->set('hidemainmenu', true);

		$user		= JFactory::getUser();
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		// Since we don't track these assets at the item level, use the category id.
		$canDo		= MarketingrocketHelper::getActions();

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGE_STATUS'), '');

		// If not checked out, can save the item.
		if (($canDo->get('core.edit')))
		{
			JToolbarHelper::apply('status.apply');
			JToolbarHelper::save('status.save');
		}
                JToolbarHelper::save2new('status.save2new');

		if (empty($this->item->id))
		{
			JToolbarHelper::cancel('status.cancel');
		}
		else
		{
			JToolbarHelper::cancel('status.cancel', 'JTOOLBAR_CLOSE');
		}

		JToolbarHelper::divider();
	}
}
