<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketViewSequence extends JViewLegacy
{
	protected $state;

	protected $item;

	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{

		$this->state	= $this->get('State');
		$this->item		= $this->get('Item');
		$this->form		= $this->get('Form');
                
                if(JFactory::getApplication()->input->getString('tmpl') == 'component')
                    $this->responders = array();
                else 
                    $this->responders = $this->get('Responders');
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{

		JFactory::getApplication()->input->set('hidemainmenu', true);

		$user		= JFactory::getUser();
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		// Since we don't track these assets at the item level, use the category id.
		$canDo		= MarketingrocketHelper::getActions();

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGE_SEQUENCES'), '');

		// If not checked out, can save the item.
		if (($canDo->get('core.edit')))
		{
			JToolbarHelper::apply('sequence.apply');
			JToolbarHelper::save('sequence.save');
		}
		JToolbarHelper::save2new('sequence.save2new');
		// If an existing item, can save to a copy.
		if (!$isNew && (count($user->getAuthorisedCategories('com_marketingrocket', 'core.create')) > 0))
		{
			JToolbarHelper::save2copy('sequence.save2copy');
		}
		if (empty($this->item->id))
		{
			JToolbarHelper::cancel('sequence.cancel');
		}
		else
		{
			JToolbarHelper::cancel('sequence.cancel', 'JTOOLBAR_CLOSE');
		}

		JToolbarHelper::divider();
	}
}
