<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class MarketingrocketViewResponders extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		
		$this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );
		
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		require_once JPATH_COMPONENT.'/helpers/marketingrocket.php';
		MarketingrocketHelper::addSubmenu('responders');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
                
                $this->filterForm    = $this->get('FilterForm');

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
		$this->videoHelp = MarketingrocketHelper::videoHelper('responders');
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		

		$state	= $this->get('State');

		$canDo	= MarketingrocketHelper::getActions();
		$user	= JFactory::getUser();
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGER_RESPONDERS'), '');
		JToolbarHelper::addNew('responder.add');
		if ($canDo->get('core.edit'))
		{
			JToolbarHelper::editList('responder.edit');
		}
		if ($canDo->get('core.edit.state')) {

			JToolbarHelper::publish('responders.publish', 'JTOOLBAR_PUBLISH', true);
			JToolbarHelper::unpublish('responders.unpublish', 'JTOOLBAR_UNPUBLISH', true);

			JToolbarHelper::archiveList('responders.archive');
			
		}

			JToolbarHelper::deleteList('COM_MARKETINGROCKET_ARE_YOUR_SURE_ABOUT_DELETE_THIS_ITEMS' , 'responders.delete');


		if ($canDo->get('core.admin'))
		{
			JToolbarHelper::preferences('com_marketingrocket');
		}


		JHtmlSidebar::setAction('index.php?option=com_marketingrocket&view=responders');
                
                $bar = JToolbar::getInstance('toolbar');
                $bar->appendButton('Confirm', 'COM_MARKETINGROCKET_ARE_YOUR_SURE_ABOUT_RESET_STATICS_OF_THIS_ITEMS', 'refresh', JText::_('COM_MARKETINGROCKET_RESET_STATICS'), 'responders.resetstat', true);




	}

}
