<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketViewResponder extends JViewLegacy
{
	protected $state;

	protected $item;

	protected $form;
	
	protected $requestType;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->requestType = JFactory::getApplication()->input->getString('type', null);
                
        if($this->requestType == 'invoice'){

            $db = JFactory::getDbo();
            $q = $db->getQuery(true);
            $q->select('*')->from($db->qn('#__mrocket_responder_templates'))->where($db->qn('type').' = '.$db->q('invoice'));
            $db->setQuery($q);
            $data = $db->loadResult();
            JFactory::getApplication()->input->set('id', $data);


        }

		$this->state	= $this->get('State');
		$this->item		= $this->get('Item');
                
        if($this->requestType == 'invoice' || $this->item->type == 'invoice'){
             JComponentHelper::getParams('com_marketingrocket')->set ('email_editor', 'simple');
        }
                
		$this->form		= $this->get('Form');
		
		$this->templates = $this->get('TemplateList');

                
        $leadsModel = JModelLegacy::getInstance('Leads', 'MarketingrocketModel');

        $tags = $leadsModel->getAllFields();

        JLoader::import('joomla.plugin.helper');
        JPluginHelper::importPlugin('marketingrocket');
        $dispatcher = JDispatcher::getInstance();
        $dispatcher->trigger(
            'onPrepareTagsListInResponder',
            array(&$tags) );

        $tags['MR_submited_date'] = 'Form Submit Date';

        $arr = array_reverse($tags, true);
        $arr['MR_lead_register_date'] = 'Registration Date';
        $arr['campaign_name'] = 'Campaign Name';
        $tags = array_reverse($arr, true);

        $this->tags = $tags;


        if($this->requestType == 'leademail'){
            $session = JFactory::getSession();
            $ids = $session->get( 'send_email_list', array(), 'com_marketingrocket');
            if(empty($ids)){
                JFactory::getApplication()->enqueueMessage('Select Leads First', 'error');
                JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_marketingrocket&view=leads' , false));
            }
        }
                
		
		$campaignId = JFactory::getApplication()->input->getInt('campaign_id', 0);
		
		
		if($campaignId)
			$this->form->setValue('campaign_id', null, $campaignId);
                
            if(!empty($this->requestType))
                $this->form->setValue('type', null, $this->requestType);
            else {
                $this->requestType = 'responder';
            }

            $attachmentsModel = JModelLegacy::getInstance('ResponderAttachment', 'MarketingrocketModel', array('ignore_request' => true));

            $this->attachments = $attachmentsModel->getAttachments();
		
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{

		JFactory::getApplication()->input->set('hidemainmenu', true);

		$user		= JFactory::getUser();
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		// Since we don't track these assets at the item level, use the category id.
		$canDo		= MarketingrocketHelper::getActions();
		
		if($this->requestType == 'responder')
			JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGE_RESPONDER'), '');
		else
			JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_SEND_MARKETING_EMAIL'), '');

		// If not checked out, can save the item.
		if (($canDo->get('core.edit')))
		{
                    $input = JFactory::getApplication()->input;
                    if($input->getInt('wizard', 0) > 0){
                        JToolbarHelper::apply('wizard.applyresponder');
                    }
                    else {
                       if($this->requestType == 'responder')
                            JToolbarHelper::apply('responder.apply');
                       JToolbarHelper::save('responder.save'); 
                    }
			
		}
                if($input->getInt('wizard', 0) == 0){
                    JToolbarHelper::save2new('responder.save2new');
                
                    if($this->requestType == 'responder' && JFactory::getApplication()->input->getInt('id', 0) > 0)
                        JToolbarHelper::custom('responder.savetemplate', 'palette', 'icon', JText::_('COM_MARKETINGROCKET_SAVE_AS_TEMPLATE'), false);
                    
                    if (empty($this->item->id))
                    {
                            JToolbarHelper::cancel('responder.cancel');
                    }
                    else
                    {
                            JToolbarHelper::cancel('responder.cancel', 'JTOOLBAR_CLOSE');
                    }
                }
                else {
                    JToolbarHelper::cancel('wizard.cancel');
                }
              
                
		

		JToolbarHelper::divider();
	}
}
