<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.view');


class MarketingrocketViewReports extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );
		
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
                $this->pagination	= $this->get('Pagination');
                
		$this->hideChart = false;
		
		$this->list = $this->get('Items');
		$model = $this->getModel();
		$begin = $model->getState('filter.begin');
		$end = $tempEnd = $model->getState('filter.end');
		if(empty($end)){
                    $end = JFactory::getDate('now', JFactory::getConfig()->get('offset'))->modify('1 day')->format('Y-m-d');
		}
		$this->stats = $model->getDailyStat($begin, $end);
                
                $startDateObj = JFactory::getDate( strtotime($begin), JFactory::getConfig()->get('offset'));
                $startDateObj->modify('-30 day');
                $pBegin = $startDateObj->format('Y-m-d');
                
                $endDateObj = JFactory::getDate( strtotime($end), JFactory::getConfig()->get('offset'));
                $endDateObj->modify('-30 day');
		$this->convertedCount = $model->getConvertedCount($begin, $end);
                
                
                $this->prevMonthStat = $model->getPrevMonthStat($pBegin, $endDateObj->format('Y-m-d'));
                $this->prevMonthConverted = $model->getConvertedCount($pBegin, $endDateObj->format('Y-m-d'));
		
		
		
		$totalView = 0;
		$totalSubmission = 0;
		foreach ($this->stats as $row){
			$totalView += $row->visits;
			$totalSubmission += $row->submissions;
		}
		$this->totalView = $totalView;
		$this->totalSubmission = $totalSubmission;
		
		if(empty($begin) && empty($tempEnd)){
			$this->endTime =JFactory::getDate('now', JFactory::getConfig()->get('offset'))->getTimestamp();
                        $startDate = JFactory::getDate('now', JFactory::getConfig()->get('offset'));
                        $startDate->modify('-30 day');
			$this->time = $startDate->getTimestamp();
		}
		else if(!empty($begin)){
			$startTime = strtotime($begin);
			$endTime = strtotime($end);
//			if($endTime - $startTime > 2592000){
//				$this->hideChart = true;
//			}
			
			
			$this->endTime = $endTime+86400;
			$this->time = $startTime;
			
		}
		else { // start time is not set so we must hide chart
			$this->hideChart = true;
			$endTime = strtotime($end);
			$this->endTime = $endTime;
			reset($this->stats);
			
			$this->time = strtotime(key($this->stats));
			
		}
                
//                echo '<pre>';
//                print_r($this->stats);
//                die;
		
		$db = JFactory::getDbo();
                $query = $db->getQuery(true);
                $query->select('id,name')->from('#__mrocket_campaign');
                $db->setQuery($query);
                
                $array = array();
		$array[0] = '-';
		$dbReturn = $db->loadAssocList('id', 'name');
		$this->campaigns = $array+$dbReturn;
                
                $this->groupBy = $this->state->get('filter.group', 'd');
                
		$document = JFactory::getDocument ();
                
                
                $document->addScript ( JURI::base() . '/components/com_marketingrocket/assets/js/highcharts-custom.js', "text/javascript" , true );
		
		
		
		MarketingrocketHelper::addSubmenu('reports');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();
		$this->videoHelp = MarketingrocketHelper::videoHelper('reports');
		$this->sidebar = JHtmlSidebar::render();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		

		$state	= $this->get('State');

		$canDo	= MarketingrocketHelper::getActions();
		$user	= JFactory::getUser();
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_REPORTS'), '');
                
                if ($canDo->get('core.admin'))
		{
			JToolbarHelper::preferences('com_marketingrocket');
		}
                JToolbarHelper::apply('reports.export', JText::_('COM_MARKETINGROCKET_EXPORT_TO_PDF'));
		




	}

	/**
	 * Returns an array of fields the table can be sorted by
	 *
	 * @return  array  Array containing the field name to sort by as the key and display text as value
	 *
	 * @since   3.0
	 */
	protected function getSortFields()
	{
		return array(
			'a.id' => JText::_('JGRID_HEADING_ID'),
			'category_title' => JText::_('COM_MARKETINGROCKET_CATEGORIES') 
		);
	}
}
