<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketViewQuicklanding extends JViewLegacy
{
	protected $state;

	protected $item;

	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{

            $this->state	= $this->get('State');
            $this->form		= $this->get('Form');

            // Check for errors.
            if (count($errors = $this->get('Errors')))
            {
                    JError::raiseError(500, implode("\n", $errors));
                    return false;
            }
            
            $this->addTemplatePath( JPATH_COMPONENT.'/views/landingtemplate/tmpl' );
            
            $landingTemplateModel = JModelLegacy::getInstance('landingtemplate', 'MarketingrocketModel', array('ignore_request' => true));
                            
            $this->items = $landingTemplateModel->getItems();
            $this->types = $landingTemplateModel->getTypes();
            $this->canDelete = false;
            
            $this->document->addCustomTag('<link rel="stylesheet" href="' . JURI::root(true) . '/components/com_marketingrocket/assets/css/bootstrap.min.css" type="text/css" />');
            $this->document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/style.css' );
            $this->document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/dashboard.css' );
            
            $this->document->addScript ( JURI::base() . '/components/com_marketingrocket/assets/js/landing-setting.js', "text/javascript" , true );
            $this->document->addScript ( JURI::base() . '/components/com_marketingrocket/assets/js/landing.js', "text/javascript" , true );
            
            

            $this->addToolbar();
            parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
            JFactory::getApplication()->input->set('hidemainmenu', true);
	}
}
