<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.view');


class MarketingrocketViewQueueds extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{

		$this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );

		$this->state		= $this->get('State');

        if(JFactory::getApplication()->input->get('layout') != 'send'){
            $this->items		= $this->get('Items');
		    $this->pagination	= $this->get('Pagination');
        }
        else {
            $this->totalNumber = $this->get('TotalLeft');

            JFactory::getDocument()->addScript ( JURI::base() . '/components/com_marketingrocket/assets/js/ajaxhandler.js', "text/javascript" , true );

        }
		require_once JPATH_COMPONENT.'/helpers/marketingrocket.php';
		MarketingrocketHelper::addSubmenu('queueds');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
                
                $this->filterForm    = $this->get('FilterForm');

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
		$this->videoHelp = MarketingrocketHelper::videoHelper('queueds');
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		

		$state	= $this->get('State');

		$canDo	= MarketingrocketHelper::getActions();
		$user	= JFactory::getUser();
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

        if(JFactory::getApplication()->input->get('layout') != 'send') {

            JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGER_QUEUEDS'), '');
            if ($canDo->get('core.edit')) {
                JToolbarHelper::editList('queued.edit');
            }

            JToolbarHelper::deleteList('COM_MARKETINGROCKET_ARE_YOUR_SURE_ABOUT_DELETE_THIS_ITEMS', 'queueds.delete');

            JToolbarHelper::custom("queueds.send", "play", "", "COM_MARKETINGROCKET_MANUALLY_PROCESS_QUEUE", false);
        }
        else {
            JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANUALLY_PROCESS_QUEUE'), '');
            JToolbarHelper::back();
        }

		if ($canDo->get('core.admin'))
		{
			JToolbarHelper::preferences('com_marketingrocket');
		}


		JHtmlSidebar::setAction('index.php?option=com_marketingrocket&view=quededs');





	}
}
