<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */


?>

<div class="progress progress-danger">
    <div class="bar" id="progress_bar" style="width: 0%"></div>
</div>
<?php echo JText::plural("COM_MARKETINGROCKET_TOTAL_SENT", $this->totalNumber) ?> <span class="loading fa fa-spinner fa-pulse fa-fw"></span>
<br />
<br />
<div class="alert alert-error">
    <?php echo JText::_('COM_MARKETINGROCKET_TOTAL_SENT_NOTE'); ?>
</div>
<?php if($this->totalNumber): ?>
<script type="text/javascript">
    var lastRemain = <?php echo $this->totalNumber ?>;
    var firstVal = <?php echo $this->totalNumber ?>;
    var Tried = 0;
    jQuery(document).ready(function ($) {
        MRsendReqest();
        $('#system-message-container').removeAttr('class');
    })
    MRsendReqest = function () {
        var $ = jQuery;

        var ajaxHandler = new ajaxclass({
            url : '<?php echo JUri::root().'/index.php?option=com_marketingrocket&view=cron&token='.JComponentHelper::getParams('com_marketingrocket')->get('salt') ?>',
            loading : 'hide',
            success : function (res) {

                try {
                    obj = JSON.parse(res);
                    var remain = obj.data.left;

                    if(remain == lastRemain)
                        Tried++;

                    $('#total_sent').text(firstVal-remain);
                    var p = remain/firstVal*100;
                    $('#progress_bar').css('width', (100-p)+'%');
                    lastRemain = remain;
                }
                catch (e){
                    Tried++;
                }
                if(Tried > 3){
                    alert('There is a problem in your cron , please reduce the "Number Of Emails Sent In Each Cron Call" in Component Setting and test again');
                    $('#progress_bar').css('width', '100%');
                    $('.fa-spinner.fa-pulse').hide();
                    return;
                }
                MRsendReqest();
            },
            fail : function () {
                Tried++;
                if(Tried > 3){
                    alert('There is a problem in your cron , please reduce the "Number Of Emails Sent In Each Cron Call" in Component Setting and test again');
                    $('#progress_bar').css('width', '100%');
                    $('.fa-spinner.fa-pulse').hide();
                    return;
                }
                MRsendReqest();
            }
        });
        ajaxHandler.send();

    }
</script>
<?php endif; ?>