<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));

$listDirn	= $this->escape($this->state->get('list.direction'));
$canOrder	= true;
$saveOrder	= $listOrder == 'a.ordering';
?>
<script type="text/javascript">
	Joomla.orderTable = function()
	{
		table = document.getElementById("sortTable");
		direction = document.getElementById("directionTable");
		order = table.options[table.selectedIndex].value;
		if (order != '<?php echo $listOrder; ?>')
		{
			dirn = 'asc';
		}
		else
		{
			dirn = direction.options[direction.selectedIndex].value;
		}
		Joomla.tableOrdering(order, dirn, '');
	}
</script>
<form action="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=queueds'); ?>" method="post" name="adminForm" id="adminForm">
<?php if (!empty( $this->sidebar)) : ?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
		<br />
		<p class="center bold"><a onclick="showmodal()" style="cursor: pointer;color:#fff;">
			<?php echo JText::_('COM_MARKETINGROCKET_WATCH_THE_VIDEO_GUIDE') ?>
			<img src="<?php echo $this->videoHelp['img'] ?>" alt="<?php echo $this->videoHelp['text'] ?>" />
		</a></p>
		<p class="center bold"><?php echo JText::_('COM_MARKETINGROCKET_CLICK_HERE_FOR_MORE_SUPPORT') ?></p>
	</div>
	<div id="j-main-container" class="span10">
<?php else : ?>
	<div id="j-main-container">
<?php endif;?>
            <?php echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
		<table class="table table-striped" id="jokeslist">
			<thead>
				<tr>
					<th width="1%" class="hidden-phone">
						<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
					</th>
					<th width="1%" class="nowrap center hidden-phone">
						<?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_ID', 'id', $listDirn, $listOrder); ?>
					</th>
					<th style="text-align: center">
						<?php echo JHtml::_('searchtools.sort', 'COM_MARKETINGROCKET_RESPONDER_NAME', 'responder_name', $listDirn, $listOrder); ?>
					</th>
                                        <th style="text-align: center">
						<?php echo JHtml::_('searchtools.sort', 'COM_MARKETINGROCKET_SEQUENCE_NAME', 'sequence_name', $listDirn, $listOrder); ?>
					</th>
                                        <th style="text-align: center">
						<?php echo JText::_('COM_MARKETINGROCKET_LEAD_NAME'); ?>
					</th>
					<th style="text-align: center">
						<?php echo JHtml::_('searchtools.sort', 'COM_MARKETINGROCKET_EMAIL', 'email', $listDirn, $listOrder); ?>
					</th>
                                        <th style="text-align: center">
						<?php echo JHtml::_('searchtools.sort', 'COM_MARKETINGROCKET_SEND_STATUS', 'is_done', $listDirn, $listOrder); ?>
					</th>
					<th width="13%" class="nowrap center hidden-phone">
						<?php echo JHtml::_('searchtools.sort', 'COM_MARKETINGROCKET_SEND_DATE', 'cron_date', $listDirn, $listOrder); ?>
					</th>
					
				</tr>
			</thead>
			<tfoot>
				<tr>
					<td colspan="10">
						<?php echo $this->pagination->getListFooter(); ?>
					</td>
				</tr>
			</tfoot>
			<tbody>
			<?php foreach ($this->items as $i => $item) :
				
				
				$ordering   = ($listOrder == 'a.ordering');

				$canCreate  = true;
				$canEdit    = true;
				$canCheckin = true;
				$canChange  = true;
				?>
				<tr class="row<?php echo $i % 2; ?>">
					
					<td class="center hidden-phone">
						<?php echo JHtml::_('grid.id', $i, $item->id); ?>
					</td>
                                        <td class="center hidden-phone">
                                            <a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&task=queued.edit&id='.(int) $item->id); ?>"><?php echo (int) $item->id; ?></a>
					</td>

					<td class=" center" style="word-wrap: break-word;">
						<?php if ($canEdit) : ?>
						<a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&task=responder.edit&id='.(int) $item->responder_id); ?>" target="_blank">
								<?php echo $this->escape($item->responder_name); ?> <i class="fa fa-external-link"></i></a>
						<?php else : ?>
							<?php echo $this->escape($item->responder_name); ?>
						<?php endif; ?>
						
					</td>
                                        <td class="center" style="word-wrap: break-word;">
                                            <?php if(!empty($item->sequence_id)){ ?>
						<?php if ($canEdit) : ?>
						<a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&task=sequence.edit&id='.(int) $item->sequence_id); ?>" target="_blank">
								<?php echo $this->escape($item->sequence_name); ?> <i class="fa fa-external-link"></i></a>
						<?php else : ?>
							<?php echo $this->escape($item->sequence_name); ?>
						<?php endif; ?>
                                            <?php } ?>
						
					</td>
					<td class="center">
						<?php echo $item->full_name ?>
					</td>
					<td class="center" style="word-wrap: break-word;">
						<?php if ($canEdit) : ?>
						<a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&task=lead.edit&id='.(int) $item->lead_id); ?>" target="_blank">
								<?php echo $this->escape($item->email); ?> <i class="fa fa-external-link"></i></a>
						<?php else : ?>
							<?php echo $this->escape($item->email); ?>
						<?php endif; ?>
						
					</td>
                                        <td class="center">
                                            <div class="btn-group">
                                                <?php if($item->is_done){
                                                    echo '<a class="btn btn-micro hasTooltip cursor-default" title="'.JText::_('COM_MARKETINGROCKET_SENT').'"><span class="icon-publish"></span></a>';
                                                }
                                                else 
                                                    echo '<a class="btn btn-micro hasTooltip cursor-default" title="'.JText::_('COM_MARKETINGROCKET_IN_QUEUE').'"><span class="icon-unpublish"></span></a>';
                                                ?>
                                                <?php if($item->is_show){
                                                    echo '<a class="btn btn-micro hasTooltip cursor-default" title="'.JText::_('COM_MARKETINGROCKET_SHOWN').'"><span class="fa fa-eye green"></span></a>';
                                                }
                                                else 
                                                    echo '<a class="btn btn-micro hasTooltip cursor-default" title="'.JText::_('COM_MARKETINGROCKET_NOW_SHOWN').'"><span class="fa fa-eye red"></span></a>';
                                                ?>
                                                <?php if($item->is_clicked){
                                                    echo '<a class="btn btn-micro hasTooltip cursor-default" title="'.JText::_('COM_MARKETINGROCKET_CLICKED').'"><span class="fa fa-mouse-pointer green"></span></a>';
                                                }
                                                else 
                                                    echo '<a class="btn btn-micro hasTooltip cursor-default" title="'.JText::_('COM_MARKETINGROCKET_NOT_CLICKED').'"><span class="fa fa-mouse-pointer red"></span></a>';
                                                ?>
                                            </div>
					</td>
                                        <td class="center">
                                            <?php echo JHtml::_('date', $item->cron_date, JText::_('DATE_FORMAT_LC2')); ?>
					</td>
					
				</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
</form>
<?php echo $this->loadTemplate('video_modal'); ?>