<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketViewQueued extends JViewLegacy
{
	protected $state;

	protected $item;

	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
            $this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );

            $this->state	= $this->get('State');
            $this->item		= $this->get('Item');
            $this->form		= $this->get('Form');
            
            JModelLegacy::addIncludePath(JPATH_COMPONENT_SITE.DS.'models');
            $cronModel = JModelLegacy::getInstance('Cron', 'MarketingrocketModel');
            
            $db = JFactory::getDbo();
            $input = JFactory::getApplication()->input;
            
            $query = $cronModel->getQuerySelect();
            $query->clear('where');
            
            $query->where($db->qn('a.id').' = '.$input->getInt('id'));
            $query->where($db->qn('b.published').' = 1');
            
            $db->setQuery($query);
            $row = $db->loadObject();
            require_once JPATH_COMPONENT_ADMINISTRATOR.DS.'tables'.DS.'lead.php';
                
            $leadTable = JTable::getInstance('Lead', 'MarketingrocketTable');
            
            $leadTable->bind(array('id' => $row->lead_id));
                            
            $form_data = $leadTable->getFormData();
            
            $this->subject = $cronModel->preparSubject($row->subject, $row, $form_data);
            
            require_once JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'helpers'.DS.'mr_route.php';
            $url = MRRoute::createFrontRoute('');
            
            // Check for errors.
            if (count($errors = $this->get('Errors')))
            {
                    JError::raiseError(500, implode("\n", $errors));
                    return false;
            }

            $this->addToolbar();
            parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{

		JFactory::getApplication()->input->set('hidemainmenu', true);

		$user		= JFactory::getUser();
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		// Since we don't track these assets at the item level, use the category id.
		$canDo		= MarketingrocketHelper::getActions();

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGE_EMAIL'), '');

		// If not checked out, can save the item.
		if (($canDo->get('core.edit')))
		{
			JToolbarHelper::apply('queued.apply');
			JToolbarHelper::save('queued.save');
		}
		if (empty($this->item->id))
		{
			JToolbarHelper::cancel('queued.cancel');
		}
		else
		{
			JToolbarHelper::cancel('queued.cancel', 'JTOOLBAR_CLOSE');
		}

		JToolbarHelper::divider();
	}
}
