<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.view');


class MarketingrocketViewLogics extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		require_once JPATH_COMPONENT.'/helpers/marketingrocket.php';
		MarketingrocketHelper::addSubmenu('logics');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
		$this->videoHelp = MarketingrocketHelper::videoHelper('logics');
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		

		$state	= $this->get('State');

		$canDo	= MarketingrocketHelper::getActions();
		$user	= JFactory::getUser();
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGER_LOGICS'), '');
		JToolbarHelper::addNew('logic.add');
		if ($canDo->get('core.edit'))
		{
                  
                    JToolbarHelper::editList('logic.edit');
		}

//                JToolbarHelper::custom('tags.delete', 'trash', 'trash', 'JTOOLBAR_DELETE', true);
                
                JToolbarHelper::deleteList('COM_MARKETINGROCKET_ARE_YOUR_SURE_ABOUT_DELETE_THIS_ITEMS' , 'logics.delete');


		if ($canDo->get('core.admin'))
		{
			JToolbarHelper::preferences('com_marketingrocket');
		}


		JHtmlSidebar::setAction('index.php?option=com_marketingrocket&view=logics');





	}

	/**
	 * Returns an array of fields the table can be sorted by
	 *
	 * @return  array  Array containing the field name to sort by as the key and display text as value
	 *
	 * @since   3.0
	 */
	protected function getSortFields()
	{
		return array(
			'a.id' => JText::_('JGRID_HEADING_ID'),
			'title' => JText::_('COM_MARKETINGROCKET_TITLE') 
		);
	}
}
