<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

use Joomla\Registry\Registry;

defined('_JEXEC') or die;

class MarketingrocketViewLogic extends JViewLegacy
{
	protected $state;

	protected $item;

	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
                $this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );
                $this->state	= $this->get('State');
		$this->item		= $this->get('Item');
		$this->form		= $this->get('Form');
                
                $actionModel = JModelLegacy::getInstance('Action', 'MarketingrocketModel');
                $this->items = $actionModel->getItems(JFactory::getApplication()->input->getInt('id', 0), 'tag_action');
                $this->tagsList = $actionModel->getTagsList();
                
                $obj = array();
                
                $obj['id'] = null;
                $obj['condition_type'] = 'any';
                $obj['tags'] = '[]';
                $obj['action'] = 'add_responder';
                $obj['responder_type'] = 'default';
                $obj['api_id'] = 0;
                $obj['target'] = 0;
                
                $this->items[] = $obj;
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
                
                $campaignModel = JModelLegacy::getInstance('Campaigns', 'MarketingrocketModel');
                
                $this->campaignsList = $campaignModel->getCampaignList();
                
                $this->landingList = $campaignModel->getLandingsList();
                
                $this->defResponderList = $campaignModel->getRespondersList();
                
               
                
                $this->responderApiList = $actionModel->getResponderApiList();
                
                $this->campaign_id = JFactory::getApplication()->input->getInt('campaing_id');
                
                $this->type = 'tag_action';
                
                 $this->document->addStyleSheet (JURI::root(true).'/components/com_marketingrocket/assets/css/jquery-ui-1.10.4.custom.min.css' );
                $this->document->addScript ( JURI::root(true) . '/components/com_marketingrocket/assets/js/jquery-ui-1.10.4.custom.min.js', "text/javascript" , true );
                
                

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
                JFactory::getApplication()->input->set('hidemainmenu', true);
                
		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGE_LOGIC'), '');

		// If not checked out, can save the item.
                JToolbarHelper::apply('logic.apply');
                JToolbarHelper::save('logic.save');
                
                JToolbarHelper::cancel('logic.cancel', 'JTOOLBAR_CLOSE');

		JToolbarHelper::divider();

	}
}
