<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.view');


class MarketingrocketViewLeadtags extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
                $this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
                
                MarketingrocketHelper::addSubmenu('');
                

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
                $this->videoHelp = MarketingrocketHelper::videoHelper('');
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGE_LEAD_TAGS'), '');
		JToolbarHelper::addNew('leadtag.add');
                JToolbarHelper::editList('leadtag.edit');
                
                JToolbarHelper::custom('leadtags.delete', 'trash', 'trash', 'JTOOLBAR_DELETE', true);


                JToolbarHelper::preferences('com_marketingrocket');


		JHtmlSidebar::setAction('index.php?option=com_marketingrocket&view=leadtags');
                
                





	}

	/**
	 * Returns an array of fields the table can be sorted by
	 *
	 * @return  array  Array containing the field name to sort by as the key and display text as value
	 *
	 * @since   3.0
	 */
	protected function getSortFields()
	{
		return array(
			'a.id' => JText::_('JGRID_HEADING_ID'),
		);
	}
}
