<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.view');


class MarketingrocketViewLeads extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );
		
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
        $this->total = $this->get('TotalUnfiltered');
        $this->totalFiltered = $this->get('Total');
                
                $this->filterForm    = $this->get('FilterForm');
                
                $this->bulkForm = $this->get('BulkForm');
                
                $this->exportFields = $this->get('AllFields');
		
		$this->leadTags = array();
		$model = $this->getModel();
		foreach ($this->items as $key => $item){
			$tags = $model->getTags($item->id);
			$rowTags = array();
			foreach ($tags as $tag){
				$rowTags[] = $tag->id;
			}
			$this->leadTags[$item->id] = $rowTags;
			
		}
		
		$this->allTags = $model->getAllTags();
		$this->allStatuses = $model->getAllStatuses();
		MarketingrocketHelper::addSubmenu('leads');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();
                if(JFactory::getApplication()->input->getWord('tmpl','')!='component')
                    $this->sidebar = JHtmlSidebar::render();
		$this->videoHelp = MarketingrocketHelper::videoHelper('leads');
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
{
		

//		$state	= $this->get('State');

		$canDo	= MarketingrocketHelper::getActions();
//		$user	= JFactory::getUser();
		// Get the toolbar object instance
//		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGER_LEADS'), '');
// 		JToolBarHelper::custom('landings.newlanding', 'new icon-white', 'icon-new icon-white', 'New', false);
		JToolbarHelper::addNew('lead.add');
		if ($canDo->get('core.edit'))
		{
			JToolbarHelper::editList('lead.edit');
			
			JToolbarHelper::publish('leads.publish', 'JTOOLBAR_PUBLISH', true);
			JToolbarHelper::unpublish('leads.unpublish', 'JTOOLBAR_UNPUBLISH', true);
			
			JToolbarHelper::archiveList('leads.archive');
		}

			JToolbarHelper::deleteList('COM_MARKETINGROCKET_ARE_YOUR_SURE_ABOUT_DELETE_THIS_ITEMS' , 'leads.delete');


		if ($canDo->get('core.admin'))
		{
			JToolbarHelper::preferences('com_marketingrocket');
		}
                

        JToolBarHelper::custom('lead.batch', 'checkbox-partial', 'icon', JText::_('JTOOLBAR_BATCH'), false);

        JToolBarHelper::custom('leads.import', 'download', 'icon', JText::_('COM_MARKETINGROCKET_IMPORT'), false);

        JToolBarHelper::custom('leads.exportpop', 'upload', 'icon', JText::_('COM_MARKETINGROCKET_EXPORT'), false);

        JToolBarHelper::custom('leads.sendemail', ' fa fa-envelope-o', 'fa', JText::_('COM_MARKETINGROCKET_SEND_EMAIL'), true);


		JHtmlSidebar::setAction('index.php?option=com_marketingrocket&view=leads');





	}
}
