<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketViewLead extends JViewLegacy
{
	protected $state;

	protected $item;

	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{

		$this->state	= $this->get('State');
		
		
		
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		if($this->getLayout() == 'subsribes')
		{
			JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGE_LEAD_SUBSCRIBTION'), '');
			JToolbarHelper::cancel('lead.cancel', 'JTOOLBAR_CLOSE');
                        
                        $this->item		= $this->get('Item');
			$this->crons = $this->get('LeadCrons');
			$this->campaigns = $this->get('LeadCampaign');
		}
                else if($this->getLayout() == 'import'){
                        JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_IMPORT'), '');
                        
                        JToolBarHelper::custom('lead.perview', 'fa fa fa-eye ', 'fa', 'COM_MARKETINGROCKET_UPLOAD_AND_PREVIEW', false);
                        
			JToolbarHelper::cancel('lead.cancel', 'JTOOLBAR_CLOSE');
                        
                         $this->form		= $this->get('ImportForm');
                }
                else if($this->getLayout() == 'preview'){
                        JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_IMPORT'), '');
                        
                        JToolBarHelper::custom('lead.import', 'fa fa fa-download ', 'fa', 'COM_MARKETINGROCKET_IMPORT', false);
                        
			JToolbarHelper::cancel('leads.import', 'JTOOLBAR_CLOSE');
                        
                        $this->form		= $this->get('ImportForm');
                }
		else {
                    $model = $this->getModel();
                    $id = $model->getState($model->getName() . '.id');
                    MarketingrocketHelper::calculateWarmMetter($id);
                    
                    $this->item		= $this->get('Item');
                    
                    if($this->item->recieve_email == '0'){
                        JFactory::getApplication()->enqueueMessage(JText::_('COM_MARKETINGROCKET_NOT_RECIEVING'), 'warning');
                    }
                    
                    $this->form		= $this->get('Form');
                    
                    $this->formData = $this->get('FormData');
                    $document = JFactory::getDocument ();
                    $document->addScript ( JURI::base() . '/components/com_marketingrocket/assets/js/highcharts-custom.js', "text/javascript" , true );
                    
                    
//                    $this->tags = $this->get('LeadTags');
//                    $this->statuses = $this->get('LeadStatuses');
                    
			$this->addToolbar();
		}
		
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{

		JFactory::getApplication()->input->set('hidemainmenu', true);

		// Since we don't track these assets at the item level, use the category id.
		$canDo		= MarketingrocketHelper::getActions();

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGE_LEAD'), '');

		// If not checked out, can save the item.
		if (($canDo->get('core.edit')))
		{
			JToolbarHelper::apply('lead.apply');
			JToolbarHelper::save('lead.save');
		}
			JToolbarHelper::save2new('lead.save2new');

		if (empty($this->item->id))
		{
			JToolbarHelper::cancel('lead.cancel');
		}
		else
		{
			JToolbarHelper::cancel('lead.cancel', 'JTOOLBAR_CLOSE');
		}

		JToolbarHelper::divider();
	}
}
