<?php   
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined ( '_JEXEC' ) or die ();

JHtml::addIncludePath ( JPATH_COMPONENT . '/helpers/html' );
JHtml::_ ( 'behavior.tooltip' );
JHtml::_ ( 'behavior.formvalidation' );
JHtml::_ ( 'formbehavior.chosen', 'select' );

?>
<script type="text/javascript">
	Joomla.submitbutton = function(task)
	{
            if (task == 'lead.cancel' || document.formvalidator.isValid(document.id('adminForm')))
		{
                    Joomla.submitform(task, document.getElementById('adminForm'));
                }
	}
}
</script>
<form
        enctype="multipart/form-data" 
	action="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=lead&layout=preview'); ?>"
	method="post" name="adminForm" id="adminForm"
	class="form-validate form-horizontal">

        <input type="hidden" name="task" value="" />
        <?php echo JHtml::_('form.token'); ?>
    
</form>
<h3>Preview :</h3>
<?php 

$app = JFactory::getApplication();

$headrs = $app->getUserState('com_marketingrocket.import.header', null);
$leadsData = $app->getUserState('com_marketingrocket.import.leadslist', null);

if(empty($leadsData) || empty($headrs)){
    $app->enqueueMessage('File Is Empty', 'Error');
    $app->redirect(
        JRoute::_(
                'index.php?option=com_marketingrocket&view=lead&layout=import', false
        )
    );
}
?>

<table class="table table-bordered table-striped">
    <thead>
        <tr>
            <th>#</th>
            <?php
            foreach ($headrs as $header){
                echo '<th>'. ucwords($header).'</th>';
            }
            ?>
        </tr>
    </thead>
    <tbody>
        <?php
        $i = 0;
        foreach ($leadsData as $row){
            if($i > 50){
              echo '<tr><td colspan="'.(count($headrs)+1).'">'.(count($leadsData)-$i).' more ... </td></tr>';
              break;
            }
            echo '<tr>';
            echo '<td>'.($i+1).'</td>';
            foreach ($headrs as $header){
                echo '<td>'. $row[$header].'</td>';
            }
            echo '</tr>';
            $i++;
            
        }
        ?>
    </tbody>
</table>