<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined ( '_JEXEC' ) or die ();

JHtml::addIncludePath ( JPATH_COMPONENT . '/helpers/html' );
JHtml::_ ( 'behavior.tooltip' );
JHtml::_ ( 'behavior.formvalidation' );
JHtml::_ ( 'formbehavior.chosen', 'select' );

?>
<script type="text/javascript">
	Joomla.submitbutton = function(task)
	{
		if (task == 'lead.cancel' || document.formvalidator.isValid(document.id('responder-form')))
		{

			Joomla.submitform(task, document.getElementById('responder-form'));
		}
	}
</script>

<form
	action="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=lead&layout=edit&id='.(int) $this->item->id); ?>"
	method="post" name="adminForm" id="responder-form"
	class="form-validate">
	<div class="row-fluid">
		<div class="span8 form-horizontal">

			<fieldset>
				<ul class="nav nav-tabs">
					<li class="active"><a href="#details" data-toggle="tab"><?php echo empty($this->item->id) ? JText::_('COM_MARKETINGROCKET_NEW') : JText::sprintf('COM_MARKETINGROCKET_EDIT', $this->item->id); ?></a></li>
					<li><a href="#publishing" data-toggle="tab"><?php echo JText::_('JGLOBAL_FIELDSET_PUBLISHING');?></a></li>
			<?php
			$fieldSets = $this->form->getFieldsets ( 'params' );
			foreach ( $fieldSets as $name => $fieldSet ) :
				?>
			<li><a href="#params-<?php echo $name;?>" data-toggle="tab"><?php echo JText::_($fieldSet->label);?></a></li>
			<?php endforeach; ?>

		</ul>
				<div class="tab-content">
					<div class="tab-pane active" id="details">
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('first_name'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('first_name'); ?></div>
						</div>



						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('email'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('email'); ?></div>
						</div>
                                            
                                                <div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('lead_tags'); ?></div>
							<div class="controls">
                                                            <?php echo $this->form->getInput('lead_tags'); ?>
                                                            <a id="" class="btn add_new_tag"><?php echo JText::_('COM_MARKETINGROCKET_ADD_NEW') ?></a>
                                                        </div>
						</div>
                                                <div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('lead_statuses'); ?></div>
							<div class="controls">
                                                            <?php echo $this->form->getInput('lead_statuses'); ?>
                                                            <a id="" class="btn add_new_status"><?php echo JText::_('COM_MARKETINGROCKET_ADD_NEW') ?></a>
                                                        </div>
						</div>
                                               
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('note'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('note'); ?></div>
						</div>
                                            
                                                <div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('user_id'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('user_id'); ?></div>
						</div>
                                                <div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('blacklist_email'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('blacklist_email'); ?></div>
						</div>
						</div>

				<div class="tab-pane" id="publishing">

					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('id'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('id'); ?></div>
					</div>

					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('published'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('published'); ?></div>
					</div>

					

					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('created_by'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('created_by'); ?></div>
					</div>

					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('created'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('created'); ?></div>
					</div>

					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('modified_by'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('modified_by'); ?></div>
					</div>
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('modified'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('modified'); ?></div>
					</div>

				</div>


				<input type="hidden" name="task" value="" />
                                <div id="token_holder">
                                    <?php echo JHtml::_('form.token'); ?>
                                </div>
                        </div>
                        </fieldset>
                </div>
                <div class="span4">
                    <div id="warmth_metter"></div>
                    <div class="text-center">
                        <div class="btn-group">
                            <a class="btn btn-warning" id="recalculate"><?php echo JText::_('COM_MARKETINGROCKET_WM_RECALCULATE') ?></a>
                            <a class="btn btn-danger" id="reset"><?php echo JText::_('COM_MARKETINGROCKET_WM_RESET') ?></a>
                        </div>
                    </div>
                </div>
        </div>
        <div class="row-fluid">
                        
						<div class="control-group well">
						<h2>Form Information</h2>
						
						<?php 
						if(!empty($this->formData)){
							$i = 0;
                                                        $hasField = false;
							foreach ($this->formData as $fkey => $formFilled):
                                                            if(!empty($formFilled->MR_submited_date)){
                                                                $date =  JHtml::_('date', $formFilled->MR_submited_date, JText::_('DATE_FORMAT_LC2'));
                                                                echo '<div class="well"><h4>On : '.$formFilled->title.' At '.$date.'</h4><table class="table table-striped form-data-table">';
                                                            }
                                                            else {
                                                                echo '<div class="well"><h4>'.JText::_('COM_MARKETINGROCKET_CUSTOM_FIELDS').'</h4><table class="table table-striped form-data-table">';
                                                            }
                                                            $i++;
                                                            $j = -1;
                                                            foreach ($formFilled as $key => $val){
                                                                    $j++;
                                                                    if(in_array($key, array('landing_id', 'title', 'MR_form_name', 'MR_submited_date', 'ids')))
                                                                        continue;
                                                                    $hasField = true;
//                                                                    $title = str_replace('_', ' ', $key);
//                                                                    $title= ucwords($title);
                                                                    
                                                                    $title = $key;
                                                                            //$val = str_replace('_', ' ', $val);
                                                                    $val= ucwords($val);
                                                                    echo '<tr>'
                                                                            . '<td width="40%" data-id="'.@$formFilled->ids[$j].'">'.$title.' </td>'
                                                                            . '<td width="40%" data-id="'.@$formFilled->ids[$j].'"> '.$val.'</td>'
                                                                            . '<td><input name="row-id" value="'.@$formFilled->ids[$j].'" type="hidden" />'
                                                                                . '<div class="btn-group">'
                                                                                    . '<a class="btn btn-primary edit-row hasTooltip" title="'.JText::_('COM_MARKETINGROCKET_EDIT').'"><i class="icon-apply"></i></a>'
                                                                                    . '<a class="btn btn-danger remove-row hasTooltip" title="'.JText::_('COM_MARKETINGROCKET_DELETE').'"><i class="icon-delete"></i></a>'
                                                                                . '</div>'
                                                                                . '<div class="btn-group">'
                                                                                    . '<a class="btn btn-success save-row hide hasTooltip" title="'.JText::_('COM_MARKETINGROCKET_SAVE').'"><i class="icon-save"></i></a>'
                                                                                    . '<a class="btn btn-inverse undo-row hide hasTooltip" title="'.JText::_('COM_MARKETINGROCKET_CANCEL').'"><i class="fa fa-undo"></i></a>'
                                                                                . '</div>'
                                                                            . '</td>'
                                                                      . '</tr>';
                                                            }
                                                            if($hasField == false && !isset($this->formData[$fkey+1])){
                                                                echo '<tr>'
                                                                            . '<td width="40%" data-id="0"></td>'
                                                                            . '<td width="40%" data-id="0"></td>'
                                                                            . '<td><input name="row-id" value="0" type="hidden" />'
                                                                                . '<div class="btn-group">'
                                                                                    . '<a class="btn btn-primary edit-row hasTooltip" title="'.JText::_('COM_MARKETINGROCKET_EDIT').'"><i class="icon-apply"></i></a>'
                                                                                    . '<a class="btn btn-danger remove-row hasTooltip" title="'.JText::_('COM_MARKETINGROCKET_DELETE').'"><i class="icon-delete"></i></a>'
                                                                                . '</div>'
                                                                                . '<div class="btn-group">'
                                                                                    . '<a class="btn btn-success save-row hide hasTooltip" title="'.JText::_('COM_MARKETINGROCKET_SAVE').'"><i class="icon-save"></i></a>'
                                                                                    . '<a class="btn btn-inverse undo-row hide hasTooltip" title="'.JText::_('COM_MARKETINGROCKET_CANCEL').'"><i class="fa fa-undo"></i></a>'
                                                                                . '</div>'
                                                                            . '</td>'
                                                                      . '</tr>';
                                                            }
                                                            echo '</table></div>';
							endforeach; ?>
                                                <a id="add_row" class="btn btn-primary"><i class="fa fa-plus"></i></a>
						<?php }
						?>
					</div>
                                        <h3><?php echo JText::_('COM_MARKETINGROCKET_LOGS') ?></h3>
                                        <table class="table table-striped" id="log-holder">
                                            <thead>
                                                <tr>
                                                    <th>
                                                        <?php echo JText::_('COM_MARKETINGROCKET_TIME') ?>
                                                    </th>
                                                    <th>
                                                        <?php echo JText::_('COM_MARKETINGROCKET_LOG_TYPE') ?>
                                                    </th>
                                                    <th>
                                                        <?php echo JText::_('COM_MARKETINGROCKET_LOG_STATUS') ?>
                                                    </th>
                                                    <th>
                                                        <?php echo JText::_('COM_MARKETINGROCKET_LOG_SUBJECT') ?>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                        <div class="row-fluid">
                                            <a id="show-more" class="btn btn-block btn-large btn-primary">
                                                <?php echo JText::_('COM_MARKETINGROCKET_LOAD_MORE') ?>
                                            </a>
                                            <a id="btn-loading-holder" class="btn btn-block btn-large btn-primary btn-disabled" style="display: none">
                                                <div class="spinner ">
                                                    <div class="rect1"></div>
                                                    <div class="rect2"></div>
                                                    <div class="rect3"></div>
                                                    <div class="rect4"></div>
                                                    <div class="rect5"></div>
                                                </div>
                                            </a>
                                        </div>
				
		
		
		</div>
</form>
<div class="modal hide fade" id="MR-IFRAME-MODAL" style="width: 800px;margin-left: 0px; left: 19%;">
        <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h3></h3>
        </div>
        <div class="modal-body main sbox-content-iframe">
                <iframe width="800px" height="400px" frameborder="0" src="">

                </iframe>
        </div>

        <div class="modal-footer">
                <a href="#" class="btn" data-dismiss="modal">Close</a> 
        </div>
</div>
<script>
    var leadId = <?php echo JFactory::getApplication()->input->getInt('id') ?>;
    var clone = jQuery('.well:last').find('tr:last').clone();
    var page = 0;
    jQuery(document).ready(function($){
        $('.add_new_tag').click(function(){
            $('#MR-IFRAME-MODAL').find('h3:first').text('Add New Tag');
            $('#MR-IFRAME-MODAL').modal('show')
            $('#MR-IFRAME-MODAL').find('iframe').attr('src', 'index.php?option=com_marketingrocket&view=tag&layout=edit&tmpl=component');
            activeIframe = 'tag';
        });
        
        $('.add_new_status').click(function(){
            $('#MR-IFRAME-MODAL').find('h3:first').text('Add New Status');
            $('#MR-IFRAME-MODAL').modal('show')
            $('#MR-IFRAME-MODAL').find('iframe').attr('src', 'index.php?option=com_marketingrocket&view=status&layout=edit&tmpl=component');
            activeIframe = 'status';
        });
        
        $('#MR-IFRAME-MODAL').on('show', function(){
            if($(window).width() < 800){
                $(this).attr('style', '').show();
            }
        });
        
        $('#MR-IFRAME-MODAL').on('hide', function (){
            if(activeIframe == 'tag')
                reloadSelectBox("index.php?option=com_marketingrocket&view=tags&task=tags.getlist", $('#jform_lead_tags'));
            if(activeIframe == 'status')
                reloadSelectBox("index.php?option=com_marketingrocket&task=statuses.getlist", $('#jform_lead_statuses'));
        });
        
        $('.edit-row').live('click', function(){
            var parentTr = $(this).parents('tr:first');
            parentTr.find('.btn').toggleClass('hide');
            
            var fieldName = $.trim(parentTr.find('td:first').text());
            var fieldValue = $.trim(parentTr.find('td').eq(1).text());
            
            parentTr.find('td:first').text('');
            parentTr.find('td').eq(1).text('');
            
            var input = $('<input></input>');
            input.attr('type', 'text').attr('required', 'true').attr('name', 'field_name').val(fieldName).data('def', fieldName).appendTo(parentTr.find('td:first'));
            var input = $('<input></input>');
            input.attr('type', 'text').attr('required', 'true').attr('name', 'field_value').val(fieldValue).data('def', fieldValue).appendTo(parentTr.find('td').eq(1));
        });
        $('.save-row').live('click', function(){
            var parentTr = $(this).parents('tr:first');
            var data = {lead_id : leadId};
            var canSubmit = true;
            parentTr.find('input').each(function(){
                if($(this).attr('required') && $(this).is(':valid') === false){
                    canSubmit = false;
                    $(this).focus();
                    return false;
                }
                data[$(this).attr('name')] = $(this).val();
            });
            if(canSubmit == false){
                return true;
            }
            
            var token = $('#token_holder').find('input').attr('name');
            data[token] = 1;
            $.ajax({
                url: 'index.php?option=com_marketingrocket&task=lead.saveformdata&rand='+Date.now(),
                data : data,
                dataType : 'json',
                type : 'post'
            }).done(function(res){
               parentTr.find('[name="row-id"]').val(res.data) 
            });
            
            parentTr.find('input[type="text"]').each(function(){
              $(this).parent().text($(this).val());
            })
            parentTr.find('.btn').toggleClass('hide');
        });
        $('.remove-row').live('click', function(){
            var b = confirm('<?php echo JText::_('COM_MARKETINGROCKET_LOGIC_CONFIRM_DELETE') ?>');
            if(!b)
                return false;
            
            var parentTr = $(this).parents('tr:first');
            
            var token = $('#token_holder').find('input').attr('name');
            data = {id : parentTr.find('[name="row-id"]').val()};
            data[token] = 1;
            $.ajax({
                url: 'index.php?option=com_marketingrocket&task=lead.deleteformdata&rand='+Date.now(),
                data : data,
                dataType : 'json',
                type : 'post'
            });
            parentTr.remove();
        });
        $('.undo-row').live('click', function(){
            var parentTr = $(this).parents('tr:first');
             parentTr.find('input[type="text"]').each(function(){
              $(this).parent().text($(this).data('def'));
            })
            parentTr.find('.btn').toggleClass('hide');
        });
        $('#add_row').click(function(){
            var c = clone.clone();
            c.find('[name="row-id"]').val('0');
            c.find('td:first').text('');
            c.find('td').eq(1).text('');
            c.insertAfter($('.form-data-table:last').find('tr:last'));
            c.find('.edit-row').click();
        })
        $('#show-more').click(function(){
            $(this).hide();
            $(this).next().show();
            
            $.ajax({
                url: 'index.php?option=com_marketingrocket&task=logs.getlist&lead='+leadId+'&page='+page+'&rand='+Date.now(),
                dataType : 'json',
            }).done(function(res){
                page++;
                $(res.data).each(function(){
                    var tr = $('<tr></tr>');
                    var td = $('<td></td>');
                    td.text(this.time).appendTo(tr);
                    var td = $('<td></td>');
                    var className = '';
                    switch(this.object){
                        case 'responder' :
                            className = 'label-important';
                            break;
                        case 'landing' :
                            className = 'label-warning';
                            break;
                        case 'form' :
                            className = 'label-info';
                            break;
                        case 'payment' :
                            className = 'label-success';
                            break;
                        case 'tag' :
                            className = 'label-inverse';
                            break;
                    }
                    var span = $('<span></span>');
                    span.addClass('label '+className).text(this.object).appendTo(td);
                    td.appendTo(tr);
                    
                    var td = $('<td></td>');
                    td.text(this.type).appendTo(tr);
                    
                    var td = $('<td></td>');
                    td.text(this.log).appendTo(tr);
                    
                     $('#log-holder tbody').append(tr);
                })
                $('#btn-loading-holder').hide();
                if(res.data.length == 50)
                    $('#show-more').show();
                
            });
            
        }).click();
       
    });
var reloadSelectBox = function(url, el){
    var $ = jQuery;
    $.ajax({
            url: url+'&rand='+Date.now()
    }).done(function(res){
            var json = JSON.parse(res);

            if(json.error){
                    alert("Error Code :"+json.error);
                    return;
            }
            if(typeOf(json) == 'object'){
                if(json.data){
                    json = json.data;
                    var id = el.attr('id');
//                    alert($('#'+id+'_table').find('tbody tr').length)
                    $('#'+id+'_table').find('tbody tr').each(function(){
                        var select = $(this).find('select:last');
                        for(var i = 0; i < json.length;i++){
                            if(select.find('[value="'+json[i].id+'"]').length > 0)
                                continue;
                            var option = document.createElement('option');
                            $(option).val(json[i].id).html(json[i].title);
                            select.append(option);
                        }
                        select.chosen("destroy");
                        select.chosen({"disable_search_threshold":10,"allow_single_deselect":true,"placeholder_text_multiple":"Select some options","placeholder_text_single":"Select an option","no_results_text":"No results match"});
                    });
                }
            }
            var r = el.data('JRepeatable');
            var b = $(r.template);
            
            var select = b.find('select:last');
            for(var i = 0; i < json.length;i++){
                if(select.find('[value="'+json[i].id+'"]').length > 0)
                    continue;
                var option = document.createElement('option');
                $(option).val(json[i].id).html(json[i].title);
                select.append(option);
            }
            
            r.template = b.prop('outerHTML');
            el.data('JRepeatable', r);
            


        });
}
 jQuery(function ($) {
    $('#recalculate').click(function(){
        var b = confirm('<?php echo JText::_('COM_MARKETINGROCKET_RECALCULATE_ASK') ?>');
        if(b){
            $('[name="task"]').val('lead.recalculate');
            $('#responder-form').submit();
        }
    });
    $('#reset').click(function(){
        var b = confirm('<?php echo JText::_('COM_MARKETINGROCKET_RESET_ASK') ?>');
        if(b){
            $('[name="task"]').val('lead.reset');
            $('#responder-form').submit();
        }
    })
    $('#warmth_metter').highcharts({

        chart: {
            type: 'gauge',
            plotBackgroundColor: null,
            plotBackgroundImage: null,
            plotBorderWidth: 0,
            plotShadow: false,
            backgroundColor: null
        },
        credits: {
            enabled: false
        },
        title: {
            text: '<?php echo JText::plural('COM_MARKETINGROCKET_WARMTH_METER', JText::_(MarketingrocketHelper::getLabelOfWarmth($this->item->w_metter), true),array('jsSafe' => true)) ?>'
        },
        pane: {
            startAngle: -130,
            endAngle: 130,
            size : 250,
            background: [
            {
                backgroundColor: '#fff',
                borderWidth: 3,
                borderColor :  '#000'
            }]
        },

        // the value axis
        yAxis: {
            min: 0,
            max: 100,

            labels: {
                step: 1,
                rotation: 'auto'
            },
            plotBands: [{
                from: 0,
                to: 75,
                color: '#fff' 
            }, {
                from: 80,
                to: 90,
                color: '#F89406' // yellow
            }, {
                from: 90,
                to: 100,
                color: '#BF3831' // red
            }]
        },
        exporting: {
                 enabled: false
        },
        series: [{
            name: 'Value',
            data: [<?php echo  min(array($this->item->w_metter, 100)) ?>]
        }]

    },
    // Add some life
    function (chart) {
        if (!chart.renderer.forExport) {
            setInterval(function () {
                var point = chart.series[0].points[0],
                    newVal,
                    inc = Math.round((Math.random() - 0.5) * 20);

                newVal = point.y + inc;
                if (newVal < 0 || newVal > 200) {
                    newVal = point.y - inc;
                }

                point.update(newVal);

            }, 3000);
        }
    });
});   
</script>
