<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.view');


class MarketingrocketViewLandingtemplate extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->types = $this->get('Types');
		

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		
		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		

		$state	= $this->get('State');

		$canDo	= MarketingrocketHelper::getActions();
		$user	= JFactory::getUser();
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_CHOOSE_TEMPLATE'), '');


		if ($canDo->get('core.admin'))
		{
			JToolbarHelper::preferences('com_marketingrocket');
		}
		

		JHtmlSidebar::setAction('index.php?option=com_marketingrocket&view=dashboard');

// 		JHtmlSidebar::addFilter(
// 			JText::_('JOPTION_SELECT_PUBLISHED'),
// 			'filter_state',
// 			JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.state'), true)
// 		);
                
                if(is_writable(JPATH_SITE.'/tmp') && extension_loaded('zip'))
                    JToolBarHelper::custom('landing.import', 'fa fa fa-cloud-download', 'fa-5', JText::_('COM_MARKETINGROCKET_IMPORT'), false);




	}

	/**
	 * Returns an array of fields the table can be sorted by
	 *
	 * @return  array  Array containing the field name to sort by as the key and display text as value
	 *
	 * @since   3.0
	 */
	protected function getSortFields()
	{
		return array(
			'a.id' => JText::_('JGRID_HEADING_ID'),
			'category_title' => JText::_('COM_MARKETINGROCKET_CATEGORIES') 
		);
	}
}
