<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
$j = 0;
$thPath = explode('/', 'components/com_marketingrocket/assets/th');
$canDelete = true;
if(JFactory::getApplication()->input->getWord('tmpl','') == 'component')
      $canDelete = false;
if(isset($this->canDelete) && $this->canDelete === false)
    $canDelete = false;
?>

<label><?php echo JText::_('COM_MARKETINGROCKET_FILTER_BY_CATEGORY') ?></label> 
<select name="" id="categories">
		<option value="0">All</option>
	<?php foreach ($this->types as $type): ?>
		<option value="<?php echo $type ?>" 
                    <?php echo (!empty($this->typeSelected) && $type == $this->typeSelected) ? 'selected="selected"'  : '' ?>
                        >
			<?php echo JText::_($type) ?>
		</option>
	<?php endforeach; ?>
</select>
<br /><br />
<ul class="thumbnails template-container">
    <?php foreach ($this->items as $i => $item) :
        if($j % 3 == 0 && $j > 0){
                echo '</ul><ul class="thumbnails template-container">';
        }
        $j++;
    ?>
    <li class="span4 templates-li" aria-type="<?php echo $item->type ?>">
        <a class="MR-templates-link" data-id="<?php echo $item->id ?>" data-uname="<?php echo $item->unique_name ?>" 
            href="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=landing&layout=edit&template='.(int) $item->id); ?>">
			
            <div class="MR-templates-header">
                <?php echo $item->name;
                if($canDelete && $item->id > 1): ?>
                     <span class="btn btn-mini btn-danger" onclick="deleteItem(<?php echo $item->id ?>);return false; ">&times;</span>
                <?php endif; ?>
            </div>
            <div class="MR-templates-thumb">
                    <?php 
                    if(file_exists(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.implode(DIRECTORY_SEPARATOR, $thPath).DIRECTORY_SEPARATOR.$item->id.'.png')): ?>
                        <img src="<?php echo JURI::base().implode('/', $thPath).'/'.$item->id.'.png';?>" alt="<?php echo $item->id ?>"/>
                    <?php 
                    else : ?>
                         <img src="<?php echo JURI::base() ?>components/com_marketingrocket/assets/images/emails_template/def.png">
                    <?php endif; ?>
                    <div class="MR-templates-caption">
                            <p>
                                    <?php echo $item->desc ?>
                            </p>
                    </div>
                    <span class="select-template-button">
                    <?php echo JText::_('COM_MARKETINGROCKET_SELECT_TEMPLATE') ?>
                    </span>
            </div>
        </a>
    </li>
	
	<?php endforeach; ?>
</ul>
<script type="text/javascript">
	var j = jQuery;
	j('#categories').change(function(){
                j('.thumbnails').find('.span4[aria-type]').hide();
                
                if(j(this).val() == "0")
                    var els = j('.thumbnails').find('.span4');
                else 
                    var els = j('.thumbnails').find('.span4[aria-type="'+j('#categories').val()+'"]');
                
                els.show();
                
                var i = 0;
                var ul = j('<ul class="thumbnails template-container"></ul>');
                ul.insertAfter('.thumbnails:last');
                els.each(function(){
                    if(i%3 == 0){
                        ul = j('<ul class="thumbnails template-container"></ul>');
                        ul.insertAfter('.thumbnails:last');
                    }
                    j(this).appendTo(ul);
                    i++;
                });
                         
	}).change();
</script>