<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.view');


class MarketingrocketViewLandings extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );
		
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$landingModel = JModelLegacy::getInstance('Landing', 'MarketingrocketModel', array('ignore_request' => true));
		$this->menuUrl = $landingModel->getMenuUrl();
		
		MarketingrocketHelper::addSubmenu('landings');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
                
                $this->filterForm    = $this->get('FilterForm');

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
		$this->videoHelp = MarketingrocketHelper::videoHelper('landings');
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
{
		

		$state	= $this->get('State');

		$canDo	= MarketingrocketHelper::getActions();
		$user	= JFactory::getUser();
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGER_LANDINGS'), '');
// 		JToolBarHelper::custom('landings.newlanding', 'new icon-white', 'icon-new icon-white', 'New', false);
		JToolbarHelper::addNew('landing.add');
		if ($canDo->get('core.edit'))
		{
			JToolbarHelper::editList('landing.edit');
			
			JToolbarHelper::publish('landings.publish', 'JTOOLBAR_PUBLISH', true);
			JToolbarHelper::unpublish('landings.unpublish', 'JTOOLBAR_UNPUBLISH', true);
			
			JToolbarHelper::archiveList('landings.archive');
		}

			JToolbarHelper::deleteList('COM_MARKETINGROCKET_ARE_YOUR_SURE_ABOUT_DELETE_THIS_ITEMS' , 'landings.delete');


		if ($canDo->get('core.admin'))
		{
			JToolbarHelper::preferences('com_marketingrocket');
		}


		JHtmlSidebar::setAction('index.php?option=com_marketingrocket&view=landings');
                
                $bar = JToolbar::getInstance('toolbar');
                $bar->appendButton('Confirm', 'COM_MARKETINGROCKET_ARE_YOUR_SURE_ABOUT_RESET_STATICS_OF_THIS_ITEMS', 'refresh', JText::_('COM_MARKETINGROCKET_RESET_STATICS'), 'landings.resetstat', true);





	}
}
