<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
JHtml::_('behavior.framework', true);
JHtml::_('jquery.framework');

class MarketingrocketViewLanding extends JViewLegacy
{
	protected $state;

	protected $item;

	protected $form;
	protected $settingForm;
	protected $menuUrl;
	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->state	= $this->get('State');
		$this->item		= $this->get('Item');
		$this->form		= $this->get('TemplatesForm');
		$this->settingForm = $this->get('Form');
                
                $editorType = JFactory::getApplication()->input->get('editor_type', 'landing');
				$this->editor_type = $editorType;
                if($editorType == 'responder'){
                    $leadsModel = JModelLegacy::getInstance('Leads', 'MarketingrocketModel');

                    $tags = $leadsModel->getAllFields();
                    JLoader::import('joomla.plugin.helper');
                    JPluginHelper::importPlugin('marketingrocket');
                    $dispatcher = JDispatcher::getInstance();
                    $dispatcher->trigger(
                        'onPrepareTagsListInResponder',
                        array(&$tags) );

                    $tags['MR_submited_date'] = 'Form Submit Date';

                    $arr = array_reverse($tags, true);
                    $arr['MR_lead_register_date'] = 'Registration Date';
                    $arr['campaign_name'] = 'Campaign Name';
                    $tags = array_reverse($arr, true);

                    $this->tags = $tags;
                    $this->landingList = $this->get('LandingList');
                
                    if(JFactory::getApplication()->input->getInt('wizard', 0) > 0){
                        $newArray = array('%wizard%' => JText::_('COM_MARKETINGROCKET_INSERT_NEXT_LANDING_IN_WIZARD'));
                        $this->landingList = array_merge($newArray, $this->landingList);
                    }
                }
                
		$this->buttonSettingForm = $this->get('ButtonSettingForm');
                
                $this->iconSettingForm = $this->get('IconSettingForm');
                $this->timerSettingForm = $this->get('TimerSettingForm');
                 $session = JFactory::getSession();
                if($session->has('landing_action')){
                    $session->clear('landing_action');
                }
		
// 		$this->template = $this->get('Template');
// 		$this->template = $this->template['html'];
		$this->menuUrl = $this->get('MenuUrl');
		
		
// 		$this->form->setValue('sep', null, $this->state->params->get('seperator'));
// 		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
                $versionNumber = MarketingrocketHelper::getVersion();
                $this->lastTempId = $this->get('LastTempId');
                
                $this->lastAutoSave = $this->get('LastAutoSave');

		
		
		$document = JFactory::getDocument ();
                
		
// 		$document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/js/colorpicker/css/colorpicker.css' );
		
// 		$document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/style.css' );

                if(empty($this->item->id)){
                    $model = $this->getModel();
                    $array = $model->getFormData();
                    $landingOptions = $this->landingOptions = json_decode($array['page_option']);
                    $this->landing = new stdClass();
                    $this->landing->page_option = $array['page_option'];
                }
                else 
                    $landingOptions = $this->landingOptions = json_decode($this->item->page_option);
                
                if(!empty($landingOptions->load_fonts)){
                    $fontString = '';
                    $sep = '';
                    $fontWeights = implode(',', $landingOptions->font_weights);
                    foreach ($landingOptions->load_fonts as $font){
                        if(strpos($font, 'google-') === false)
                            continue;
                        $font = preg_replace('/\w+-{1}/', '', $font);
                        $font = str_replace(' ', '+', $font);
                        $fontString .= $sep.$font;
                        if ($fontWeights != '') {
                        	$fontString .= ':'.$fontWeights;
                        }
                        $sep = '|';
                        
                    }
                    if(!empty($fontString))
                        $document->addStyleSheet ('https://fonts.googleapis.com/css?family='.$fontString);
                }
                
                
                
		
		
		$document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/form_builder/formbuilder.css' );
		
		$document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/jquery.cleditor.css' );
		
		$document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/magicsuggest-min.css' );
		
		
		$document->addStyleSheet (JURI::root(true).'/components/com_marketingrocket/assets/css/jquery-ui-1.10.4.custom.min.css' );
                
                $document->addStyleSheet (JURI::root(true).'/components/com_marketingrocket/assets/css/animate.css' );
		
		$document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/nanoscroller.css' );
		
		$document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/jquery.colorpicker.css' );
		$document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/css/jquery.classygradient.min.css' );
		
		$document->addScript ( JURI::root(true) . '/components/com_marketingrocket/assets/js/jquery-ui-1.10.4.custom.min.js', "text/javascript" , true );
                $document->addScript ( JURI::root(true) . '/components/com_marketingrocket/assets/js/jquery.ui.touch-punch.min.js', "text/javascript" , true );
		
		$document->addScript ( JURI::base() . '/components/com_marketingrocket/assets/js/jquery.colorpicker.js', "text/javascript" , true );
		$document->addScript (JURI::root(true) . '/media/jui/js/bootstrap.js', "text/javascript" , true );
		$document->addScript (JURI::root(true) . '/media/jui/js/bootstrap-tooltip-extended.min.js', "text/javascript" , true );

		$document->addScript ( JURI::base() . '/components/com_marketingrocket/assets/js/jquery.classygradient.min.js', "text/javascript" , true );

		$document->addScript ('https://www.google.com/recaptcha/api.js?onload=generateReCaptcha&render=explicit', "text/javascript" , true );
		
		
		$document->addScriptVersion ( JURI::base() . '/components/com_marketingrocket/assets/js/landing-setting.js', $versionNumber, "text/javascript" , true );
                if(JComponentHelper::getParams('com_marketingrocket')->get('debug_mode', 'false') == 'false'){
                    $document->addScriptVersion ( JURI::base() . '/components/com_marketingrocket/assets/js/landing.js', $versionNumber, "text/javascript" , true );
                }
                else {
                    $allJs = array('landing.js', 'timer.js', 'spacer.js', 'button.js', 'codebox.js', 'videobox.js', 'icon.js', 'form.js', 'media.js',
                        'card.js', 'loadmodule.js', 'loadposition.js', 'wizard.js', 'pricatetable.js', 'progress.js', 'comment.js', 'video.js', 'label.js');
                    
                    $str = '//'.JFactory::getDate('now', JFactory::getConfig()->get('offset'))->calendar(JText::_('DATE_FORMAT_LC2'), true)." ".PHP_EOL;
                    
                    foreach ($allJs as $js){
                        $document->addScriptVersion ( JURI::base() . '/components/com_marketingrocket/assets/js/landing_modules/'.$js, $versionNumber, "text/javascript" , true );
                        
                        $str .= file_get_contents(JPATH_COMPONENT.DS.'assets'.DS.'js'.DS.'landing_modules'.DS.$js);
                    }
                    
                    file_put_contents(JPATH_COMPONENT.DS.'assets'.DS.'js'.DS.'landing.js', $str);
                    
                }
                
		
                if($editorType == 'responder')
                    $document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/ZeroClipboard/ZeroClipboard.min.js');   
                
		$document->addScriptVersion (JURI::base().'/components/com_marketingrocket/assets/js/form_builder/vendor.js', $versionNumber,"text/javascript" , false );
		$document->addScriptVersion (JURI::root(true).'/media/jui/js/jquery-noconflict.js', $versionNumber,"text/javascript" , false );
		$document->addScriptVersion (JURI::base().'/components/com_marketingrocket/assets/js/form_builder/formbuilder.js', $versionNumber , "text/javascript" , true );
		
//		$document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/jquery.cleditor.min.js' , "text/javascript" , true );
		
		$document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/magicsuggest-min.js' , "text/javascript" , true );
		
		$document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/jquery.nanoscroller/jquery.nanoscroller.min.js' , "text/javascript" , true );
                
                $document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/ckeditor/ckeditor.js' , "text/javascript" , true );
                $document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/ckeditor/adapters/jquery.js' , "text/javascript" , true );
                $document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/toolbatcustombtn.js' , "text/javascript" , true );
                
                $document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/codemirror/lib/codemirror.js' , "text/javascript" , true );
                
                $document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/codemirror/mode/css/css.js' , "text/javascript" , true );
                $document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/codemirror/mode/javascript/javascript.js' , "text/javascript" , true );
                $document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/codemirror/mode/xml/xml.js' , "text/javascript" , true );
                $document->addScript (JURI::base().'/components/com_marketingrocket/assets/js/codemirror/mode/htmlmixed/htmlmixed.js' , "text/javascript" , true );
                
                
                
                
		$document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/js/codemirror/lib/codemirror.css' );
                
                $document->addStyleSheet (JURI::base().'/components/com_marketingrocket/assets/js/codemirror/theme/elegant.css' );
		
		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
		$this->videoHelp = MarketingrocketHelper::videoHelper('landing');
                
                JLoader::import('joomla.plugin.helper');
                JPluginHelper::importPlugin('marketingrocket');
                JPluginHelper::importPlugin('system');
                $dispatcher = JDispatcher::getInstance();
                $dispatcher->trigger('onLandingEditorDisplay', array(&$this) );
                
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);

		$user		= JFactory::getUser();
		// Since we don't track these assets at the item level, use the category id.
		$canDo		= MarketingrocketHelper::getActions();

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGE_LANDING'), '');

		// If not checked out, can save the item.
		if (($canDo->get('core.edit')||(count($user->getAuthorisedCategories('com_marketingrocket', 'core.create')))))
		{
                     $input = JFactory::getApplication()->input;
                    if($input->getInt('wizard', 0) > 0){
			JToolbarHelper::apply('wizard.applylanding');
                    }
                    else {
                        JToolbarHelper::apply('landing.apply');
			JToolbarHelper::save('landing.save');
			JToolbarHelper::save2copy('landing.save2copy');
                    }
		}
		
		
		JToolBarHelper::custom('landing.changetemplate', 'fa fa fa-file-text-o btnfile-text-o', 'fa', JText::_('COM_MARKETINGROCKET_CHANGE_TEMPLATE'), false);
		
                
		JToolBarHelper::custom('landing.mobilepreview', 'fa fa fa-mobile fa-2x btn-mobile', 'fa', '', false);
                JToolBarHelper::custom('landing.tabletpreview', 'fa fa fa-tablet fa-2x btn-tablet', 'fa', '', false);
                JToolBarHelper::custom('landing.savepreview', 'fa fa fa-desktop fa-2x btn-desktop', 'fa', '', false);
		
		if($input->getInt('wizard', 0) == 0){
                    if (empty($this->item->id))
                    {
                        JToolbarHelper::cancel('landing.cancel');
                    }
                    else
                    {
                        JToolbarHelper::cancel('landing.cancel', 'JTOOLBAR_CLOSE');
                    }
                }
                else {
                    JToolbarHelper::cancel('wizard.cancel');
                }
		
		
		
		JToolbarHelper::divider();
		
		JToolBarHelper::custom('landing.showhelpmodal', 'fa fa fa-question-circle btn-question-circle', 'fa', JText::_('COM_MARKETINGROCKET_HELP_AND_SUPPORT'), false);
                if(is_writable(JPATH_SITE.'/tmp') && extension_loaded('zip'))
                    JToolBarHelper::custom('landing.showexport', 'fa fa fa-cloud-upload btn-cloud-upload', 'fa-5', JText::_('COM_MARKETINGROCKET_SAVE_OR_EXPORT'), false);
                
                JToolBarHelper::custom('landing.undomove', 'fa fa fa-undo btn-undo', 'fa-5', JText::_('COM_MARKETINGROCKET_UNDO_MOVE'), false);
	}
}
