<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined ( '_JEXEC' ) or die ();
JHtml::addIncludePath ( JPATH_COMPONENT . '/helpers/html' );
JHtml::_ ( 'behavior.tooltip' );
JHtml::_ ( 'behavior.formvalidation' );
JHtml::_ ( 'formbehavior.chosen', 'select' );

JHtml::_ ( 'behavior.keepalive' );


$app = JFactory::getApplication ();
$urlPatch = JUri::getInstance();

$session = JFactory::getSession();
$redirect = $session->get('MR_redirect', false);

$editorType = JFactory::getApplication()->input->get('editor_type', 'landing');
if(!empty($redirect)){
     $session->set('MR_redirect', false);
     echo '<iframe width="0" height="0" style="border : 0px solid" src="'.$redirect.'"></iframe>';
}


if($app->input->getInt('export', 0) > 0){ 
    
    require_once JPATH_SITE.DS.'components'.DS.'com_marketingrocket'.DS.'helpers'.DS.'mr_route.php';
    $url = MRRoute::createFrontRoute('index.php?option=com_marketingrocket&task=landing.download');
    
    echo '<iframe width="0" height="0" style="border : 0px solid" src="'.$url.'/"></iframe>';
}

$wizardString = '';
if($app->input->getInt('wizard', 0) != 0){
    $wizardString = '&wizard='.$app->input->getInt('wizard', 0);
}

?>
<div id="loading-holder" >
    <i class="fa fa-cog fa-5x fa-spin"></i>
</div>
<div id="auto_save_holder" <?php echo ($editorType != 'landing') ? 'class="hide"' : '' ?>>
    <?php if(!empty($this->lastAutoSave)): 
        
        $time = strtotime($this->lastAutoSave->created);
        $beginOfDay = strtotime("midnight");
        if($time > $beginOfDay){
            $dateString =  JHtml::_('date', $this->lastAutoSave->created, 'H:i:s');
        }
        else {
            $dateString = JHtml::_('date', $this->lastAutoSave->created, JText::_('DATE_FORMAT_LC2'));
        }
    ?>
    <a data-id="<?php echo $this->lastAutoSave->id ?>"><?php echo JText::plural('COM_MARKETINGROCKET_LAST_AUTO_SAVE_ON', $dateString) ?></a>
    <?php endif; ?>
</div>
<div class="flex">
    <div id="side_setting" class="nano">
        <div class="nano-content  form-horizontal">
            <span class="j-toggle-button-wrapper j-toggle-visible" id="j-toggle-button-wrapper">
		<div onclick="app.modal('', 'hide')" type="button" title="" class="j-toggle-sidebar-button hasTooltip" id="j-toggle-sidebar-button" data-original-title="Hide the sidebar">
                    <span class="icon-cancel j-toggle-visible" id="j-toggle-sidebar-icon"></span>
                </div>
            </span>
            <?php echo $this->loadTemplate('button_setting'); ?>
            <?php echo $this->loadTemplate('property'); ?>
             <div id="MR-landing-setting" class="hide">
                 <h3><?php echo JText::_('COM_MARKETINGROCKET_LANDING_SETTING') ?></h3>
        	<form
        		action="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=landing&layout=edit&id='.(int) $this->item->id.$wizardString); ?>"
        		method="post" name="adminForm" id="landing-form"
        		class="modal-body MR-modal-form form-validate form-horizontal" enctype="multipart/form-data">
        		<fieldset>
                        <?php echo JHtml::_('bootstrap.startAccordion', 'myTab', array('active' => 'main_section')); ?>
                                <?php echo JHtml::_('bootstrap.addSlide', 'myTab', JText::_('COM_MARKETINGROCKET_MAIN_SETTING', true), 'main_section'); ?>
                                    <?php foreach ($this->settingForm->getFieldset('main_section') as $field) : ?>
                                        <div class="control-group">
                                            <div class="control-label">
                                                    <?php echo $field->label;
                                                    
                                                    if($field->__get('name') == 'jform[alias]'){
                                                        ?>
                                                
                                                        <label id="jform_alias-lbl_1" 
                                                               for="jform_alias" 
                                                               class="hasTooltip hide" title="" 
                                                               data-placement="bottom" 
                                                               data-original-title="<strong><?php echo JText::_('COM_MARKETINGROCKET_ALIAS_LABEL_SPLIT') ?></strong><br /><?php echo JText::_('COM_MARKETINGROCKET_ALIAS_LABEL_SPLIT_DESC') ?>">
                                                            <?php echo JText::_('COM_MARKETINGROCKET_ALIAS_LABEL_SPLIT') ?>
                                                        </label>
                                                
                                                <?php
                                                    }
                                                    if($field->__get('name') == 'jform[exit_popup_size]') : ?>
                                                        <span class="pull-right" style="margin: 5px;">px</span>
                                                        <input type="text" value="<?php echo $field->__get('value') ?>" class="pull-right span2" name="jform[exit_popup_size]" id="jform_exit_popup_size" value="0" data-boxshaow  />
                                                    <?php endif; ?>
                                            </div>
                                            <div class="controls">
                                                <?php  if($field->__get('name') == 'jform[exit_popup_size]') : ?>
                                                    <div id="jform_exit_popup_size_slider" data-value="<?php echo $field->__get('value') ?>" data-slider data-step="10"  data-max="1100" data-min="150"></div>
                                                <?php else :
                                                    echo $field->input;
                                                endif; ?>
                                                <?php if($field->__get('name') == 'jform[campaign_id]'): ?>
                                                    <a id="add_new_campaign" class="btn"><?php echo JText::_('COM_MARKETINGROCKET_ADD_NEW') ?></a>
                                                <?php 
                                                    elseif($field->__get('name') == 'jform[viewing_tag][]'): ?>
                                                        <a id="add_new_tagview" class="btn"><?php echo JText::_('COM_MARKETINGROCKET_ADD_NEW') ?></a>
                                                    <?php elseif($field->__get('name') == 'jform[alias]'):?>
                                                    <div>
                                                        <select name="" id="jform_alias_select"></select>
                                                    </div>
                                                <?php  endif; ?>

                                            </div>
                                        </div>
                                        <?php if($field->__get('name') == 'jform[meta_desc]'): ?>
                                            <div class="remain-counter"><?php echo  JText::_('COM_MARKETINGROCKET_META_DESC_COUNTER') ?> <span>0</span>/156</div>
                                            <div class="control-group">
                                                    <div class="control-label">
                                                            <label><?php echo JText::_('COM_MARKETINGROCKET_SEARCH_PREVIEW') ?></label>
                                                    </div>
                                                    <div class="controls">
                                                            <div id="MR-seo-preview">
                                                                    <a href="#" class="title"></a><br>
                                                                    <a class="url" href="#"></a>
                                                                    <p style="font-size: 13px; color: #000; line-height: 15px;word-wrap: break-word;" class="desc">
                                                                    </p>
                                                            </div>
                                                    </div>
                                            </div>
                                            <!-- <div class="control-group">
                                                    <a class="btn" id="check_seo"><?php echo  JText::_('COM_MARKETINGROCKET_CHECK_SEO') ?></a>
                                            </div>
                                             -->
                                        <?php elseif($field->__get('name') == 'jform[seo_title]'): ?>
                                            <div class="remain-counter"><?php echo  JText::_('COM_MARKETINGROCKET_TITLE_COUNTER') ?> <span>0</span>/70</div>

                                        <?php endif; ?>
                                    <?php endforeach; ?>
        			<?php echo JHtml::_('bootstrap.endSlide'); ?>
                                <?php echo JHtml::_('bootstrap.addSlide', 'myTab', JText::_('COM_MARKETINGROCKET_FORM_SETTING', true), 'form_setting'); ?>
        			
        				<?php foreach ($this->settingForm->getFieldset('form_setting') as $field) :
        						if($field->__get('name') == 'jform[have_paypal]'):
                                                            echo '<div class="cta_toggle">';
                                                        elseif($field->__get('name') == 'jform[after_pay]'):
                                                            echo '<div id="after_pay_holder">';
        						endif;
        				?>
        						<div class="control-group">
                                                            <div class="control-label">
                                                                <?php echo $field->label; ?>
                                                            </div>
                                                            <div class="controls">
                                                                <?php echo $field->input; 
                                                                 if($field->__get('name') == 'jform[adding_tag][]'): ?>
        								<a id="add_new_tag" class="btn"><?php echo JText::_('COM_MARKETINGROCKET_ADD_NEW') ?></a>
                                                                <?php 
                                                                elseif($field->__get('name') == 'jform[api_id]'): ?>
                                                                        <a id="add_new_api" class="btn"><?php echo JText::_('COM_MARKETINGROCKET_ADD_NEW') ?></a>
                                                                <?php 
                                                                 elseif($field->__get('name') == 'jform[responder_sequence_id][]'): ?>
                                                                        <a id="add_new_sequence" class="btn"><?php echo JText::_('COM_MARKETINGROCKET_ADD_NEW') ?></a>
                                                                <?php 
                                                                 elseif($field->__get('name') == 'jform[to_landing_page]' || $field->__get('name') == 'jform[pay_to_landing_page]'): ?>
                                                                        <a id="" class="btn add_new_landing"><?php echo JText::_('COM_MARKETINGROCKET_ADD_NEW') ?></a>
                                                                <?php
                                                                elseif($field->__get('name') == 'jform[after_filling]'): ?>
                                                                        <a id="logics" class="btn"><?php echo JText::_('COM_MARKETINGROCKET_MORE_ACTIONS') ?></a>
                                                                <?php endif; ?>
                                                            </div>
        						</div>
        					<?php if($field->__get('name') == 'jform[notification_email]' || $field->__get('name') == 'jform[pay_to_landing_page]'): ?>
        						</div>
        					<?php endif; ?>
        				<?php endforeach; ?>
        			<?php echo JHtml::_('bootstrap.endSlide'); ?>
                                <?php echo JHtml::_('bootstrap.addSlide', 'myTab', JText::_('COM_MARKETINGROCKET_FORM_BUILDER', true), 'form_builder'); ?>
        				<?php foreach ($this->settingForm->getFieldset('form_builder') as $field) : ?>
        						<div class="control-group">
                                                            <div class="control-label">
                                                                    <?php echo $field->label; ?>
                                                            </div>
                                                            <div class="controls">
                                                                <?php echo $field->input; ?>
                                                            </div>
        						</div>
        				<?php endforeach; ?>
                                     <div class="control-group">
                                        <a class="btn btn-success" id="show-form-builder" >
                                            <?php echo JText::_('COM_MARKETINGROCKET_SHOW_FORM_BUILDER') ?>
                                        </a>
                                     </div>
        			<?php echo JHtml::_('bootstrap.endSlide'); ?>
                                <?php echo JHtml::_('bootstrap.addSlide', 'myTab', JText::_('COM_MARKETINGROCKET_ADDITIONAL_CSS_JS', true), 'inlines'); ?>
        				<?php foreach ($this->settingForm->getFieldset('inlines') as $field) : ?>
                                            <div class="control-group">
                                                    <div class="control-label">
                                                            <?php echo $field->label; ?>
                                                    <?php if($field->__get('name') == 'jform[css]'){ ?>
                                                        <div class="clearfix"></div>

                                                         <a class="btn btn-success" id="apply_css"><?php echo JText::_('COM_MARKETINGROCKET_APPLY_CSS') ?></a>
                                                         <br /><br />
                                                    <?php } ?>
                                                    </div>
                                                    <div class="controls">
                                                            <?php echo $field->input; ?>
                                                    </div>
                                            </div>
        				<?php endforeach; ?>
        			<?php echo JHtml::_('bootstrap.endSlide'); ?>
        		 <?php echo JHtml::_('bootstrap.endAccordion'); ?>
        		</fieldset>
                        <?php echo $this->settingForm->getInput('modal_body'); ?>
                        <?php echo $this->settingForm->getInput('modal_editor'); ?>
                    
                        <?php echo $this->settingForm->getInput('exit_popup_modal'); ?>
                        <?php echo $this->settingForm->getInput('exit_popup_modal_editor'); ?>
        		<input type="hidden" name="task" value="" />
                        
                        <?php
                            $input = JFactory::getApplication()->input;
                            if($input->getInt('wizard', 0) > 0){ 
                                echo '<input type="hidden" name="wizard" value="'.$input->getInt('wizard').'" />';
                                echo '<input type="hidden" name="template" value="'.$input->getInt('template').'" />';
                            }
                        ?>
                        <div id="token_holder">
                            <?php echo JHtml::_('form.token'); ?>
                        </div>
                        
                        
                         <div class="modal hide fade" id="MR-EXPORT_MODAL" data-backdrop="static">
                                <div class="modal-body">
                                    <?php foreach ($this->settingForm->getFieldset('template') as $field) : ?>
                                            <div class="control-group">
                                                    <div class="control-label">
                                                            <?php echo $field->label; ?>
                                                    </div>
                                                    <div class="controls">
                                                            <?php echo $field->input; ?>
                                                    </div>
                                            </div>
                                    <?php endforeach; ?>
                                </div>

                                <div class="modal-footer">
                                    <a href="#" class="btn" data-dismiss="modal"><?php echo JText::_('COM_MARKETINGROCKET_CLOSE') ?></a> 
                                        <a class="btn btn-primary" onclick="Joomla.submitbutton('landing.export')">
                                            <?php echo JText::_('COM_MARKETINGROCKET_EXPORT') ?>
                                        </a>
                                </div>
                        </div>
                        
        	</form>
        </div>
        </div>
      
    </div>
    <div class="all-container">
        <div style="clear: both; margin-left: 10px;">
            <p class="pull-left" style="font-size: 16px; margin: 3px 5px 0px 0px;"><?php echo JText::_('COM_MARKETINGROCKET_WIREFRAME_LAYOUT') ?></p>
            <div class=" pull-left">
                   <div class="onoffswitch">
                        <input type="checkbox" name="onoffswitch" class="onoffswitch-checkbox" id="myonoffswitch" >
                        <label class="onoffswitch-label" for="myonoffswitch">
                            <span class="onoffswitch-inner">
                                <span class="onoffswitch-active"><span class="onoffswitch-switch">ON</span></span>
                                 <span class="onoffswitch-inactive"><span class="onoffswitch-switch">OFF</span></span>
                            </span>
                        </label>
                    </div> 
            </div>
            <?php if($editorType == 'landing'): ?> 
                <p class="pull-left" style="font-size: 16px; margin: 3px 5px 0px 10px;"><?php echo JText::_('COM_MARKETINGROCKET_SHOW_MODAL_LAYOUT') ?></p>
                <div class=" pull-left">
                       <div class="onoffswitch">
                            <input type="checkbox" name="show_modal_layout" class="onoffswitch-checkbox" id="show-modal-setting" >
                            <label class="onoffswitch-label" for="show-modal-setting">
                                <span class="onoffswitch-inner">
                                    <span class="onoffswitch-active"><span class="onoffswitch-switch">ON</span></span>
                                     <span class="onoffswitch-inactive"><span class="onoffswitch-switch">OFF</span></span>
                                </span>
                            </label>
                        </div> 
                </div>
                <p class="pull-left" style="font-size: 16px; margin: 3px 5px 0px 10px;"><?php echo JText::_('COM_MARKETINGROCKET_FORM_EDITOR') ?></p>
                <div class=" pull-left">
                    <a onclick="jQuery('#show-form-builder').click()" class="btn btn-primary" style="text-transform: uppercase; margin-left: 10px">
                        <?php echo JText::_('COM_MARKETINGROCKET_EDIT') ?>
                    </a>
                </div>
                <div id="show_exit_popup_layout_holder">
                    <p class="pull-left" style="font-size: 16px; margin: 3px 5px 0px 10px;"><?php echo JText::_('COM_MARKETINGROCKET_SHOW_EXIT_POPUP_LAYOUT') ?></p>
                    <div class=" pull-left">
                           <div class="onoffswitch">
                                <input type="checkbox" name="show_exit_popup_layout" class="onoffswitch-checkbox" id="show_exit_popup_layout" >
                                <label class="onoffswitch-label" for="show_exit_popup_layout">
                                    <span class="onoffswitch-inner">
                                        <span class="onoffswitch-active"><span class="onoffswitch-switch">ON</span></span>
                                         <span class="onoffswitch-inactive"><span class="onoffswitch-switch">OFF</span></span>
                                    </span>
                                </label>
                            </div> 
                    </div>
                </div>
            <?php endif; ?>
            
            <div class="clearfix"></div>
        </div>    
        
        <div id="MR-workaround">
            <div id="overflow-holder" style="position: absolute;left : 0px;right:0px;top:0px;bottom : 0px;background: black;opacity : 0;display:none;z-index:9999"></div>
        	<div id="MR-SideBar" class="MR-ELEMENTS open" >
        		<div>
                            <?php if($editorType == 'landing'): ?>
                                <div class="text-center elemnts" tabindex="0" onclick="app.modal('#MR-landing-setting', 'show')">
                                    <i class="fa fa-lg fa-cog "></i> <span><?php echo JText::_('COM_MARKETINGROCKET_LANDING_SETTING') ?></span>
                                </div>
                            <?php endif; ?>
                            <div class="seperator"></div>
                            <div class="elements-holder-parent">
                                <div class="elements-holder">
                                    <?php if($editorType == 'landing'): ?>
                                        <div class="elemnts text-center" tabindex="2" aria-type="listbox">
                                                <i class="fa fa-lg fa-list-alt "></i> <span><?php echo JText::_('COM_MARKETINGROCKET_LIST_BOX') ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <div class="elemnts text-center" tabindex="3" aria-type="articlebox">
                                            <i class="fa fa-lg fa-file-text-o"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_ARTICLE') ?></span>
                                    </div>
                                    <div class="elemnts text-center" tabindex="4" aria-type="imagebox">
                                            <i class="fa fa-lg fa-picture-o "></i> <span><?php echo JText::_('COM_MARKETINGROCKET_IMAGE') ?></span>
                                    </div>
                                    <?php if($editorType == 'landing'): ?>
                                        <div class="elemnts text-center" tabindex="6" aria-type="form">
                                                <i class="fa fa-lg fa-briefcase"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_FORM_ELEMENT') ?></span>
                                        </div>
                                        <div class="elemnts text-center" tabindex="7" aria-type="videobox">
                                                <i class="fa fa-lg fa-youtube"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_YOUTUBE') ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <div class="elemnts text-center" tabindex="7" aria-type="button">
                                            <i class="fa fa-lg fa-link"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_BUTTON') ?></span>
                                    </div>
                                    
                                    <?php if($editorType == 'landing'): ?>
                                        <div class="elemnts text-center" tabindex="8" aria-type="icon">
                                                <i class="fa fa-lg fa-smile-o"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_ICON') ?></span>
                                        </div>
                                        <div class="elemnts text-center" tabindex="8" aria-type="timer">
                                                <i class="fa fa-lg fa-clock-o"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_TIMER') ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <div class="elemnts text-center" tabindex="8" aria-type="spacer">
                                            <i class="fa fa-lg fa-square-o"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_SPACER') ?></span>
                                    </div>
                                    <div class="elemnts text-center" tabindex="9" aria-type="codebox">
                                            <i class="fa fa-lg fa-code"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_CODEBOX') ?></span>
                                    </div>
                                    <div class="elemnts text-center" tabindex="9" aria-type="media">
                                            <i class="fa fa-lg fa-media"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_MEDIA') ?></span>
                                    </div>
                                    <div class="elemnts text-center" tabindex="9" aria-type="card">
                                            <i class="fa fa-lg fa-card"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_CARD') ?></span>
                                    </div>
                                    <?php if($editorType == 'landing'): ?>
                                        <div class="elemnts text-center" tabindex="9" aria-type="wizard">
                                                <i class="fa fa-magic"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_WIZARD') ?></span>
                                        </div>
                                        <div class="elemnts text-center" tabindex="9" aria-type="pricatetable">
                                                <i class="fa fa-table"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_PRICATETABLE') ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <div class="elemnts text-center" tabindex="9" aria-type="progress">
                                            <i class="fa fa-tasks"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_PROGRESS') ?></span>
                                    </div>
                                    <?php if($editorType == 'landing'): ?> 
                                        <div class="elemnts text-center" tabindex="9" aria-type="comment">
                                                <i class="fa fa-commenting-o"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_COMMENT') ?></span>
                                        </div>
                                        <div class="elemnts text-center" tabindex="7" aria-type="video">
                                                <i class="fa fa-lg fa-film"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_VIDEO') ?></span>
                                        </div>
                                        <div class="elemnts text-center" tabindex="7" aria-type="label">
                                                <i class="fa fa-lg fa-tag"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_LABEL') ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <?php 
                                    
                                    
                                    $buttons = array();
                                    JPluginHelper::importPlugin('marketingrocket');
                                    $dispatcher = JDispatcher::getInstance();
                                    $dispatcher->trigger('onLandingEditorElementsRender', array(&$buttons) );
                                    foreach ($buttons as $button){
                                        echo '<div class="elemnts text-center" tabindex="9" aria-type="'.$button['type'].'">';
                                        echo '<i class="'.$button['icon'].'"></i> <span>'.$button['text'].'</span></div>';
                                    }
                                    
                                    ?>
                                    <?php if($editorType == 'landing'): ?>
                                        <div class="elemnts text-center" tabindex="9" aria-type="loadmodule">
                                                <i class="fa fa-lg fa-loadmodule"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_LOAD_MODULE') ?></span>
                                        </div>
                                        <div class="elemnts text-center" tabindex="9" aria-type="loadposition">
                                                <i class="fa fa-lg fa-loadposition"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_LOAD_POSITION') ?></span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                            
                            
                            <div class="seperator"></div>
                            <div class="elemnts text-center" tabindex="10" aria-type="boxContainer">
                                <i class="fa fa-lg fa-bars"></i> <span><?php echo JText::_('COM_MARKETINGROCKET_BOXCONTAINER') ?></span>
                            </div>
                            <?php if($editorType == 'responder'): ?>
                                <div class="pull-left mini-elements-holder">
                                    <div class="elemnts mini text-center" onclick="app.modal('#mergefields-setting-template', 'show')">
                                        <span><?php echo JText::_('COM_MARKETINGROCKET_MERGE_FIELDS') ?></span>
                                    </div>
                                    <div class="elemnts mini text-center" style="clear: both" onclick="app.modal('#landinglink-setting-template', 'show')">
                                        <span><?php echo JText::_('COM_MARKETINGROCKET_LANDING_LINK') ?></span>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="clearfix"></div>
        		</div>
                        <div class="sidebar-close open">
            			<i class="fa fa-chevron-down"></i>
            		</div>
        	</div>
                
        	<!-- Template  -->
        	
        </div>
        
       
        <div class="modal hide fade" id="MR-IFRAME-MODAL" style="width: 800px;margin-left: 0px; left: 19%;">
        	<div class="modal-header">
        		<button type="button" class="close" data-dismiss="modal"
        			aria-hidden="true">&times;</button>
        		<h3></h3>
        	</div>
        	<div class="modal-body main sbox-content-iframe">
        		<iframe width="800px" height="400px" frameborder="0" src="">
        		
        		</iframe>
        	</div>
        	
        	<div class="modal-footer">
        		<a href="#" class="btn" data-dismiss="modal">Close</a> 
        	</div>
        </div>
    </div>
</div>

<div class="modal hide fade" id="Setting_modal">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><?php echo JText::_('COM_MARKETINGROCKET_CHANGE_TEMPLATE') ?></h3>
    </div>
    <div class="modal-body">
         <div id="loading_holder" class="row-fluid text-center">
                <i class="fa fa-circle-o-notch fa-4x fa-spin"></i>
         </div> 
         <div id="templates_holder"></div>
         <div id="iframeholder" class="text-center">
             <div class="">
                <iframe style="border: 0px solid;"></iframe>
             </div>
         </div>
         <div id="form_builder_container_div" class="hide">
             <ul class="nav nav-tabs">
                 <li class="active" ><a href="#form_builder_container" data-toggle="tab"><?php echo JText::_('COM_MARKETINGROCKET_FORM_BUILDER') ?></a></li>
                 <li><a href="#form_styles" data-toggle="tab"><?php echo JText::_('COM_MARKETINGROCKET_FROM_STYLE_SETTING') ?></a></li>
             </ul>
             <div class="tab-content">
                 <div id="form_builder_container" class="tab-pane active">
                     
                 </div>
                 <div id="form_styles" class="tab-pane">
                     <?php foreach ($this->settingForm->getFieldset('form-style') as $field) : ?>
                        <div class="control-group">
                                 <div class="control-label">
                                        <?php echo $field->label; ?>
                                 </div>
                                 <div class="controls">
                                      <?php echo $field->input; ?>
                                 </div>
                         </div>
                    <?php endforeach; ?>
                 </div>
             </div>
         </div>
        <div id="editor_div" class="hide"></div>
    </div>
    <div class="modal-footer">
        <a href="#" class="btn" data-dismiss="modal">Close</a>
    </div>
</div>
<div class="modal hide fade" id="code_editor_modal">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><?php echo JText::_('COM_MARKETINGROCKET_CODEBOX_EDIT_TITLE') ?></h3>
    </div>
    <div class="modal-body">
    </div>
    <div class="modal-footer">
        <a href="#" class="btn" data-dismiss="modal">Close</a>
        <a class="btn btn-primary">Save</a>
    </div>
</div>
<script>
    
var pageType = '<?php echo $editorType ?>';
<?php if($editorType == 'landing'){ ?>
    var autoSaveTime = 120000;
<?php } ?>
var lastTempId = <?php echo $this->lastTempId ?>;
    localStorage.setItem('jsidebar', false);
var locationOfJoomla = '<?php echo JUri::root(true) ?>';
var joomlaHost = '<?php echo (JComponentHelper::getParams('com_marketingrocket')->get('site_address', '') == '') ? JUri::root() : JComponentHelper::getParams('com_marketingrocket')->get('site_address') ?>'
var COM_MARKETINGROCKET_SETTING = '<?php echo  JText::_('COM_MARKETINGROCKET_SETTING', true) ?>';
var COM_MARKETINGROCKET_PAGE_SETTING = '<?php echo  JText::_('COM_MARKETINGROCKET_PAGE_SETTING', true) ?>';
var COM_MARKETINGROCKET_ITEM_SETTING = '<?php echo  JText::_('COM_MARKETINGROCKET_ITEM_SETTING', true) ?>';
var COM_MARKETINGROCKET_REMOVE = '<?php echo  JText::_('COM_MARKETINGROCKET_REMOVE', true) ?>';
var COM_MARKETINGROCKET_ITEM_REMOVE = '<?php echo  JText::_('COM_MARKETINGROCKET_ITEM_REMOVE', true) ?>';

var COM_MARKETINGROCKET_CONTAINER_SETTING = '<?php echo  JText::_('COM_MARKETINGROCKET_CONTAINER_SETTING', true) ?>';
var COM_MARKETINGROCKET_CONTAINER_REMOVE = '<?php echo  JText::_('COM_MARKETINGROCKET_CONTAINER_REMOVE', true) ?>';

var COM_MARKETINGROCKET_ROW_SETTING = '<?php echo  JText::_('COM_MARKETINGROCKET_ROW_SETTING', true) ?>';

var COM_MARKETINGROCKET_LIST_SETTING = '<?php echo  JText::_('COM_MARKETINGROCKET_LIST_SETTING', true) ?>';
var COM_MARKETINGROCKET_ARTICLE_TEXT  = '<?php echo  JText::_('COM_MARKETINGROCKET_ARTICLE_TEXT', true) ?>';
var COM_MARKETINGROCKET_BUTTON_STYLE = '<?php echo  JText::_('COM_MARKETINGROCKET_BUTTON_STYLE', true) ?>';
var COM_MARKETINGROCKET_BUTTONBOX_SETTINGS = '<?php echo  JText::_('COM_MARKETINGROCKET_BUTTONBOX_SETTINGS', true) ?>'; 
var COM_MARKETINGROCKET_IMAGEBOX_SETTINGS = '<?php echo  JText::_('COM_MARKETINGROCKET_IMAGEBOX_SETTINGS', true) ?>';
var COM_MARKETINGROCKET_VIDEOBOX_SETTINGS = '<?php echo  JText::_('COM_MARKETINGROCKET_VIDEOBOX_SETTINGS', true) ?>';
var COM_MARKETINGROCKET_SORT_UP = '<?php echo JText::_('COM_MARKETINGROCKET_SORT_UP', true) ?>';
var COM_MARKETINGROCKET_SORT_DOWN = '<?php echo JText::_('COM_MARKETINGROCKET_SORT_DOWN', true) ?>';
var COM_MARKETINGROCKET_IMAGEBUTTON_SETTINGS = '<?php echo JText::_('COM_MARKETINGROCKET_IMAGEBUTTON_SETTINGS', true) ?>'; 
var COM_MARKETINGROCKET_MOVE_LEFT = '<?php echo JText::_('COM_MARKETINGROCKET_MOVE_LEFT', true) ?>';
var COM_MARKETINGROCKET_MOVE_RIGHT = '<?php echo JText::_('COM_MARKETINGROCKET_MOVE_RIGHT', true) ?>';
var COM_MARKETINGROCKET_NO_ENOUGH_ROOM_PREV = '<?php echo JText::_('COM_MARKETINGROCKET_NO_ENOUGH_ROOM_PREV', true) ?>';
var COM_MARKETINGROCKET_NO_ENOUGH_ROOM_NEXT = '<?php echo JText::_('COM_MARKETINGROCKET_NO_ENOUGH_ROOM_NEXT', true) ?>';
var COM_MARKETINGROCKET_CANT_MOVE = '<?php echo JText::_('COM_MARKETINGROCKET_CANT_MOVE' , true) ?>';

var COM_MARKETINGROCKET_EDIT_FORM = '<?php echo JText::_('COM_MARKETINGROCKET_EDIT_FORM', true) ?>';

var COM_MARKETINGROCKET_SIMPLEBOX_EDIT_TEXT = '<?php echo JText::_('COM_MARKETINGROCKET_SIMPLEBOX_EDIT_TEXT', true) ?>'; 
var COM_MARKETINGROCKET_YOU_DONT_USED_FORM_OR_CTA = '<?php echo JText::_('COM_MARKETINGROCKET_YOU_DONT_USED_FORM_OR_CTA', true ) ?>';
var COM_MARKETINGROCKET_PUT_FORM_OR_CTA_JUST_IN_ONE = '<?php echo JText::_('COM_MARKETINGROCKET_PUT_FORM_OR_CTA_JUST_IN_ONE', true) ?>';

var COM_MARKETINGROCKET_DUPLICATE = '<?php echo JText::_('COM_MARKETINGROCKET_DUPLICATE', true) ?>';
var COM_MARKETINGROCKET_ADD_SECTION = '<?php echo JText::_('COM_MARKETINGROCKET_ADD_SECTION', true) ?>';
var COM_MARKETINGROCKET_YOU_DONT_USED_CTA = '<?php echo JText::_('COM_MARKETINGROCKET_YOU_DONT_USED_CTA', true) ?>';

var COM_MARKETINGROCKET_OPENFORM_CLICK_ALERT = '<?php echo JText::_('COM_MARKETINGROCKET_OPENFORM_CLICK_ALERT', true) ?>';
var COM_MARKETINGROCKET_FORM_DROP_ERROR_POPUP = '<?php echo JText::_('COM_MARKETINGROCKET_FORM_DROP_ERROR_POPUP', true) ?>';
var COM_MARKETINGROCKET_ONLY_ONE_TIME_ELEMENT_ERRORR = '<?php echo JText::_('COM_MARKETINGROCKET_ONLY_ONE_TIME_ELEMENT_ERRORR', true) ?>';

var COM_MARKETINGROCKET_YOU_MUST_SELECT_FORM = '<?php echo JText::_('COM_MARKETINGROCKET_YOU_MUST_SELECT_FORM', true) ?>';
var COM_MARKETINGROCKET_ADDRESS_ALREADY_ADDED_TO_PAGE = '<?php echo JText::_('COM_MARKETINGROCKET_ADDRESS_ALREADY_ADDED_TO_PAGE', true) ?>';
var COM_MARKETINGROCKET_ICON_EDIT_TITLE = '<?php echo JText::_('COM_MARKETINGROCKET_ICON_EDIT_TITLE', true) ?>';
var COM_MARKETINGROCKET_TESTER_ALREADY_ADDED_TO_PAGE = '<?php echo JText::_('COM_MARKETINGROCKET_TESTER_ALREADY_ADDED_TO_PAGE', true) ?>';

var aliasDefaultValue = '<?php echo $this->item->alias ?>'
var landingsDefaultValue = '<?php echo $this->item->to_landing_page ?>'
var respodersDefaultValue =  '<?php echo $this->item->responder_sequence_id ?>';

var payToLandingPage = '<?php echo $this->item->pay_to_landing_page ?>';

var landingId = <?php echo (int)$this->item->id ?>;


var apiDefaultValue = '<?php echo $this->item->api_id ?>';


var path = <?php echo (empty($this->menuUrl['home'])) ? "'".$this->menuUrl['path']."'" : 'true' ?>;

var token = '<?php echo JComponentHelper::getParams('com_marketingrocket')->get('salt') ?>';

var __lang = {
    COM_MARKETINGROCKET_TIMER_EDIT_TITLE : '<?php echo JText::_('COM_MARKETINGROCKET_TIMER_EDIT_TITLE', true) ?>',
    COM_MARKETINGROCKET_ELEMENT_NOT_FOUND : '<?php echo JText::_('COM_MARKETINGROCKET_ELEMENT_NOT_FOUND', true) ?>',
    COM_MARKETINGROCKET_CODEBOX_EDIT_TITLE : '<?php echo JText::_('COM_MARKETINGROCKET_CODEBOX_EDIT_TITLE', true) ?>',
    COM_MARKETINGROCKET_EDIT_SOURCE : '<?php echo JText::_('COM_MARKETINGROCKET_CODEBOX_EDIT_TITLE', true) ?>',
    COM_MARKETING_REMOVINGFORMALERT : '<?php echo JText::_('COM_MARKETING_REMOVINGFORMALERT', true) ?>',
    COM_MARKETINGROCKET_AUTO_SAVING : '<?php echo JText::_('COM_MARKETINGROCKET_AUTO_SAVING', true) ?>',
    COM_MARKETINGROCKET_LAST_AUTO_SAVE_ON : '<?php echo JText::_('COM_MARKETINGROCKET_LAST_AUTO_SAVE_ON', true) ?>',
    COM_MARKETINGROCKET_RESTORE_AUTOSAVE_CONFIRM : '<?php echo JText::_('COM_MARKETINGROCKET_RESTORE_AUTOSAVE_CONFIRM', true) ?>',
    COM_MARKETINGROCKET_RIBBON : '<?php echo JText::_('COM_MARKETINGROCKET_RIBBON', true) ?>',
    COM_MARKETINGROCKET_LOADMODULE_SETTINGS : '<?php echo JText::_('COM_MARKETINGROCKET_LOADMODULE_SETTINGS', true) ?>',
    COM_MARKETINGROCKET_LOADPOSITION_SETTINGS : '<?php echo JText::_('COM_MARKETINGROCKET_LOADPOSITION_SETTINGS', true) ?>',
    COM_MARKETINGROCKET_WIZARD_SETTINGS : '<?php echo JText::_('COM_MARKETINGROCKET_WIZARD_SETTINGS', true) ?>',
    COM_MARKETINGROCKET_PRICETABLE_SETTINGS : '<?php echo JText::_('COM_MARKETINGROCKET_PRICETABLE_SETTINGS', true) ?>',
    COM_MARKETINGROCKET_PROGRESS : '<?php echo JText::_('COM_MARKETINGROCKET_PROGRESS', true) ?>',
    COM_MARKETINGROCKET_COMMENT : '<?php echo JText::_('COM_MARKETINGROCKET_COMMENT', true) ?>',
    COM_MARKETINGROCKET_YEAR : '<?php echo JText::_('COM_MARKETINGROCKET_YEAR', true) ?>',
    COM_MARKETINGROCKET_MONTHS : '<?php echo JText::_('COM_MARKETINGROCKET_MONTHS', true) ?>',
    COM_MARKETINGROCKET_DAYS : '<?php echo JText::_('COM_MARKETINGROCKET_DAYS', true) ?>',
    COM_MARKETINGROCKET_HOURS : '<?php echo JText::_('COM_MARKETINGROCKET_HOURS', true) ?>',
    COM_MARKETINGROCKET_MINUTES : '<?php echo JText::_('COM_MARKETINGROCKET_MINUTES', true) ?>',
    COM_MARKETINGROCKET_SECONDS : '<?php echo JText::_('COM_MARKETINGROCKET_SECONDS', true) ?>',
    COM_MARKETINGROCKET_FORM_BUILDER : '<?php echo JText::_('COM_MARKETINGROCKET_FORM_BUILDER') ?>',
    COM_MARKETINGROCKET_ADD_NEW_FIELD : '<?php echo JText::_('COM_MARKETINGROCKET_ADD_NEW_FIELD') ?>',
    COM_MARKETINGROCKET_EDIT_FIELD : '<?php echo JText::_('COM_MARKETINGROCKET_EDIT_FIELD') ?>',
    COM_MARKETINGROCKET_FIELD_NAME : '<?php echo JText::_('COM_MARKETINGROCKET_FIELD_NAME') ?>',
    COM_MARKETINGROCKET_LABEL : '<?php echo JText::_('COM_MARKETINGROCKET_LABEL') ?>',
    COM_MARKETINGROCKET_ADD_A_LONGER_DESCRIPTION_TO_THIS_FIELD : '<?php echo JText::_('COM_MARKETINGROCKET_ADD_A_LONGER_DESCRIPTION_TO_THIS_FIELD') ?>',
    COM_MARKETINGROCKET_REQUIRED : '<?php echo JText::_('COM_MARKETINGROCKET_REQUIRED') ?>',
    COM_MARKETINGROCKET_ARE_YOU_SURE_ABOUT_DELETE : '<?php echo JText::_('COM_MARKETINGROCKET_ARE_YOU_SURE_ABOUT_DELETE') ?>',
    COM_MARKETINGROCKET_REMOVE : '<?php echo JText::_('COM_MARKETINGROCKET_REMOVE') ?>',
    COM_MARKETINGROCKET_VIDEO_SETTINGS : '<?php echo JText::_('COM_MARKETINGROCKET_VIDEO_SETTINGS') ?>',
    COM_MARKETINGROCKET_LABEL_SETTINGS : '<?php echo JText::_('COM_MARKETINGROCKET_LABEL_SETTINGS') ?>',
    COM_MARKETINGROCKET_IMAGEBOX_STYLE_SETTINGS : '<?php echo JText::_('COM_MARKETINGROCKET_IMAGEBOX_STYLE_SETTINGS') ?>',

    COM_MARKETINGROCKET_CHOOSE_ACTION_AFTER_SUBMITION_OPT_IN_FORM : '<?php echo JText::_('COM_MARKETINGROCKET_CHOOSE_ACTION_AFTER_SUBMITION_OPT_IN_FORM', true) ?>',
    COM_MARKETINGROCKET_CHOOSE_ACTION_AFTER_SUBMITION_OPT_IN_FORM_DESC : '<?php echo JText::_('COM_MARKETINGROCKET_CHOOSE_ACTION_AFTER_SUBMITION_OPT_IN_FORM_DESC', true) ?>',
    COM_MARKETINGROCKET_OPT_IN_MENU_ITEM : '<?php echo JText::_('COM_MARKETINGROCKET_OPT_IN_MENU_ITEM', true) ?>',
    COM_MARKETINGROCKET_OPT_IN_MENU_ITEM_DESC : '<?php echo JText::_('COM_MARKETINGROCKET_OPT_IN_MENU_ITEM_DESC', true) ?>',
    COM_MARKETINGROCKET_OPT_IN_REDIRECT_URL : '<?php echo JText::_('COM_MARKETINGROCKET_OPT_IN_REDIRECT_URL', true) ?>',
    COM_MARKETINGROCKET_OPT_IN_REDIRECT_URL_TOOLTIP : '<?php echo JText::_('COM_MARKETINGROCKET_OPT_IN_REDIRECT_URL_TOOLTIP', true) ?>',
    COM_MARKETINGROCKET_OPT_IN_MESSAGE : '<?php echo JText::_('COM_MARKETINGROCKET_OPT_IN_MESSAGE', true) ?>',
    COM_MARKETINGROCKET_OPT_IN_MESSAGE_TOOLTIP : '<?php echo JText::_('COM_MARKETINGROCKET_OPT_IN_MESSAGE_TOOLTIP', true) ?>',

    COM_MARKETINGROCKET_OPT_IN_OPEN_LANDING_PAGE : '<?php echo JText::_('COM_MARKETINGROCKET_OPT_IN_OPEN_LANDING_PAGE', true) ?>',
    COM_MARKETINGROCKET_OPT_IN_OPEN_LANDING_PAGE_DESC : '<?php echo JText::_('COM_MARKETINGROCKET_OPT_IN_OPEN_LANDING_PAGE_DESC', true) ?>',

    COM_MARKETINGROCKET_AFTER_PAYMENT : '<?php echo JText::_('COM_MARKETINGROCKET_AFTER_PAYMENT', true) ?>',
    COM_MARKETINGROCKET_AFTER_PAYMENT_DESC : '<?php echo JText::_('COM_MARKETINGROCKET_AFTER_PAYMENT_DESC', true) ?>',
    COM_MARKETINGROCKET_CANCELPAY_MENU_ITEM : '<?php echo JText::_('COM_MARKETINGROCKET_CANCELPAY_MENU_ITEM', true) ?>',
    COM_MARKETINGROCKET_CANCELPAY_MENU_ITEM_TOOLTIP : '<?php echo JText::_('COM_MARKETINGROCKET_CANCELPAY_MENU_ITEM_TOOLTIP', true) ?>',
    COM_MARKETINGROCKET_CANCELPAY_REDIRECT_URL : '<?php echo JText::_('COM_MARKETINGROCKET_CANCELPAY_REDIRECT_URL', true) ?>',
    COM_MARKETINGROCKET_CANCELPAY_REDIRECT_URL_TOOLTIP : '<?php echo JText::_('COM_MARKETINGROCKET_CANCELPAY_REDIRECT_URL_TOOLTIP', true) ?>',
    COM_MARKETINGROCKET_CANCELPAY_MESSAGE : '<?php echo JText::_('COM_MARKETINGROCKET_CANCELPAY_MESSAGE', true) ?>',
    COM_MARKETINGROCKET_CANCELPAY_MESSAGE_TOOLTIP : '<?php echo JText::_('COM_MARKETINGROCKET_CANCELPAY_MESSAGE_TOOLTIP', true) ?>',

    COM_MARKETINGROCKET_CANCELPAY_OPEN_LANDING_PAGE : '<?php echo JText::_('COM_MARKETINGROCKET_CANCELPAY_OPEN_LANDING_PAGE', true) ?>',
    COM_MARKETINGROCKET_CANCELPAY_OPEN_LANDING_PAGE_DESC : '<?php echo JText::_('COM_MARKETINGROCKET_CANCELPAY_OPEN_LANDING_PAGE_DESC', true) ?>',
	COM_MARKETINGROCKET_GOOGLE_RECAPTCHA_KEY : '<?php echo JText::_('COM_MARKETINGROCKET_GOOGLE_RECAPTCHA_KEY', true) ?>',
	COM_MARKETINGROCKET_GOOGLE_RECAPTCHA_KEY_TOOLTIP : '<?php echo JText::_('COM_MARKETINGROCKET_GOOGLE_RECAPTCHA_KEY_TOOLTIP', true) ?>'
};

var timeZones = {
    <?php
    $zones = DateTimeZone::listIdentifiers();
    $sep = '';
    foreach ($zones as $zone){
        $zoneObj = new DateTimeZone($zone);
        $date = JDate::getInstance('now', new DateTimeZone("Asia/Taipei"));
        echo $sep. '"'.$zone.'"' . ' : "'.$zoneObj->getOffset($date).'"';
        $sep = ',';
    }
   
    ?>
};

var configUrl = '<?php echo JRoute::_('index.php?option=com_marketingrocket&task=landing.config&id='.(int)$this->item->id, false) ?>';
var wizard = <?php echo JFactory::getApplication()->input->getInt('wizard', 0) ?>;
var pageDirection = '<?php echo $this->document->direction; ?>';

var googleRecaptchaKey = '<?php echo JComponentHelper::getParams('com_marketingrocket')->get('google_recaptcha_key'); ?>';

function generateReCaptcha() {
    $('.g-recaptcha').each(function (i, captcha) {
        var current_key = $(this).attr('data-sitekey'),
            html = $(this).html();
        if ((current_key != '') || (html != '')) {
            return;
        }
        $(this).html('');
        grecaptcha.render(captcha, {
            'sitekey' : googleRecaptchaKey
        });
    });
}
window.onload = function() {
  //generateReCaptcha();
};

</script>
<?php echo $this->loadTemplate('templates'); ?>
<?php echo $this->loadTemplate('video_modal'); ?>