<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class MarketingrocketViewDashboard extends JViewLegacy
{
	
	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );
                
                
	
		$reportModel = JModelLegacy::getInstance('Reports', 'MarketingrocketModel', array('ignore_request' => true));
		$this->setModel($reportModel, true);
                $this->state		= $this->get('State');
		$this->list             = $this->get('Items');
                $this->pagination	= $this->get('Pagination');
                
                
		$model = $this->getModel();
		
                
                $startDateObj = JFactory::getDate( 'now', JFactory::getConfig()->get('offset'));
                $startDateObj->modify('-30 day');
                
                $endDateObj = JFactory::getDate( 'now', JFactory::getConfig()->get('offset'));
                $endDateObj->modify('1 day');
                $start = $startDateObj->format('Y-m-d');
                $this->stats = $model->getDailyStat($start, $endDateObj->format('Y-m-d'));
                
		$this->convertedCount = $model->getConvertedCount($startDateObj->format('Y-m-d'), $endDateObj->format('Y-m-d'));
                
                $startDateObj->modify('-30 day');
                $endDateObj->modify('-31 day');
                
                $this->prevMonthStat = $model->getPrevMonthStat($startDateObj->format('Y-m-d'), $endDateObj->format('Y-m-d'));
                
                $this->prevMonthConverted = $model->getConvertedCount($startDateObj->format('Y-m-d'), $endDateObj->format('Y-m-d'));
		
		$totalView = 0;
		$totalSubmission = 0;
		foreach ($this->stats as $row){
			$totalView += $row->visits;
			$totalSubmission += $row->submissions;
		}
		$this->totalView = $totalView;
		$this->totalSubmission = $totalSubmission;
		
		$this->endTime = JFactory::getDate('now', JFactory::getConfig()->get('offset'))->getTimestamp();
                
                $startDate = JFactory::getDate('now', JFactory::getConfig()->get('offset'));
                $startDate->modify('-30 day');
                
		$this->time = $startDate->getTimestamp();
	  
		$document =  JFactory::getDocument ();
		$document->addScript ( JUri::base() . '/components/com_marketingrocket/assets/js/highcharts-custom.js', "text/javascript" , true );
                
		MarketingrocketHelper::addSubmenu('dashboard');
		
		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
		$this->videoHelp = MarketingrocketHelper::videoHelper('dashboard');
                
                
                $this->videoHelp = MarketingrocketHelper::videoHelper('dashborad');
                
                
                $this->dashBoardLogo = JComponentHelper::getParams('com_marketingrocket')->get('dash_board_logo', 'media/com_marketingrocket/logo-transparent.png');
                
		parent::display($tpl);
	}
	protected function addToolbar()
	{
		
		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_DASHBOARD'), '');
		$canDo	= MarketingrocketHelper::getActions();
		$user	= JFactory::getUser();
		if ($canDo->get('core.admin'))
		{
			JToolbarHelper::preferences('com_marketingrocket');
		}
		
		
	}

	
}
