<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketViewCategory extends JViewLegacy
{
	protected $state;

	protected $item;

	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
            
            JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_categories'.DS.'models');
            require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_categories'.DS.'tables'.DS.'category.php';
            
            $model = JModelLegacy::getInstance('Category', 'CategoriesModel');
            
            JForm::addFormPath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_categories'.DS.'models'.DS.'forms');
            
            $lang = JFactory::getLanguage();
            $extension = 'com_categories';
            $base_dir = JPATH_ADMINISTRATOR;
            $language_tag = 'en-GB';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload); 
            
            $this->setModel($model, true);

            $this->state	= $this->get('State');
//                $this->item	= $this->get('Item');
            $this->form	= $this->get('Form');
            $this->form->removeField('tags');
            // Check for errors.
            if (count($errors = $this->get('Errors')))
            {
                    JError::raiseError(500, implode("\n", $errors));
                    return false;
            }

            $this->addToolbar();
            parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{

		JFactory::getApplication()->input->set('hidemainmenu', true);

		// Since we don't track these assets at the item level, use the category id.
		$canDo		= MarketingrocketHelper::getActions();

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGE_CATEGORY'), '');

		// If not checked out, can save the item.
		if (($canDo->get('core.edit')))
		{
			JToolbarHelper::apply('category.apply');
			JToolbarHelper::save('category.save');
		}
		if (empty($this->item->id))
		{
			JToolbarHelper::cancel('category.cancel');
		}
		else
		{
			JToolbarHelper::cancel('category.cancel', 'JTOOLBAR_CLOSE');
		}

		JToolbarHelper::divider();
	}
}
