<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class MarketingrocketViewCampaigns extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		
		$this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );
		
		$app		= JFactory::getApplication();
		$getList = $app->input->get('get', false);
		if(!empty($getList) && $getList == 'campaignList')
			$this->_getList();
		else if(!empty($getList) && $getList == 'Reponders')
			$this->_getResponders();
		else if($getList == 'landing'){
			$this->_getLanding();
		}
		else if($getList == 'landingalias'){
			$this->_getLandingAlias();
		}
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		require_once JPATH_COMPONENT.'/helpers/marketingrocket.php';
		MarketingrocketHelper::addSubmenu('campaigns');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
                
                $this->filterForm    = $this->get('FilterForm');

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
		$this->videoHelp = MarketingrocketHelper::videoHelper('campaigns');
		parent::display($tpl);
	}

	private  function _getList(){
// 		$catId = 
		$list = $this->get('CampaignList');
		echo json_encode($list); 
		die;
	}
	
	private  function _getResponders(){
		// 		$catId =
		$list = $this->get('RespondersList');
		echo json_encode($list);
		die;
	}
	private  function _getLanding(){
		$list = $this->get('LandingsList');
		
		echo json_encode($list);
		die;
	}
	private  function _getLandingAlias(){
		$list = $this->get('LandingsList');
		echo json_encode($list);
		die;
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		

//		$state	= $this->get('State');

		$canDo	= MarketingrocketHelper::getActions();
//		$user	= JFactory::getUser();
		// Get the toolbar object instance
//		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGER_CAMPAIGNS'), '');
		JToolbarHelper::addNew('campaign.add');
		if ($canDo->get('core.edit'))
		{
			JToolbarHelper::editList('campaign.edit');
		}
// 		if ($canDo->get('core.edit.state')) {

// 			JToolbarHelper::publish('blockedperson.publish', 'JTOOLBAR_PUBLISH', true);
// 			JToolbarHelper::unpublish('blockedperson.unpublish', 'JTOOLBAR_UNPUBLISH', true);

// 			JToolbarHelper::archiveList('blockedperson.archive');
// 			JToolbarHelper::checkin('blockedperson.checkin');
// 		}

			JToolbarHelper::deleteList('COM_MARKETINGROCKET_ARE_YOUR_SURE_ABOUT_DELETE_THIS_CAMPAIGNS' , 'campaigns.delete');


		if ($canDo->get('core.admin'))
		{
			JToolbarHelper::preferences('com_marketingrocket');
		}


		JHtmlSidebar::setAction('index.php?option=com_marketingrocket&view=campaigns');

                $bar = JToolbar::getInstance('toolbar');
                $bar->appendButton('Confirm', 'COM_MARKETINGROCKET_ARE_YOUR_SURE_ABOUT_RESET_STATICS_OF_THIS_ITEMS', 'refresh', JText::_('COM_MARKETINGROCKET_RESET_STATICS'), 'campaigns.resetstat', true);




	}
}
