<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));

$listDirn	= $this->escape($this->state->get('list.direction'));
$canOrder	= true;
$saveOrder	= $listOrder == 'a.ordering';
// if ($saveOrder)
// {
// 	$saveOrderingUrl = 'index.php?option=com_marketingrocket&task=hotel.saveOrderAjax&tmpl=component';
// 	JHtml::_('sortablelist.sortable', 'hotelList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
// }
?>
<script type="text/javascript">
	Joomla.orderTable = function()
	{
		table = document.getElementById("sortTable");
		direction = document.getElementById("directionTable");
		order = table.options[table.selectedIndex].value;
		if (order != '<?php echo $listOrder; ?>')
		{
			dirn = 'asc';
		}
		else
		{
			dirn = direction.options[direction.selectedIndex].value;
		}
		Joomla.tableOrdering(order, dirn, '');
	}
        jQuery(document).ready(function($){
           $('#toolbar-delete').find('button').attr('onclick', '').click(function(){
               if(document.adminForm.boxchecked.value == 0){
                   alert('<?php echo JText::_('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST', true) ?>');
                   return false;
               }
               
               
                   var t = prompt('<?php echo JText::_('COM_MARKETINGROCKET_ENTER_WORD_DELETE', true) ?>');
                   if(t && $.trim(t.toLowerCase()) == 'delete'){
                       Joomla.submitbutton('campaigns.delete');
                   }
           })
        })
</script>
<form action="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=campaigns'); ?>" method="post" name="adminForm" id="adminForm">
<?php if (!empty( $this->sidebar)) : ?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
		<br />
		<p class="center bold"><a onclick="showmodal()" style="cursor: pointer;color:#fff;">
			<?php echo JText::_('COM_MARKETINGROCKET_WATCH_THE_VIDEO_GUIDE') ?>
			<img src="<?php echo $this->videoHelp['img'] ?>" alt="<?php echo $this->videoHelp['text'] ?>" />
		</a></p>
		<p class="center bold"><?php echo JText::_('COM_MARKETINGROCKET_CLICK_HERE_FOR_MORE_SUPPORT') ?></p>
	</div>
	<div id="j-main-container" class="span10">
<?php else : ?>
	<div id="j-main-container">
<?php endif;?>
            <?php echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
		<table class="table table-striped" id="table-list">
			<thead>
				<tr>
					
					<th width="1%" class="hidden-phone">
						<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
					</th>

					<th class="title">
						<?php echo JHtml::_('searchtools.sort', 'COM_MARKETINGROCKET_NAME', 'name', $listDirn, $listOrder); ?>
					</th>
					<th width="13%" class="nowrap hidden-phone">
						<?php echo JHtml::_('searchtools.sort', 'COM_MARKETINGROCKET_CREATED_ORDER', 'created', $listDirn, $listOrder); ?>
					</th>
					
					<th style="text-align: center">
						<?php echo JHtml::_('searchtools.sort', 'COM_MARKETINGROCKET_CATEGORY', 'category_title', $listDirn, $listOrder); ?>
					</th>
					<th style="text-align: center">
						<?php echo JHtml::_('searchtools.sort', 'COM_MARKETINGROCKET_LEADS_COUNT', 'cnt', $listDirn, $listOrder); ?>
					</th>
					<th style="text-align: center">
						<?php echo JText::_('COM_MARKETINGROCKET_SEND_MARKETING_EMAIL_TO_CAMPAIGN') ?>
					</th>
					<th width="1%" class="nowrap center hidden-phone">
						<?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_ID', 'id', $listDirn, $listOrder); ?>
					</th>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<td colspan="10">
						<?php echo $this->pagination->getListFooter(); ?>
					</td>
				</tr>
			</tfoot>
			<tbody>
			<?php foreach ($this->items as $i => $item) :
				
				
				$ordering   = ($listOrder == 'a.ordering');

				$canCreate  = true;
				$canEdit    = true;
				$canCheckin = true;
				$canChange  = true;
				?>
				<tr class="row<?php echo $i % 2; ?>">
					
					<td class="center hidden-phone">
						<?php echo JHtml::_('grid.id', $i, $item->id); ?>
					</td>

					<td class="has-context" style="word-wrap: break-word;">
						<a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=campaign&layout=edit&id='.(int) $item->id); ?>">
								<?php echo $this->escape($item->name); ?></a>
					</td>
					<td class="small hidden-phone">
						<?php echo $item->created; ?>
					</td>
					<td class="center">
						<?php echo $item->category_title; ?>
					</td>
					<td class="center">
						<?php echo $item->cnt ?>
					</td>
					<td class="center">
						<?php if($item->cnt): ?>
							<a class="btn btn-success" href="<?php echo JRoute::_('index.php?option=com_marketingrocket&layout=edit&view=responder&type=marketing&campaign_id='.(int) $item->id); ?>">
								<span class="icon-mail icon-white"></span>
								<?php echo JText::_('COM_MARKETINGROCKET_CREATE_MAIL') ?>
							</a>
						<?php endif; ?>
					</td>
					<td class="center hidden-phone">
						<?php echo (int) $item->id; ?>
					</td>
				</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<?php //Load the batch processing form. ?>

		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
</form>
<?php echo $this->loadTemplate('video_modal'); ?>