<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketViewApi extends JViewLegacy
{
	protected $state;

	protected $item;

	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{

            $this->state	= $this->get('State');
            $this->item		= $this->get('Item');
            $this->form		= $this->get('Form');

            // Check for errors.
            if (count($errors = $this->get('Errors')))
            {
                    JError::raiseError(500, implode("\n", $errors));
                    return false;
            }

            $model = $this->getModel();
            $this->apiType = $model->apiType;
            
            $this->addToolbar();
            parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
            // Since we don't track these assets at the item level, use the category id.
            $canDo		= MarketingrocketHelper::getActions();

            if(JFactory::getApplication()->input->getString('layout') != 'choose'){
                JFactory::getApplication()->input->set('hidemainmenu', true);
                JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGE_API'), '');
                // If not checked out, can save the item.
                if (($canDo->get('core.edit')))
                {
                        JToolbarHelper::apply('api.apply');
                        JToolbarHelper::save('api.save');
                }
                if (empty($this->item->id))
                {
                        JToolbarHelper::cancel('api.cancel');
                }
                else
                {
                        JToolbarHelper::cancel('api.cancel', 'JTOOLBAR_CLOSE');
                }
            }
            else {
                JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_CHOOSE_API_TYPE'), '');
            }

            JToolbarHelper::divider();
	}
}
