<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */
defined ( '_JEXEC' ) or die ();
?>

<?php
$db = JFactory::getDbo();
$q = $db->getQuery(true);
$q->select('a.*,b.enabled')->from('#__mrocket_api_types as a')
        ->leftJoin('#__extensions as b ON BINARY a.plugin = BINARY b.name')
        ->order('category ASC');
$db->setQuery($q);
$types = $db->loadObjectList();
$order = array('marketing_email' => array('email_responder', 'marketing_email'), 'payment' => array('payment', 'payment_by'), 'crm_synchronisation', 'other', 'landing');
$newOrder = array();
foreach ($order as $orderKey => $row){
    foreach($types as $key => $type){
        if((is_array($row) && in_array($type->category, $row)) || (!is_array($row) && $type->category == $row)){
            if(is_array($row))
                $type->new_category = $orderKey;
            else 
                $type->new_category = $row;
            $newOrder[] = $type;
            unset($types[$key]);
        }
    }
}
$newOrder = array_merge($newOrder, $types); // if there is additional unofficial categories

$lastCat = '';
$lang = JFactory::getLanguage();
foreach ($newOrder as $type){
    if(!empty($type->plugin) && $type->enabled != 1)
        continue;
    if($type->new_category != $lastCat){
        $lastCat = $type->new_category;
        echo '<br /><h4 style="margin-bottom : 3px">'. JText::_('COM_MARKETINGROCKET_'.strtoupper($lastCat)).'</h4><hr style="margin : 3px 0 10px" />';
    }
    $source = JPATH_PLUGINS . '/marketingrocket/' . $type->type;
    $extension = 'plg_marketingrocket_' . $type->type;
    $lang->load($extension . '.sys', JPATH_ADMINISTRATOR, null, false, true)
    || $lang->load($extension . '.sys', $source, null, false, true);

?>
<a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=api&layout=edit&id=0&type='.$type->type) ?>">
    <div class="media" style="margin-bottom: 10px">
        <span class="pull-left" style="min-width: 64px">
            <?php echo $type->icon ?>
        </span>
        <div class="media-body">
            <h6 class="media-heading">
                <?php echo JText::_($type->title) ?>
            </h6>
            <p style="font-size: 0.8em"><?php echo JText::_($type->desc) ?></p>
        </div>
    </div>
</a>

<?php } ?>

