<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

use Joomla\Registry\Registry;

defined('_JEXEC') or die;

class MarketingrocketViewAction extends JViewLegacy
{
	protected $state;

	protected $item;

	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
            $this->addTemplatePath( JPATH_COMPONENT.'/views/_common' );

		$this->state	= $this->get('State');
                $input = JFactory::getApplication()->input;
                if($input->getInt('wizard', 0) > 0){
                    $session = JFactory::getSession();
                    $template = $session->get('wizard', false, 'com_marketingrocket');
                    if(empty($template))
                    {
                         die('template is empty');
                    }
                    if(isset($template->items[$input->getInt('wizard')-2]->options->actions)){
                        $registery = new Registry;
                        $registery->loadObject($template->items[$input->getInt('wizard')-2]->options->actions);
                        
                        $this->items = $registery->toArray();
                        $this->items = $this->items['action'];
                    }
                    
                }
                else {
                    $session = JFactory::getSession();

                    if($session->has('landing_action') && $input->getInt('landing_id', 0) == 0)
                       $this->items = $session->get('landing_action', array());
                    else 
                       $this->items = $this->get('Items');
                }
                $obj = array();
                
                $obj['id'] = null;
                $obj['condition_type'] = 'any';
                $obj['tags'] = '[]';
                $obj['action'] = 'add_responder';
                $obj['responder_type'] = 'default';
                $obj['api_id'] = 0;
                $obj['target'] = 0;
                
                $input = JFactory::getApplication()->input;
                
                $this->items[] = $obj;
                
                $this->tagsList = $this->get('TagsList');
                
                $campaignModel = JModelLegacy::getInstance('Campaigns', 'MarketingrocketModel');
                
                $this->campaignsList = $campaignModel->getCampaignList();
                
                $this->landingList = $campaignModel->getLandingsList();
                
                $this->defResponderList = $campaignModel->getRespondersList();
                
                $this->responderApiList = $this->get('ResponderApiList');
                
                $this->campaign_id = JFactory::getApplication()->input->getInt('campaing_id');
                
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
                
                $this->document->addStyleSheet (JUri::root(true).'/components/com_marketingrocket/assets/css/jquery-ui-1.10.4.custom.min.css' );
                $this->document->addScript ( JUri::root(true) . '/components/com_marketingrocket/assets/js/jquery-ui-1.10.4.custom.min.js', "text/javascript" , true );
                
                
                $this->document->addStyleSheet (JUri::base() . '/components/com_marketingrocket/assets/css/dashboard.css' );

		$this->addToolbar();
                
                $this->type = 'landing_action';
                
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{

		JFactory::getApplication()->input->set('hidemainmenu', true);

		$user		= JFactory::getUser();
		// Since we don't track these assets at the item level, use the category id.

//		JToolbarHelper::title(JText::_('COM_MARKETINGROCKET_MANAGE_SEQUENCES'), '');

	}
}
