<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
if(isset($this))
    $list = $this;
if(isset($list->groupBy))
    $gruopBy = $list->groupBy;
else 
    $gruopBy = 'd';
?>
<div class="row-fluid dashboard" style="margin-top: 15px">
        <div class="dashboard-box text-center span2">
            <h2><?php echo $list->totalView ?></h2>
            <span><?php echo JText::_('COM_MARKETINGROCKET_PAGE_VIEWS') ?></span>
            <div class="box-footer">
                <?php 
                $cssClass = 'fa-minus';
                if(isset($list->prevMonthStat->visits) && $list->prevMonthStat->visits > $list->totalView){
                    $cssClass = 'fa-arrow-down';
                }
                else if(isset($list->prevMonthStat->visits) && $list->prevMonthStat->visits < $list->totalView){
                    $cssClass = 'fa-arrow-up';
                }
                if(isset($list->prevMonthStat->visits)){
                    $visits = $list->prevMonthStat->visits;
                    if(empty($visits))
                       $visits = 0;
                }
                else 
                    $visits = 0;
                
                ?>
                <i class="fa <?php echo $cssClass ?>"></i>
                <?php echo sprintf(JText::_('COM_MARKETINGROCKET_PREVIOUS_MONTH'), $visits) ?>
            </div>
        </div>
        <div class="dashboard-box text-center span2">
            <h2><?php echo $list->totalSubmission ?></h2>
            <span><?php echo JText::_('COM_MARKETINGROCKET_LEADS') ?></span>
            <div class="box-footer">
                <?php 
                $cssClass = 'fa-minus';
                if(isset($list->prevMonthStat->submissions) && $list->prevMonthStat->submissions > $list->totalSubmission){
                    $cssClass = 'fa-arrow-down';
                }
                else if(isset($list->prevMonthStat->submissions) && $list->prevMonthStat->submissions < $list->totalSubmission){
                    $cssClass = 'fa-arrow-up';
                }
                if(isset($list->prevMonthStat->submissions)){
                    $submissions = $list->prevMonthStat->submissions;
                    if(empty($submissions))
                        $submissions = 0;
                }
                else {
                    $submissions = 0;
                }
                
                ?>
                <i class="fa <?php echo $cssClass ?>"></i>
                <?php echo sprintf(JText::_('COM_MARKETINGROCKET_PREVIOUS_MONTH'), $submissions) ?>
            </div>
        </div>
        
        <div class="dashboard-box text-center span2">
            <h2><?php  
            $rate = 0;
            if($list->totalSubmission > 0){
                $rate = round(($list->totalSubmission/$list->totalView)*100, 2);
            }
            echo $rate ?>% </h2>
            <span><?php echo JText::_('COM_MARKETINGROCKET_VIEW_CONVERSION') ?></span>
            <div class="box-footer">
                <?php 
                $cssClass = 'fa-minus';
                $prevRate = 0;
                if(isset($list->prevMonthStat->submissions) && $list->prevMonthStat->submissions > 0){
                    $prevRate = round(($list->prevMonthStat->submissions/$list->prevMonthStat->visits)*100, 2);
                }
                if($prevRate > $rate){
                    $cssClass = 'fa-arrow-down';
                }
                else if($prevRate < $rate){
                    $cssClass = 'fa-arrow-up';
                }
                ?>
                <i class="fa <?php echo $cssClass ?>"></i>
                <?php echo sprintf(JText::_('COM_MARKETINGROCKET_PREVIOUS_MONTH'), $prevRate.'%') ?>
            </div>
        </div>
        
        <div class="dashboard-box text-center span2">
            <h2><?php echo $list->convertedCount ?></h2>
            <span><?php echo JText::_('COM_MARKETINGROCKET_PURCHASES') ?></span>
            <div class="box-footer">
                <?php 
                $cssClass = 'fa-minus';
                if($list->prevMonthConverted > $list->convertedCount){
                    $cssClass = 'fa-arrow-down';
                }
                else if($list->prevMonthConverted < $list->convertedCount){
                    $cssClass = 'fa-arrow-up';
                }
                ?>
                <i class="fa <?php echo $cssClass ?>"></i>
                <?php echo sprintf(JText::_('COM_MARKETINGROCKET_PREVIOUS_MONTH'), $list->prevMonthConverted) ?>
            </div>
        </div>
        
        <div class="dashboard-box text-center span2">
            <h2><?php  
            $rate = 0;
            if($list->convertedCount > 0){
                $rate = round(($list->convertedCount/$list->totalView)*100, 2);
            }
            echo $rate ?>% </h2>
            <span><?php echo JText::_('COM_MARKETINGROCKET_VIEW_TO_CUSTOMERS') ?></span>
            <div class="box-footer">
                <?php 
                $cssClass = 'fa-minus';
                $prevRate = 0;
                if($list->prevMonthConverted > 0){
                    $prevRate = round(($list->prevMonthConverted/$list->prevMonthStat->visits)*100, 2);
                }
                if($prevRate > $rate){
                    $cssClass = 'fa-arrow-down';
                }
                else if($prevRate < $rate){
                    $cssClass = 'fa-arrow-up';
                }
                ?>
                <i class="fa <?php echo $cssClass ?>"></i>
                <?php echo sprintf(JText::_('COM_MARKETINGROCKET_PREVIOUS_MONTH'), $prevRate.'%') ?>
            </div>
        </div>
    </div>
<?php if(empty($hideChart) && (!isset($this) || empty($this->hideChart))): ?>
    <div id="chart"></div>

<script type="text/javascript">
     jQuery(function () {
        jQuery('#chart').highcharts({
            chart: {
                type: 'line'
            },
            title: {
                text: 'Daily Page Views Vs.Leads'
            },

            xAxis: {
                 type: 'datetime',
//                 tickInterval: <?php 
                    if($list->endTime - $list->time > 2592000)
                        echo (7 * 24 * 3600 * 1000); // one week
                    else 
                        echo 'null'; // daily week
                ?>//,
                tickWidth: 0,
                gridLineWidth: 1,
                labels: {
                    align: 'left',
                    x: 3,
                    y: 20
                }
            },
            
            credits: {
                enabled: false
            },
            yAxis: {
                min: 0,
                title: {
                    text: '',
                    align: 'high'
                },
                labels: {
                    overflow: 'justify'
                }
            },
            tooltip: {
                shared: true,
                crosshairs: true
            },
            plotOptions: {
                bar: {
                    dataLabels: {
                        enabled: true
                    }
                }
            },
            legend: {
                layout: 'horizontal',
                align: 'right',
                verticalAlign: 'top',
                x: -40,
                y: 0,
                floating: true,
                borderWidth: 1,
                backgroundColor: '#FFFFFF',
                shadow: true
            },
            series: [{
                name: 'Page Views',
                pointInterval: <?php 
                    switch ($gruopBy){
                        case 'd' :
                            echo 24*3600 * 1000;
                            break;
                        case 'W' :
                            echo 7*24*3600 * 1000;
                            break;
                        case 'm' :
                            echo 30*24*3600 * 1000;
                            break;
                    }
                    
                ?>,
                 pointStart: <?php
                    switch ($gruopBy){
                        case 'd' :
                            ?> Date.UTC(<?php echo date('Y', $list->time) ?>, <?php echo date('m', $list->time)-1 ?>, <?php echo date('d', $list->time) ?>, 0, 0, 0, 0) <?php
                            break;
                        case 'W' :
                            $StartTimeJs = strtotime('last monday', $list->time);
                            ?> Date.UTC(<?php echo date('Y', $StartTimeJs) ?>, <?php echo date('m', $StartTimeJs)-1 ?>, <?php echo date('d', $StartTimeJs) ?>, 0, 0, 0, 0)  <?php 
                            break;
                        case 'm' :
                            $StartTimeJs = strtotime('first day of this month', $list->time);
                            ?> Date.UTC(<?php echo date('Y', $StartTimeJs) ?>, <?php echo date('m', $StartTimeJs)-1 ?>, <?php echo date('d', $StartTimeJs) ?>, 0, 0, 0, 0)  <?php                  
                            break;
                    }
                
                
                ?>,
                lineWidth: 4,
                marker: {
                    radius: 4
                },
                data: [<?php 
                $sep = '';
                $time = $list->time;
                $lastRowDateG = date($gruopBy, $time);
                $currentCount = 0;
                $flushed = false;
                while ($time <= $list->endTime){
                	$date =date('Y-m-d', $time);
                        $rowG = date($gruopBy, $time);
                        if($rowG != $lastRowDateG){
//                            echo ' '.$date.'<br />';die;
                            $lastRowDateG = date($gruopBy, $time);
                            echo $sep.$currentCount;
                            $currentCount = 0;
                            $sep = ',';
                            $flushed = true;
                        }
                        
                	if(empty($list->hideChart) || !empty($list->stats[$date]))
                	{
                           
                            if(!empty($list->stats[$date])){
                                 $flushed = false;
                                 $currentCount += $list->stats[$date]->visits;
                            }
                	}
                        
                	
                	$time = $time+86400;
               }
               if($flushed === false)
                    echo $sep.$currentCount;
               ?>]
            }, {
                name: 'Leads',
                pointInterval: <?php 
                    switch ($gruopBy){
                        case 'd' :
                            echo 24*3600 * 1000;
                            break;
                        case 'W' :
                            echo 7*24*3600 * 1000;
                            break;
                        case 'm' :
                            echo 30*24*3600 * 1000;
                            break;
                    }
                    
                ?>,
                pointStart: <?php
                    switch ($gruopBy){
                        case 'd' :
                            ?> Date.UTC(<?php echo date('Y', $list->time) ?>, <?php echo date('m', $list->time)-1 ?>, <?php echo date('d', $list->time) ?>, 0, 0, 0, 0) <?php
                            break;
                        case 'W' :
                            $StartTimeJs = strtotime('last monday', $list->time);
                            ?> Date.UTC(<?php echo date('Y', $StartTimeJs) ?>, <?php echo date('m', $StartTimeJs)-1 ?>, <?php echo date('d', $StartTimeJs) ?>, 0, 0, 0, 0)  <?php 
                            break;
                        case 'm' :
                            $StartTimeJs = strtotime('first day of this month', $list->time);
                            ?> Date.UTC(<?php echo date('Y', $StartTimeJs) ?>, <?php echo date('m', $StartTimeJs)-1 ?>, <?php echo date('d', $StartTimeJs) ?>, 0, 0, 0, 0)  <?php                  
                            break;
                    }
                
                
                ?>,
                data: [<?php 
                $sep = '';
                $time = $list->time;
                $lastRowDateG = date($gruopBy, $time);
                $currentCount = 0;
                $flushed = false;
                while ($time <= $list->endTime){
                	$date =date('Y-m-d', $time);
                        $rowG = date($gruopBy, $time);
                        if($rowG != $lastRowDateG){
                             $lastRowDateG = date($gruopBy, $time);
                            echo $sep.$currentCount;
                            $currentCount = 0;
                            $sep = ',';
                            $flushed = true;
                        }
                	if(empty($list->hideChart) || !empty($list->stats[$date]))
                	{
                             
                             if(!empty($list->stats[$date])){
                                $flushed = false;
                                $currentCount += $list->stats[$date]->submissions;
                             }
                	}
                        
                	
                	$time = $time+86400;
               }
               if($flushed === false)
                    echo $sep.$currentCount;
               ?>]
            }],
            colors: [
				'#3465cc',
				'#dd3711'
			]
        });
    });
</script>
<?php endif; ?>