<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;
require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_marketingrocket'.DS.'helpers'.DS.'marketingrocket.php';
$versionNumber = MarketingrocketHelper::getVersion();
if(!isset($dashBoardLogo))
    $dashBoardLogo = $this->dashBoardLogo;

$date = JFactory::getDate('now', JFactory::getConfig()->get('offset'));
$date->modify('+1 day');
$db = JFactory::getDbo();
$q = $db->getQuery(true);
$q->select('COUNT(a.id)')->from($db->qn('#__mrocket_leads_cron', 'a'))
        ->innerJoin($db->qn('#__mrocket_leads', 'b').' ON a.lead_id = b.id')
        ->where('b.is_temp = 0')
        ->where('a.is_done = 0')
        ->where('a.cron_date < '.$db->q($date->toSql()))
        ->innerJoin($db->qn('#__mrocket_responder_templates', 'c').' ON '.$db->qn('a.responder_id').' = '.$db->qn('c.id'))
        ->leftJoin($db->qn('#__mrocket_reponders_sequences', 'd').' ON '.$db->qn('c.sequence_id').' = '.$db->qn('d.id'))
        ->where($db->qn('c.published').' = 1')
        ;
$db->setQuery($q);
$cronLeftCount = $db->loadResult();

$date = JFactory::getDate('now', JFactory::getConfig()->get('offset'));

        if(isset($this) || $params->get('show_buttons', 1) == 1):
?>
        <div class="row-fluid">
            <div class="span3">
                <span>
                    <b>Version: </b><?php echo $versionNumber ?>
                </span>
            </div>
            <div class="span6" style="text-align:center;">
                <a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=queueds') ?>"><?php echo JText::plural('COM_MARKETINGROCKET_CRON_COUNT', $cronLeftCount) ?></a>
            </div>
            <div class="span3 hasTooltip text-right" title="<?php echo JText::_('COM_MARKETINGROCKET_TIME_TOOLTIP') ?>">
                <b><?php echo JText::_('COM_MARKETINGROCKET_DATE_AND_TIME') ?>: </b><?php echo $date->calendar(JText::_('DATE_FORMAT_LC2'), true);  ?>
            </div>
        </div>
	 <div class="top-nav row-fluid dashboard">
             <div class="span3" >
                <a href="<?php echo JRoute::_('index.php?option=com_marketingrocket') ?>" style="position: relative;display : block;">
                    <img src="../<?php echo $dashBoardLogo ?>" class="MR-logo" />
                    
                </a>
                
            </div>
            <ul class="dash-button-holder span9">
                <li>
                    <a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=wizard') ?>">
                        <i class="fa fa-magic"></i>
                        <span><?php echo JText::_('COM_MARKETINGROCKET_WIZARD') ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=landings') ?>">
                        <i class="fa fa-file-text-o"></i>
                        <span><?php echo JText::_('COM_MARKETINGROCKET_PAGES') ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=responders') ?>">
                        <i class="fa fa-pencil-square-o"></i>
                        <span><?php echo JText::_('COM_MARKETINGROCKET_EMAILS') ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=leads') ?>">
                        <i class="fa fa-users"></i>
                        <span><?php echo JText::_('COM_MARKETINGROCKET_LEADS') ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?php echo JRoute::_('index.php?option=com_marketingrocket&view=reports') ?>">
                        <i class="fa fa-bar-chart"></i>
                        <span><?php echo JText::_('COM_MARKETINGROCKET_DASHBOARD_REPORTS') ?></span>
                    </a>
                </li>
                <li>
                    <a id="show_message">
                        <i class="fa fa-envelope-o"></i>
                        <span><?php echo JText::_('COM_MARKETINGROCKET_MESSAGES') ?></span>
                        <span class="notification-holder hide">2</span>
                    </a>
                </li>
                <li>
                    <a href="https://marketing-rocket.com/documentation/" target="_blank">
                        <i class="fa fa-question-circle"></i>
                        <span><?php echo JText::_('COM_MARKETINGROCKET_HELP') ?></span>
                    </a>
                </li>
                <li>
                    <a class="" id="update_holder" href="<?php echo JRoute::_('index.php?option=com_installer&view=update') ?>">
                        <i class="fa fa-cloud-download"></i>
                        <span><?php echo JText::_('COM_MARKETINGROCKET_UPDATE') ?></span>
                    </a>
                </li>
            </ul>
        </div>
        <?php 
        endif;
            if(isset($this)){
                echo $this->loadTemplate('stat'); 
                echo $this->loadTemplate('toplanding');
            }
            else {
                if($params->get('show_chart', 1) == 1)
                    require 'default_stat.php';
                 if($params->get('show_toplanding', 0) == 1)
                    require 'default_toplanding.php';
            }
        ?>
	
        <div class="modal hide fade" id="update_modal">
            <div class="modal-body" style="overflow-y: scroll;">
                <p style="margin: 10px;"></p>
            </div>
            <div class="modal-footer">
                <a class="btn btn-primary" id="read_all_btn"><?php echo JText::_('COM_MARKETINGROCKET_READ_ALL') ?></a>
                <a class="btn btn-danger" id="delete_all_btn"><?php echo JText::_('COM_MARKETINGROCKET_DELETE_ALL') ?></a>
                <a href="#" class="btn" data-dismiss="modal">Close</a>
            </div>
        </div>
<div id="read_more_holder" style="display: none">
            <div class="row-fluid"><div style="padding: 15px 0 15px 9px;"><a id="show-more" class="btn btn-block btn-large btn-primary"><?php echo JText::_('COM_MARKETINGROCKET_LOAD_MORE') ?></a><a id="btn-loading-holder" class="btn btn-block btn-large btn-primary btn-disabled" style="display: none"><div class="spinner "><div class="rect1"></div><div class="rect2"></div><div class="rect3"></div><div class="rect4"></div><div class="rect5"></div></div></a></div></div>
        </div>
<div id="accordion_message_holder" style="display: none">
    <div class="accordion" id="accordion_message" style="margin : 0px 5px"></div>
</div>
<div id="accordion_message_group_holder" style="display: none">
    <div class="accordion-group"><div class="accordion-heading"><a class="accordion-toggle" data-toggle="collapse" data-parent="accordion_message" ></a><div class="accordion-body collapse"><div class="accordion-inner"></div></div></div>
</div>

	<script type="text/javascript">
            var page = 1;
            var perPage = 50;
            var readMoreTemplate = jQuery('#read_more_holder > div').clone();
            var accordionMessageTemplate = jQuery('#accordion_message_holder > div').clone();
            var accordionMessageGroupTemplate = jQuery('#accordion_message_group_holder > div').clone();
            var ajaxSent = false;
            jQuery(document).ready(function($){
                if(ajaxSent)
                    return;
                ajaxSent = true;
                jQuery.ajax({
                        url: 'index.php?option=com_marketingrocket&view=dashboard&task=dashboard.notice',
                       
                        dataType : 'json'
                }).done(function(res){
                    var $ = jQuery;
                    j = res;
                    var unreadCount = 0;
                    var html = $(accordionMessageTemplate);
                    
                    var ret = createView(html, j.data);
                    html = ret[0];
                    unreadCount = ret[1];
                    
                    
                    
                    if(unreadCount){
                        jQuery('.notification-holder').removeClass('hide').html(unreadCount);
                    }
                    
                    jQuery('#update_modal').find('.modal-body').html(html);
                    
                    if(j.data.length == perPage){
                        var readMore = $(readMoreTemplate);
                        jQuery('#update_modal').find('.modal-body').append(readMore);
                        $('#show-more').click(function(){
                            $(this).hide();
                            $(this).next().show();

                            $.ajax({
                                url: 'index.php?option=com_marketingrocket&view=dashboard&task=dashboard.notice',
                                data : {page : page},
                                method : 'POST',
                                dataType : 'json',
                            }).done(function(res){
                                page++;
                                var localReturn = createView($('#accordion_message'), res.data);
                                $('#btn-loading-holder').hide();
//                                $(ret[0]).insertBefore($('#show-more').parent());
                                
                                if(res.data.length == perPage)
                                    $('#show-more').show();

                            });
                        });
                    }
                    
                    jQuery('#show_message').unbind('click').click(function(){
                        jQuery('#update_modal').modal('show');
                            
                        jQuery('#update_modal').find('a.accordion-toggle.bold').unbind('click').click(function(){
                            if($(this).hasClass('bold')){
                                $(this).removeClass('bold');
                                var val = parseInt($('.notification-holder').text());
                                val--;
                                if(val > 0)
                                    $('.notification-holder').text(val);
                                else 
                                    $('.notification-holder').hide();
                                 $.ajax({
                                     url: 'index.php?option=com_marketingrocket&view=dashboard&task=dashboard.mark',
                                     method : 'POST',
                                     data : {id : $(this).data('id') , '<?php echo JSession::getFormToken() ?>' : 1}
                                 });
                            }
                        })
                    });
                    if(location.hash == '#show_popup'){
                        jQuery('#show_message').click();
                    }
                    
                });
                jQuery.ajax({
                        url :  'index.php?option=com_installer&view=update&task=update.ajax&eid=0&skip=700&<?php echo JSession::getFormToken() ?>=1',
                        dataType : 'json'

                }).done(function(res){
                    for(var i = 0;i < res.length;i++){
                        var row = res[i];
                        if(row.element === 'pkg_marketingrocket'){
                            jQuery('#update_holder').addClass('brighterupdate');
                            jQuery('#update_holder').addClass('highlight');
                            window.setInterval(function(res){
                                // 'highlight' class is toggled in 'update holder id' between the interval of 500 ms
                                jQuery('#update_holder').toggleClass('highlight');
                            }, 1500);
                        }
                    }
                });
                $('#read_all_btn').click(function () {
                    $.ajax({
                        url: 'index.php?option=com_marketingrocket&view=dashboard&task=dashboard.markAll',
                        method : 'POST',
                        data : {'<?php echo JSession::getFormToken() ?>' : 1}
                    });
                    $('.notification-holder').hide();
                });
                $('#delete_all_btn').click(function () {
                    var b = confirm("<?php echo JText::_('COM_MARKETINGROCKET_ARE_YOUR_SURE_ABOUT_DELETE_THIS_ITEMS', true) ?>");
                    if(b){
                        $.ajax({
                            url: 'index.php?option=com_marketingrocket&view=dashboard&task=dashboard.deleteall',
                            method : 'POST',
                            data : {'<?php echo JSession::getFormToken() ?>' : 1}
                        });
                        $('#accordion_message').html('');
                        jQuery('#update_modal').modal('hide');
                        $('.notification-holder').hide();
                    }
                })
            });
            var createView = function(html, data){
                var $ = jQuery;
                var unreadCount = 0;
                for(var i = 0;i < data.length;i++){
                    var obj = data[i];
                    if(obj.read_status == 0)
                        unreadCount++;

                    var rowHtml = accordionMessageGroupTemplate.clone();
                    var a = rowHtml.find('a:first');
                    var body = rowHtml.find('.accordion-body');
                    var inner = body.find('.accordion-inner');
                    a.text(obj.title).css('border', '0px');
                    if(obj.read_status == 0){
                        a.addClass('bold');
                    }
                    a.attr('href', '#news-'+obj.id).attr('data-id', obj.id);

                    body.attr('id', 'news-'+obj.id);

                    inner.html(obj.description).css('padding', '9px 15px');
                    if(obj.is_system == 1){
                        inner.append('<hr />').append('<small>'+obj.created+'</small>');
                    }
//                        if(i == 0)
//                            body.addClass('in');
                    html.append(rowHtml);
                }
                return [html, unreadCount];
            }
	</script>