<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketTableTemp extends JTable
{
	
	public $token;
	/**
	 * Constructor
	 *
	 * @param JDatabaseDriver A database connector object
	 */
	public function __construct(&$db)
	{
		parent::__construct('#__mrocket_temp', 'id', $db);
	}


	public function store($updateNulls = false)
	{
            
            if(in_array(JFactory::getApplication()->input->post->get('task'), array('landing.savepreview', 'landing.autosave'))){
                $db = $this->getDbo();
                $query = $db->getQuery(true);
                $query->delete('#__mrocket_temp');
                
                if(JFactory::getApplication()->input->post->get('task') == 'landing.savepreview'){
                     $query->where($db->qn('save_type').' = '.$db->q('preview'));
                }
                else if(JFactory::getApplication()->input->post->get('task') == 'landing.autosave'){
                    $query->where($db->qn('save_type').' = '.$db->q('auto'))
                        ->where($db->qn('landing_id').' = '.$db->q($this->landing_id));
                        ;
                }

                $db->setQuery($query)->execute();
            }
            
		
            unset($this->id);
            
            $date	= JFactory::getDate();
            $this->created = $date->toSql();
            
            $resualt = parent::store($updateNulls);

            // Attempt to store the user data.
            return $resualt;
	}

	public function getToken(){
		
		return $this->token;
	}
	
	/**
	 * Overloaded check method to ensure data integrity.
	 *
	 * @return  boolean  True on success.
	 */
	public function check()
	{

		if($this->is_split == '1')
			return true;
		
		if(empty($this->alias)){
			if(!empty($this->seo_title))
				$this->alias = $this->seo_title;
			else 
				$this->alias = $this->title;
		}
		$this->alias = JApplication::stringURLSafe($this->alias);


		// check for user limitaion
		

		// check that alias is not taken
		$i = '';
		$alias = $this->alias;
		do {
			$this->alias = $alias.$i;
			$query = 'SELECT id FROM #__mrocket_landings WHERE alias = '.$this->_db->quote($this->alias);
			if(empty($i))
				$i = 0;
			$i = $i+1;
			$this->_db->setQuery($query);

			$xid = (int) $this->_db->loadResult();
		}while ($xid && $xid != (int) $this->id);
		
		
		

		return true;
	}

	public function delete($pk = null)
	{
		// select user_id first


		$row = $this->load($pk, true);
		if(!$row)
			return false;
	
		$result = parent::delete($pk);

		return $result;
	}


}
