<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

/**
 * @property int $id
 * @property int $lead_id
 * @property int $tag_id
 * @property int $campaign_id
 *
 * Class MarketingrocketTableLeadtag
 */
class MarketingrocketTableLeadtag extends JTable
{

    public static $field_id = 'id';
    public static $field_lead_id = 'lead_id';
    public static $field_tag_id = 'tag_id';
    public static $field_campaign_id = 'campaign_id';

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return int
     */
    public function getLeadId()
    {
        return $this->lead_id;
    }

    /**
     * @param int $lead_id
     */
    public function setLeadId($lead_id)
    {
        $this->lead_id = $lead_id;
    }

    /**
     * @return int
     */
    public function getTagId()
    {
        return $this->tag_id;
    }

    /**
     * @param int $tag_id
     */
    public function setTagId($tag_id)
    {
        $this->tag_id = $tag_id;
    }

    /**
     * @return int
     */
    public function getCampaignId()
    {
        return $this->campaign_id;
    }

    /**
     * @param int $campaign_id
     */
    public function setCampaignId($campaign_id)
    {
        $this->campaign_id = $campaign_id;
    }

	/**
	 * Constructor
	 *
	 * @param JDatabaseDriver A database connector object
	 */
	public function __construct(&$db)
	{
		parent::__construct('#__mrocket_leads_tags', 'id', $db);
	}

	/**
	 * Overloaded check method to ensure data integrity.
	 *
	 * @return  boolean  True on success.
	 */
        
        public function check() {
            $table = JTable::getInstance('Leadtag', 'MarketingrocketTable');
            $table->load(array('lead_id' => $this->lead_id, 'tag_id' => $this->tag_id, 'campaign_id' => $this->campaign_id));
            if(!empty($table->id) && $table->id != $this->id){
                return false;
            }
            return true;
        }
        
        public function store($updateNulls = false)
	{
            $isNew = true;
            if(!empty($this->id))
                $isNew = false;
            
            $ret = parent::store($updateNulls);

            if($ret && $isNew){
                require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'marketingrocket.php';
                
                JTable::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables');
                $tagTable = JTable::getInstance('Tag', 'MarketingrocketTable');
                $tagTable->load($this->tag_id);
                
                if(!empty($this->campaign_id)){
                    $campaingTable = JTable::getInstance('Campaign', 'MarketingrocketTable');
                    $campaingTable->load($this->campaign_id);
                    $campaignName = $campaingTable->name;
                }
                else {
                    $campaignName = '-';
                }
                
                $text = JText::sprintf(
                    'COM_MARKETINGROCKET_LOG_ADD_TAG',
                    $tagTable->title,
                    $campaignName
                );
                
                MarketingrocketHelper::log('tag', 'add', $text, $this->lead_id, $this->tag_id, '#__mrocket_tags');
                
                require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'action.php';
                $actionModel = JModelLegacy::getInstance('Action', 'MarketingrocketModel');
                
                $items = $actionModel->getActiveActions();
                $lead = JTable::getInstance('lead', 'MarketingrocketTable');
                $lead->load($this->lead_id);
                
                //require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'landing.php';
                $ladningModel = JModelLegacy::getInstance('Landing', 'MarketingrocketModel');
                foreach ($items as $item){
                   if($ladningModel->actionConditionCheck($lead, $item) == true){
                        $ladningModel->_handleAction($item , $lead);
                    } 
                }
            }
            
            return $ret;
        }
        public function delete($pk = null)
	{
            $ret = parent::delete($pk);
            if($ret){
                require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'marketingrocket.php';
                
                JTable::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables');
                $tagTable = JTable::getInstance('Tag', 'MarketingrocketTable');
                $tagTable->load($this->tag_id);
                
                if(!empty($this->campaign_id)){
                    $campaingTable = JTable::getInstance('Campaign', 'MarketingrocketTable');
                    $campaingTable->load($this->campaign_id);
                    $campaignName = $campaingTable->name;
                }
                else {
                    $campaignName = '-';
                }
                
                $text = JText::sprintf(
                    'COM_MARKETINGROCKET_LOG_DELETE_TAG',
                    $tagTable->title,
                    $campaignName
                );
                
                MarketingrocketHelper::log('tag', 'delete', $text, $this->lead_id, $this->tag_id, '#__mrocket_tegs');
                
                require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'action.php';
                $actionModel = JModelLegacy::getInstance('Action', 'MarketingrocketModel');
                
                $items = $actionModel->getActiveActions();
                
                $lead = JTable::getInstance('lead', 'MarketingrocketTable');
                $lead->load($this->lead_id);
                require_once JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'landing.php';
                $ladningModel = JModelLegacy::getInstance('Landing', 'MarketingrocketModel');
                
                foreach ($items as $item){
                   if($ladningModel->actionConditionCheck($lead, $item) == true){
                        $item = (object)$item;
                        $ladningModel->_handleAction($item , $lead);
                    } 
                }
                
            }
        }


}
