<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketTableLeadstatus extends JTable
{
	/**
	 * Constructor
	 *
	 * @param JDatabaseDriver A database connector object
	 */
	public function __construct(&$db)
	{
		parent::__construct('#__mrocket_lead_statuses', 'id', $db);
	}
        
        public function check() {
            $table = JTable::getInstance('Leadstatus', 'MarketingrocketTable');
            $table->load(array(
                    'lead_id' => $this->lead_id,
                    'campaign_id' => $this->campaign_id
                )
            );
            if(!empty($table->id)){
                if(empty($this->id))
                    return false;
                if($this->id != $table->id)
                    return false;
            }
            return true;
        }
        
        public function store($updateNulls = false) {
            
            $ret = parent::store($updateNulls);
            
            
            if($ret){
                require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'marketingrocket.php';
                
                JTable::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables');
                $statusTable = JTable::getInstance('Status', 'MarketingrocketTable');
                $statusTable->load($this->status_id);
                
                if(!empty($this->campaign_id)){
                    $campaingTable = JTable::getInstance('Campaign', 'MarketingrocketTable');
                    $campaingTable->load($this->campaign_id);
                    $campaignName = $campaingTable->name;
                }
                else {
                    $campaignName = '-';
                }
                
                $text = JText::sprintf(
                    'COM_MARKETINGROCKET_LOG_ADD_STATUS',
                    $statusTable->name,
                    $campaignName
                );
                
                MarketingrocketHelper::log('status', 'add', $text, $this->lead_id, $this->status_id, '#__mrocket_statuses');
                
                if($statusTable->final){
                    $text = JText::_('COM_MARKETINGROCKET_LOG_LEAD_CONVERTED');

                    MarketingrocketHelper::log('status', 'convert', $text, $this->lead_id, $this->status_id, '#__mrocket_statuses');
                }
            }
            return $ret;
           
        }
        
        public function delete($pk = null)
	{
            $ret = parent::delete($pk);
            if($ret){
                require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'marketingrocket.php';
                
                JTable::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables');
                $statusTable = JTable::getInstance('Status', 'MarketingrocketTable');
                $statusTable->load($this->status_id);
                
                if(!empty($this->campaign_id)){
                    $campaingTable = JTable::getInstance('Campaign', 'MarketingrocketTable');
                    $campaingTable->load($this->campaign_id);
                    $campaignName = $campaingTable->name;
                }
                else {
                    $campaignName = '-';
                }
                
                $text = JText::sprintf(
                    'COM_MARKETINGROCKET_LOG_DELETE_STATUS',
                    $statusTable->name,
                    $campaignName
                );
                
                MarketingrocketHelper::log('status', 'delete', $text, $this->lead_id, $this->status_id, '#__mrocket_statuses');
                
            }
        }


}
