<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketTableLeadcrons extends JTable
{
	/**
	 * Constructor
	 *
	 * @param JDatabaseDriver A database connector object
	 */
	public function __construct(&$db)
	{
		parent::__construct('#__mrocket_leads_cron', 'id', $db);
	}
        
        public function check() {
            
            $lead = JTable::getInstance('Lead', 'MarketingrocketTable');
            $lead->load($this->lead_id);
            if($lead->recieve_email == '0')
                return false;
            
            $table = JTable::getInstance('Leadcrons', 'MarketingrocketTable');
            $table->load(array(
                    'lead_id' => $this->lead_id,
                    'responder_id' => $this->responder_id,
                    'is_done' => 0,
                )
            );
            if(!empty($table->id)){
                if(empty($this->id))
                    return false;
                if($this->id != $table->id)
                    return false;
            }
            return true;
        }
        
         public function store($updateNulls = false)
	{
            $isNew = true;
            if(!empty($this->id)){
                $isNew = false;
                
                $date	= JFactory::getDate();
                $this->modified = $date->toSql();
                
                $row = JTable::getInstance('Leadcrons','MarketingrocketTable');
                $row->load($this->id);
            }
            
            $ret = parent::store($updateNulls);
            if($ret && $isNew){
                require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'marketingrocket.php';
                
                
                $responderTable = JTable::getInstance('Responder', 'MarketingrocketTable');
                $responderTable->load($this->responder_id);
                
                $text = JText::sprintf(
                    'COM_MARKETINGROCKET_LOG_RESPONDER_ADD',
                    $responderTable->name
                );
                
                MarketingrocketHelper::log('responder', 'add', $text, $this->lead_id, $this->responder_id, '#__mrocket_responder_templates');
            }
            else if($ret){
                require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'marketingrocket.php';
                
                
                $responderTable = JTable::getInstance('Responder', 'MarketingrocketTable');
                $responderTable->load($this->responder_id);
                
                
                if($this->is_done != $row->is_done){
                    $text = JText::sprintf(
                        'COM_MARKETINGROCKET_LOG_RESPONDER_SENT',
                        $responderTable->name
                    );

                    MarketingrocketHelper::log('responder', 'sent', $text, $this->lead_id, $this->responder_id, '#__mrocket_responder_templates');
                }
                if($this->is_show != $row->is_show){
                    $text = JText::sprintf(
                        'COM_MARKETINGROCKET_LOG_RESPONDER_OPENED',
                        $responderTable->name
                    );

                    MarketingrocketHelper::log('responder', 'open', $text, $this->lead_id, $this->responder_id, '#__mrocket_responder_templates');
                }
                
                if($this->is_clicked != $row->is_clicked){
                    $text = JText::sprintf(
                        'COM_MARKETINGROCKET_LOG_RESPONDER_CLICKED',
                        $responderTable->name
                    );

                    MarketingrocketHelper::log('responder', 'click', $text, $this->lead_id, $this->responder_id, '#__mrocket_responder_templates');
                }
                
                
            }
            return $ret;
        }
        public function delete($pk = null)
	{
            $ret = parent::delete($pk);
            if($ret){
                require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'marketingrocket.php';
                
                JTable::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables');
                $responderTable = JTable::getInstance('Responder', 'MarketingrocketTable');
                $responderTable->load($this->responder_id);
                
                $text = JText::sprintf(
                    'COM_MARKETINGROCKET_LOG_RESPONDER_DELETE',
                    $responderTable->name
                );
                
                MarketingrocketHelper::log('responder', 'delete', $text, $this->lead_id, $this->responder_id, '#__mrocket_responder_templates');
                
            }
            return $ret;
        }
        
        
        


}
