<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

class MarketingrocketTableLeadcampaign extends JTable
{
	/**
	 * Constructor
	 *
	 * @param JDatabaseDriver A database connector object
	 */
	public function __construct(&$db)
	{
		parent::__construct('#__mrocket_lead_campaigns', 'id', $db);
	}
        
        public function check() {
            
            if(empty($this->campaign_id) || empty($this->lead_id))
                return false;
            
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            $q->select('*')->from($db->qn('#__mrocket_lead_campaigns'))
                    ->where($db->qn('lead_id').' = '.$db->q($this->lead_id))
                    ->where($db->qn('campaign_id').' = '.$db->q($this->campaign_id))
            ;
            $db->setQuery($q);
            $res = $db->loadObject();
            
            if(!empty($res)){
                return false;
            }
            return true;
        }
        
        public function store($updateNulls = false)
	{
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            $q->insert('#__mrocket_lead_campaigns')
                    ->set($db->qn('lead_id') . ' = '.$this->lead_id)
                    ->set($db->qn('campaign_id') . ' = '.$this->campaign_id);
            
            $db->setQuery($q);
            $db->execute();
            require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'marketingrocket.php';


            $campaignTable = JTable::getInstance('Campaign', 'MarketingrocketTable');
            $campaignTable->load($this->campaign_id);

            $text = JText::sprintf(
                'COM_MARKETINGROCKET_LOG_CAMPAIGN_ADD',
                $campaignTable->name
            );

            MarketingrocketHelper::log('campaign', 'subscribe', $text, $this->lead_id, $this->campaign_id, '#__mrocket_campaign');
        }
        public function delete($pk = null)
	{
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            $q->select('*')->from($db->qn('#__mrocket_lead_campaigns'))
                    ->where($db->qn('lead_id').' = '.$db->q($this->lead_id))
                    ->where($db->qn('campaign_id').' = '.$db->q($this->campaign_id))
            ;
            $db->setQuery($q);
            $res = $db->loadObject();
            if(empty($res)){
                return false;
            }
            
            $q = $db->getQuery(true);
            $q->delete('#__mrocket_lead_campaigns')
                    ->where($db->qn('lead_id') . ' = '.$this->lead_id)
                    ->where($db->qn('campaign_id') . ' = '.$this->campaign_id);
            
            $db->setQuery($q);
            $db->execute();
           
            require_once JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'marketingrocket.php';

            JTable::addIncludePath(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_marketingrocket'.DIRECTORY_SEPARATOR.'tables');
            $campaignTable = JTable::getInstance('Campaign', 'MarketingrocketTable');
            $campaignTable->load($this->campaign_id);

            $text = JText::sprintf(
                'COM_MARKETINGROCKET_LOG_CAMPAIGN_UNSUBSCRIBE',
                $campaignTable->name
            );

            MarketingrocketHelper::log('campaign', 'unsubscribe', $text, $this->lead_id, $this->campaign_id, '#__mrocket_campaign');
                
        }
        
        
        


}
