<?php
/**
 *  @package Marketing Rocket
 *  @copyright (C) 2014 - 2015 Marketing Rocket Consulting. All rights reserved.
 *  @license GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

/**
 * @property int $id
 * @property string $first_name
 * @property string $last_name
 * @property string $email
 * @property int $landing_id
 * @property int $published
 * @property string $created
 * @property string $modified
 * @property int $created_by
 * @property int $modified_by
 * @property string $form_data
 * @property int $lead_status
 * @property int $is_temp
 * @property string $note
 * @property string $converted_date
 * @property int $user_id
 * @property float $w_metter
 * @property int $w_last_log_id
 * @property bool $recieve_email
 *
 * Class MarketingrocketTableLead
 */
class MarketingrocketTableLead extends JTable
{

    public static $field_id = 'id';
    public static $field_first_name = 'first_name';
    public static $field_last_name = 'last_name';
    public static $field_email = 'email';
    public static $field_landing_id = 'landing_id';
    public static $field_published = 'published';
    public static $field_created = 'created';
    public static $field_modified = 'modified';
    public static $field_created_by = 'created_by';
    public static $field_modified_by = 'modified_by';
    public static $field_form_data = 'form_data';
    public static $field_lead_status = 'lead_status';
    public static $field_is_temp = 'is_temp';
    public static $field_note = 'note';
    public static $field_converted_date = 'converted_date';
    public static $field_user_id = 'user_id';
    public static $field_w_metter = 'w_metter';
    public static $field_w_last_log_id = 'last_log_id';
    public static $field_recieve_email = 'recieve_email';
    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->first_name;
    }

    /**
     * @param string $first_name
     */
    public function setFirstName($first_name)
    {
        $this->first_name = $first_name;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->last_name;
    }

    /**
     * @param string $last_name
     */
    public function setLastName($last_name)
    {
        $this->last_name = $last_name;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }

    /**
     * @return int
     */
    public function getLandingId()
    {
        return $this->landing_id;
    }

    /**
     * @param int $landing_id
     */
    public function setLandingId($landing_id)
    {
        $this->landing_id = $landing_id;
    }

    /**
     * @return int
     */
    public function getPublished()
    {
        return $this->published;
    }

    /**
     * @param int $published
     */
    public function setPublished($published)
    {
        $this->published = $published;
    }

    /**
     * @return string
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @param string $created
     */
    public function setCreated($created)
    {
        $this->created = $created;
    }

    /**
     * @return string
     */
    public function getModified()
    {
        return $this->modified;
    }

    /**
     * @param string $modified
     */
    public function setModified($modified)
    {
        $this->modified = $modified;
    }

    /**
     * @return int
     */
    public function getCreatedBy()
    {
        return $this->created_by;
    }

    /**
     * @param int $created_by
     */
    public function setCreatedBy($created_by)
    {
        $this->created_by = $created_by;
    }

    /**
     * @return int
     */
    public function getModifiedBy()
    {
        return $this->modified_by;
    }

    /**
     * @param int $modified_by
     */
    public function setModifiedBy($modified_by)
    {
        $this->modified_by = $modified_by;
    }

    /**
     * @return int
     */
    public function getLeadStatus()
    {
        return $this->lead_status;
    }

    /**
     * @param int $lead_status
     */
    public function setLeadStatus($lead_status)
    {
        $this->lead_status = $lead_status;
    }

    /**
     * @return int
     */
    public function getIsTemp()
    {
        return $this->is_temp;
    }

    /**
     * @param int $is_temp
     */
    public function setIsTemp($is_temp)
    {
        $this->is_temp = $is_temp;
    }

    /**
     * @return string
     */
    public function getNote()
    {
        return $this->note;
    }

    /**
     * @param string $note
     */
    public function setNote($note)
    {
        $this->note = $note;
    }

    /**
     * @return string
     */
    public function getConvertedDate()
    {
        return $this->converted_date;
    }

    /**
     * @param string $converted_date
     */
    public function setConvertedDate($converted_date)
    {
        $this->converted_date = $converted_date;
    }

    /**
     * @return int
     */
    public function getUserId()
    {
        return $this->user_id;
    }

    /**
     * @param int $user_id
     */
    public function setUserId($user_id)
    {
        $this->user_id = $user_id;
    }

    /**
     * @return float
     */
    public function getWMetter()
    {
        return $this->w_metter;
    }

    /**
     * @param float $w_metter
     */
    public function setWMetter($w_metter)
    {
        $this->w_metter = $w_metter;
    }

    /**
     * @return int
     */
    public function getWLastLogId()
    {
        return $this->w_last_log_id;
    }

    /**
     * @param int $w_last_log_id
     */
    public function setWLastLogId($w_last_log_id)
    {
        $this->w_last_log_id = $w_last_log_id;
    }

    /**
     * @return bool
     */
    public function isRecieveEmail()
    {
        return $this->recieve_email;
    }

    /**
     * @param bool $recieve_email
     */
    public function setRecieveEmail($recieve_email)
    {
        $this->recieve_email = $recieve_email;
    }


	/**
	 * Constructor
	 *
	 * @param JDatabaseDriver A database connector object
	 */
	public function __construct(&$db)
	{
		parent::__construct('#__mrocket_leads', 'id', $db);
	}

	public function store($updateNulls = false)
	{
            $date	= JFactory::getDate();
            $user	= JFactory::getUser();
            $isNew = true;
            if ($this->id) {
                $isNew = false;
                // Existing item
                $this->modified	= $date->toSql();
                $this->modified_by	= $user->get('id');

            } else {
                // so we don't touch either of these if they are set.
                if (!intval($this->created)) {
                    $this->created = $date->toSql();
                }
                if (empty($this->created_by)) {
                    $this->created_by = $user->get('id');
                }
            }

            $resualt = parent::store($updateNulls);

            // Attempt to store the user data.
            return $resualt;
	}
        
        public function getCampaigns(){
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            $q->select('campaign_id')->from('#__mrocket_lead_campaigns')
                    ->where('lead_id = '.$this->id);
            $db->setQuery($q);
            return $db->loadColumn();
        }
        
        public function isRegisteredInLanding($landingId){
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            $q->select('ref_code')->from('#__mrocket_refcodes')
                    ->where('lead_id = '.$this->id)
                    ->where('landing_id = '.(int)$landingId)
                    ;
            $db->setQuery($q);
            $res = $db->loadResult();
            if(!empty($res))
                return $res;
            else 
                return false;
        }
        
        public function getFormData(){
           $db = $this->getDbo();
           $q = $db->getQuery(true);
           $q->select('*')->from('#__mrocket_lead_details')
               ->where('lead_id = '.$this->id)
           ;
           $db->setQuery($q);
           
           $res = $db->loadObjectList();
           
           $data = array();
           
           foreach ($res as $row){
               $data[$row->field_name] = $row->value;
           }
           return $data;
        }
        
        public function getTags(){

           $db = $this->getDbo();
           $q = $db->getQuery(true);
           $q->select('tag_id')->from('#__mrocket_leads_tags')
               ->where('lead_id = '.$this->id)
           ;
           $db->setQuery($q);

           return $db->loadColumn();
        }

    /**
     * @param int $tagId
     * @return bool|JTable
     */
        public function hasTag($tagId){
            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
            $leadTagTable = JTable::getInstance('Leadtag', 'MarketingrocketTable');
            $leadTagTable->load(
                array(
                    MarketingrocketTableLeadtag::$field_lead_id => $this->getId(),
                    MarketingrocketTableLeadtag::$field_tag_id => $tagId
                )
            );
            if(!empty($leadTagTable->getId()))
                return $leadTagTable;
            return false;
        }

        public function addTag($tagId , $campaignId = 0){

            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
            $leadTagTable = JTable::getInstance('Leadtag', 'MarketingrocketTable');
            $leadTagTable->lead_id = $this->id;
            $leadTagTable->tag_id = $tagId;
            $leadTagTable->campaign_id = $campaignId;
            
            if($leadTagTable->check()){

                $leadTagTable->store();
            }
        }
        
        public function addStatus($statusId , $campaignId){
            $this->setStatus($statusId, $campaignId);
            return;
            
//            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
//            $leadTagTable = JTable::getInstance('Leadstatus', 'MarketingrocketTable');
//            $leadTagTable->lead_id = $this->id;
//            $leadTagTable->status_id = $statusId;
//            $leadTagTable->campaign_id = $campaignId;
//            
//            if($leadTagTable->check()){
//                $leadTagTable->store();
//            }
        }
        public function setStatus($statusId , $campaignId){
            JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
            $leadTagTable = JTable::getInstance('Leadstatus', 'MarketingrocketTable');
            $leadTagTable->load(array('lead_id' => $this->id, 'campaign_id' => $campaignId));
            if(empty($leadTagTable->id)){
                $leadTagTable->lead_id = $this->id;
                $leadTagTable->campaign_id = $campaignId;
            }
            else if($leadTagTable->status_id == $statusId)
                return true;
            
            $leadTagTable->status_id = $statusId;
            
            $leadTagTable->store();
        }
        
        public function addResponderSequence($id){
            
        }
        
        // TODO this function is not complete
        // Use this just for when session is not important , as this method not adding to session
        public function addRefCode($landingId = 0){
            $refCode = $this->_randomid(2).time().$this->_randomid(3);
            
            $db = JFactory::getDbo();
            $query = $db->getQuery(true);
            $query->insert ( $db->quoteName ( '#__mrocket_refcodes' ) );
            $query->set ( $db->qn('lead_id') .' = '.$db->q($this->id));
            $query->set ( $db->qn('landing_id') .' = '.$db->q($landingId));
            $query->set ( $db->qn('ref_code') .' = '.$db->q($refCode));
            $db->setQuery ( $query );
            $db->execute ();
            
            return $refCode;
            
        }
        
        private function _randomid($count=false)
	{
		if($count == FALSE)
			$count = 5;
		$text = "";
		$possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
		$possible = str_split($possible);
	
		for ($i = 0; $i < $count; $i++) {
			shuffle($possible);
			$text .= $possible[0];
		}
		return $text;
	}
        
        public function getRegisteredSequence(){
            $db = JFactory::getDbo();
            $query = $db->getQuery(true);
            
            $query->select('sequence_id')->from($db->qn('#__mrocket_leads_cron', 'a'))
                ->innerJoin($db->qn('#__mrocket_responder_templates', 'b').' ON a.responder_id = b.id')
                    ->where('a.lead_id = '.$db->q($this->id))
                    ->group('b.sequence_id');
            
            $db->setQuery($query);
            return $db->loadColumn();
        }
        
        public function removeResponderFromLead($responder_id){
            $db = $this->getDbo ();
            $q = $db->getQuery(true);
            $q->select('a.*')
                    ->from($db->qn('#__mrocket_leads_cron', 'a'))
                    ->innerJoin($db->qn('#__mrocket_responder_templates', 'b').' ON '.$db->qn('a.responder_id').' = '.$db->qn('b.id'))
                    ->where($db->qn('lead_id') .' = '.$db->q($this->id))
                    ->where($db->qn('b.sequence_id') .' = '.$db->q($responder_id))
                    ->where($db->qn('is_done') .' = 0');
            $db->setQuery($q);
            $res = $db->loadObjectList();
            foreach ($res as $row){
                $leadCron = JTable::getInstance('Leadcrons', 'MarketingrocketTable');
                $leadCron->bind($row);
                $leadCron->delete();
            }
        }

        public function addToCampaign($campaignId){
            $leadCampaign = JTable::getInstance('Leadcampaign', 'MarketingrocketTable');
            $leadCampaign->lead_id = $this->id;
            $leadCampaign->campaign_id = $campaignId;
            if($leadCampaign->check())
                $leadCampaign->store();
        }
        
        public function removeFromCampaign($campaignId){
            $leadCampaign = JTable::getInstance('Leadcampaign', 'MarketingrocketTable');
            $leadCampaign->load(array('lead_id' => $this->id, 'campaign_id' => $campaignId));
            $leadCampaign->delete();
        }
        
        public function isConverted(){
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            
            $q->select($db->qn('a.id'))->from($db->qn('#__mrocket_lead_statuses', 'a'))
                    ->innerJoin($db->qn('#__mrocket_statuses', 'b').' ON '.$db->qn('a.status_id').' = '.$db->qn('b.id').' AND '.$db->qn('b.final').' = 1')
                    ->where($db->qn('a.lead_id').' = '.$db->q($this->id))
                ;
            
            $db->setQuery($q);
            return $db->loadResult();
        }
        public function convert(){
            $db = $this->getDbo();
            $q = $db->getQuery(true);
            
            $q->select($db->qn('id'))
                    ->from($db->qn('#__mrocket_statuses'))
                    ->where($db->qn('final').' = '.$db->q(1))
                ;
            
            $db->setQuery($q);
            $id = $db->loadResult();
            if(!empty($id)){
                
                $campaigns = $this->getCampaigns();
                
                $this->setStatus($id, $campaigns[0]);
            }
        }

    /**
     * @param string $email
     * @param string $firstName
     * @param string $lastName
     * @param int $published
     * @param string $formName
     * @param int $userId
     * @return bool|JTable
     */
    public static function createLead($email, $firstName, $lastName, $published, $formName, $userId = 0){
        return self::createLeadComplete($email, $firstName, $lastName, $published, $formName, $userId, 0);

    }

    /**
     * @param string $email
     * @param string $firstName
     * @param string $lastName
     * @param int $published
     * @param string $formName
     * @param int $userId
     * @return bool|JTable
     */
    public static function createTempLead($email, $firstName, $lastName, $published, $formName, $userId = 0){
        return self::createLeadComplete($email, $firstName, $lastName, $published, $formName, $userId, 1);
    }

    /**
     * @param string $email
     * @param string $firstName
     * @param string $lastName
     * @param int $published
     * @param string $formName
     * @param int $isTemp
     * @param int $userId
     * @return bool|JTable
     */
        private static function createLeadComplete($email, $firstName, $lastName, $published, $formName, $userId, $isTemp){
            $lead = self::getInstance('Lead', 'MarketingRocketTable');
            $lead->email = $email;
            $lead->first_name = $firstName;
            $lead->last_name = $lastName;
            $lead->published = $published;
            $lead->is_temp = $isTemp;
            $lead->user_id = $userId;

            $lead->store();
            $lead->addRefCode();
            self::createDetailRow(0, $lead->id, 'MR_form_name', $formName);
            self::createDetailRow(0, $lead->id, 'MR_submited_date', JFactory::getDate()->toSql());

            return $lead;

        }

    /**
     * @param int $landingId
     * @param int $leadId
     * @param string $fieldName
     * @param string $value
     * @return bool|JTable
     */
        public static function createDetailRow($landingId, $leadId, $fieldName, $value){
            $leadDetailsTable = JTable::getInstance('Leaddetails', 'MarketingrocketTable');
            $leadDetailsTable->landing_id = $landingId;
            $leadDetailsTable->lead_id = $leadId;
            $leadDetailsTable->field_name = $fieldName;
            $leadDetailsTable->value = $value;
            $leadDetailsTable->store();
            return $leadDetailsTable;
        }

}
